#include "StdAfx.h"
#include "joystick.h"

Joystick::Joystick(void)
{
	joyok=false;
}

Joystick::~Joystick(void)
{
	if(joyok) myjoy.FreeDirectInput();
}

void Joystick::Close()
{
	if(joyok) myjoy.FreeDirectInput();
}

int Joystick::start(HWND hwnd,int numjoy)
{
	chwnd=hwnd;
	joyok=false;

	HRESULT p;
	if (FAILED (p= myjoy.InitDirectInput(hwnd,numjoy))) {
		joyok=false;
		MessageBox(hwnd,"Joystick not found","error",NULL);
	}
	else joyok=true;

return joyok;
}

CPoint Joystick::GetJoyVal(int RobType)
{
CPoint point;
myjoy.UpdateInputState(chwnd);

if(RobType==2){
	point.x=myjoy.js.lX;
	if(myjoy.js.rgbButtons[0]==128){
		point.y=myjoy.js.lY;
	}
	else{
		point.y=myjoy.js.lY/5;
	}
}
else if (RobType==1||RobType==3){
	point.x=(int)myjoy.js.lX*60/1000;
	point.y=(int)myjoy.js.lY*60/1000;
}
return point;
}
void Joystick::ControlPanel()
{
	myjoy.RunControlPanel();
}