                            // FolderBrowser.cpp //
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                 INTEL CORPORATION PROPRIETARY INFORMATION                 //
//    This software is supplied under the terms of a license agreement or    //
//   nondisclosure agreement with Intel Corporation and may not be copied    //
//    or disclosed except in accordance with the terms of that agreement.    //
//        Copyright (c) 1998 Intel Corporation. All Rights Reserved.         //
//                                                                           //
//  Project:                                                                 //
//                                                                           //
//  Purpose:                                                                 //
//                                                                           //
//  Author(s):                                                               //
//    Paul V. Pervov                                                         //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

#ifndef __FOLDERBORWSER_H__
#include "FolderBrowser.h"
#endif

///////////////////////////////////////////////////////////////////////////////
//                          Global subclassed items                          //
///////////////////////////////////////////////////////////////////////////////

CFolderTree* g_CurrentFT = NULL;
CFolderBrowser* g_CurrentFB = NULL;


///////////////////////////////////////////////////////////////////////////////
//                                CFolderTree                                //
///////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(CFolderTree, CTreeCtrl)
    //{{AFX_MSG_MAP(CFolderTree)
    ON_NOTIFY_REFLECT(TVN_ITEMEXPANDEDW, OnItemExpanded)
    ON_NOTIFY_REFLECT(TVN_SELCHANGEDW, OnSelChanged)
    ON_NOTIFY_REFLECT(TVN_ITEMEXPANDINGW, OnItemExpanding)
    ON_NOTIFY_REFLECT(TVN_ITEMEXPANDEDA, OnItemExpanded)
    ON_NOTIFY_REFLECT(TVN_SELCHANGEDA, OnSelChanged)
    ON_NOTIFY_REFLECT(TVN_ITEMEXPANDINGA, OnItemExpanding)
    ON_WM_PAINT()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


// CFolderTree message handlers

void CFolderTree::OnItemExpanded(NMHDR* pNMHDR, LRESULT* pResult)
{
    *pResult = 0;

    if( HasEmptyMask() ) return;

    NM_TREEVIEW* tvnm = (NM_TREEVIEW*)pNMHDR;
    int flags = tvnm->action;

    if( flags&TVE_EXPAND )
    {
        // item is really expanded
        CString message;
        TRACE( "CFolderTree::OnItemExpanded\n" );
        TV_ITEM& tvi = tvnm->itemNew;
        HTREEITEM hChild = GetChildItem( tvi.hItem );
        CString name;
        if( hChild != NULL )
        {
            RECT rectItem;
            name = GetItemText( hChild );
            TRACE( "  Enumerating \"%s\"\n", name );
            if( HasMaskedFiles( TracePathToRoot( hChild ) ) )
            {
                GetItemRect( hChild, &rectItem, FALSE );
                m_item.SetAt( reinterpret_cast<HANDLE>(hChild), rectItem );
            }
            while( (hChild = GetNextSiblingItem( hChild )) != NULL )
            {
                name = GetItemText( hChild );
                TRACE( "  Enumerating \"%s\"\n", name );
                if( HasMaskedFiles( TracePathToRoot( hChild ) ) )
                {
                    GetItemRect( hChild, &rectItem, FALSE );
                    m_item.SetAt( reinterpret_cast<HANDLE>(hChild), rectItem );
                }
            }
        }
    }
}


void CFolderTree::OnSelChanged(NMHDR* pNMHDR, LRESULT* pResult)
{
    *pResult = 0;

    if( HasEmptyMask() ) return;

    NM_TREEVIEW* tvnm = (NM_TREEVIEW*)pNMHDR;

    CString path;
    TRACE( "CFolderTree::OnSelChanged\n" );
    TV_ITEM& tvi = tvnm->itemNew;

    if( tvi.hItem == GetRootItem() ) return;

    ASSERT_VALID( g_CurrentFB );
    g_CurrentFB->SetDirectory( TracePathToRoot( tvi.hItem ) );
}


void CFolderTree::OnItemExpanding(NMHDR* pNMHDR, LRESULT* pResult)
{
    *pResult = 0;

    if( HasEmptyMask() ) return;

    NM_TREEVIEW* nmtv = (NM_TREEVIEW*)pNMHDR;

    TV_ITEM& tvi = nmtv->itemNew;

    if( nmtv->action&TVE_COLLAPSERESET )
    {
        // if item collapsing and deleting its children we need to remove
        // collapsing items from the list of items containing masked files
        TRACE( "CFolderTree::OnItemExpanding\n" );

        HTREEITEM hChild = GetChildItem( tvi.hItem );
        RECT dummy;
        if( hChild != NULL )
        {
            if( m_item.Lookup( hChild, dummy ) )
            {
                m_item.RemoveKey( hChild );
            }
        }
        while( (hChild = GetNextSiblingItem( hChild )) != NULL )
        {
            if( m_item.Lookup( hChild, dummy ) )
            {
                m_item.RemoveKey( hChild );
            }
        }
    }
}


void CFolderTree::OnPaint()
{
    CPaintDC dc(this);

    DefWindowProc( WM_PAINT, reinterpret_cast<WPARAM>(dc.m_hDC), 0 );

    // walk through the map and draw items that are visible
    // items are drawn edged
    POSITION posCurrent;
    HTREEITEM hTreeItem;
    HANDLE hCurrent;
    RECT rectCurrent;
    RECT rectGot;
    posCurrent = m_item.GetStartPosition();
    while( posCurrent != NULL )
    {
        m_item.GetNextAssoc( posCurrent, hCurrent, rectCurrent );
        hTreeItem = reinterpret_cast<HTREEITEM>(hCurrent);
        TRACE( "Item 0x%08X with rectangle (%d %d %d %d)\n",
            hCurrent, rectCurrent.left, rectCurrent.top, rectCurrent.right,
            rectCurrent.bottom );
        if( GetItemRect( hTreeItem, &rectGot, FALSE ) )
        {
            //rectGot.left += indent*GetIndentLevel( hTreeItem );
            //rectGot.left += indent;
            dc.DrawEdge( &rectGot, EDGE_RAISED, BF_RECT );
        }
    }
}


bool CFolderTree::HasMaskedFiles( CString path )
{
    WIN32_FIND_DATA fd;
    CString toSearch;
    toSearch = path;
    if( toSearch.ReverseFind( _T('\\') ) != toSearch.GetLength() )
    {
        toSearch += _T('\\');
    }
    toSearch += m_mask;
    HANDLE hSearch = FindFirstFile( toSearch, &fd );
    if( hSearch != INVALID_HANDLE_VALUE )
    {
        FindClose( hSearch );
        return true;
    }
    return false;
}


CString CFolderTree::TracePathToRoot( HTREEITEM tvi )
{
    bool bRoot = true;
    CString path = GetItemText( tvi );
    TV_ITEM item;
    item.hItem = tvi;
    CString name;
    const int nameLen = MAX_PATH;
    while( true )
    {
        HTREEITEM hParent = GetParentItem( item.hItem );
        if( hParent == GetRootItem() ) break;
        HTREEITEM hRoot = GetParentItem( hParent );
        bRoot = false;
        item.hItem = GetParentItem( item.hItem );
        if( hRoot == GetRootItem() ) break;
        item.mask = TVIF_HANDLE | TVIF_TEXT;
        item.pszText = name.GetBuffer( nameLen );
        item.cchTextMax = nameLen;
        GetItem( &item );
        name.ReleaseBuffer();
        path = name + _T("\\") + path;
    }
    CString root;
    item.mask = TVIF_HANDLE | TVIF_TEXT;
    item.pszText = root.GetBuffer( nameLen );
    item.cchTextMax = nameLen;
    GetItem( &item );
    root.ReleaseBuffer();
    const TCHAR openBracket = _T('(');
    const TCHAR closeBracket = _T(')');
    root = root.Left( root.ReverseFind( closeBracket ) );
    root = root.Right( root.GetLength() -
                       root.ReverseFind( openBracket ) - 1 );

    if( bRoot )
    {
        path = root;
    }
    else
    {
        path = root + _T("\\") + path;
    }

    path += _T("\\");

    return path;
}


/*
UINT CFolderTree::GetIndentLevel( HTREEITEM hItem )
{
    UINT result = 0;
    HTREEITEM hCurrent = hItem;
    while( hCurrent != GetRootItem() )
    {
        hCurrent = GetParentItem( hCurrent );
        result++;
    }
    return result;
}
*/

///////////////////////////////////////////////////////////////////////////////
//                           CFolderBrowser dialog                           //
///////////////////////////////////////////////////////////////////////////////

CFolderBrowser::CFolderBrowser( CWnd* pParentWnd )
    : CDialog()
{
    //{{AFX_DATA_INIT(CFolderBrowser)
    m_directory = _T("");
    m_parentWnd = pParentWnd;
    m_bSubclassedAll = false;
    //}}AFX_DATA_INIT
    m_tree.SetMask( _T("*.*") );
}


CFolderBrowser::~CFolderBrowser()
{
    m_directory = _T("");
    m_tree.SetMask( _T("*.*") );
    m_parentWnd = NULL;
    m_bSubclassedAll = false;
}


#include <shlobj.h>

int __stdcall BrowseCallback( HWND hWnd, UINT uMsg, LPARAM, LPARAM )
{
    if( uMsg != BFFM_INITIALIZED ) return 0;

    ASSERT( ::IsWindow( hWnd ) );

    BOOL bResult = g_CurrentFB->SubclassWindow( hWnd );
    if( !bResult ) return 0;

    if( !g_CurrentFB->m_bSubclassedAll )
    {
        HWND hUWnd;
        hUWnd = g_CurrentFB->UnsubclassWindow();
        ASSERT( hUWnd == hWnd );
    }

    return 0;
}


bool CFolderBrowser::Browse( CString mask )
{
    m_tree.SetMask( mask );
    BROWSEINFO bi;

    ASSERT_VALID( m_parentWnd );
    bi.hwndOwner = m_parentWnd->m_hWnd;

    SHGetSpecialFolderLocation( bi.hwndOwner, CSIDL_DRIVES,
        const_cast<LPITEMIDLIST*>(&bi.pidlRoot) );
    bi.pszDisplayName = NULL;
    bi.lpszTitle = _T("Select folder to view from:");
    bi.ulFlags = BIF_RETURNONLYFSDIRS;
    bi.lpfn = BrowseCallback;
    bi.lParam = 0;
    bi.iImage = 0;
    g_CurrentFB = this;
    g_CurrentFT = &m_tree;
    LPITEMIDLIST piil = SHBrowseForFolder( &bi );
    g_CurrentFB = NULL;
    g_CurrentFT = NULL;

    CoTaskMemFree( piil );

    return (piil != NULL);
}


void CFolderBrowser::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CFolderBrowser)
    //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFolderBrowser, CDialog)
    //{{AFX_MSG_MAP(CFolderBrowser)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

// CFolderBrowser message handlers

BOOL CALLBACK EnumChild( HWND hWnd, LPARAM retval )
{
    ASSERT( ::IsWindow( hWnd ) );

    int* res = reinterpret_cast<int*>(retval);
    CString name;
    const int bufLen = 256;
    BOOL bResult = TRUE;
    int result = GetClassName( hWnd, name.GetBuffer( bufLen ), bufLen );
    name.ReleaseBuffer();
    if( result )
    {
        if( !name.CompareNoCase( _T("SYSTREEVIEW32") ) )
        {
            bResult = g_CurrentFT->SubclassWindow( hWnd );
            if( !bResult )
            {
                *res = 0;
            }
            *res = 1;
        }
    }

    return bResult;
}


void CFolderBrowser::PreSubclassWindow()
{
    ASSERT( ::IsWindow( g_CurrentFB->m_hWnd ) );
    int result;

    EnumChildWindows( g_CurrentFB->m_hWnd, EnumChild,
        reinterpret_cast<LPARAM>(&result) );

    m_bSubclassedAll = (result == 1);

    CDialog::PreSubclassWindow();
}


BOOL CFolderBrowser::OnCommand(WPARAM wParam, LPARAM lParam)
{
    if( LOWORD( wParam ) == IDOK )
    {
        TRACE( "We can unsubclass here !!!\n" );
        HWND hWnd;
        hWnd = m_hWnd;
        // we need to unsubclass in order to normal window termination
        UnsubclassWindow();
        // pass the message to underlying dialog
        WNDPROC proc =
            reinterpret_cast<WNDPROC>(GetWindowLong( hWnd, GWL_WNDPROC ));
        CallWindowProc( proc, hWnd, WM_COMMAND, wParam, lParam );
        TRACE( "Returning\n" );
        return 0;
    }

    return CDialog::OnCommand(wParam, lParam);
}


BOOL CFolderBrowser::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
    TRACE( "CDialog::OnNotify\n" );
    CDialog::OnNotify(wParam, lParam, pResult);

    return FALSE; // force subclassed dialog to process the message
}

///////////////////////////////////////////////////////////////////////////////
//                      End of file 'FolderBrowser.cpp'                      //
///////////////////////////////////////////////////////////////////////////////
