                              /* JPGViewView.h */
/*/////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                 INTEL CORPORATION PROPRIETARY INFORMATION                 //
//    This software is supplied under the terms of a license agreement or    //
//   nondisclosure agreement with Intel Corporation and may not be copied    //
//    or disclosed except in accordance with the terms of that agreement.    //
//        Copyright (c) 1998 Intel Corporation. All Rights Reserved.         //
//                                                                           //
//  Project:                                                                 //
//    IJL                                                                    //
//  Purpose:                                                                 //
//    JPEG viewer                                                            //
//  Author(s):                                                               //
//    Paul V. Pervov                                                         //
//                                                                           */
#ifndef __JPGVIEWVIEW_H__ /*/////////////////////////////////////////////////*/
#define __JPGVIEWVIEW_H__
#ifdef _FULLDIAG
#pragma message( "  JPGViewView.h")
#endif

#include <afxtempl.h>


/*/////////////////////////////////////////////////////////////////////////////
//                          CImageInfoDlg dialog                             //
/////////////////////////////////////////////////////////////////////////////*/

class CImageInfoDlg : public CDialog
{
public:
    CImageInfoDlg(CWnd* pParent = NULL);   // standard constructor

    //{{AFX_DATA(CImageInfoDlg)
    enum { IDD = IDD_IMAGEINFO };
    DWORD m_width;
    DWORD m_height;
    DWORD m_colors;
    //}}AFX_DATA


// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CImageInfoDlg)
    protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    //}}AFX_VIRTUAL

// Implementation
protected:

    // Generated message map functions
    //{{AFX_MSG(CImageInfoDlg)
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};


/*/////////////////////////////////////////////////////////////////////////////
//                            COptionsDlg dialog                             //
/////////////////////////////////////////////////////////////////////////////*/

class COptionsDlg : public CDialog
{
public:
    COptionsDlg(CWnd* pParent = NULL);

    //{{AFX_DATA(COptionsDlg)
    enum { IDD = IDD_OPTIONSDIALOG };
    BOOL    m_bResizeWithImage;
    BOOL    m_bCenterToPrev;
    BOOL    m_bCenterInWindow;
    BOOL    m_bScaleToFit;
    BOOL    m_bCenterOnPage;
    //}}AFX_DATA


    //{{AFX_VIRTUAL(COptionsDlg)
protected:
    virtual void DoDataExchange(CDataExchange* pDX);
    //}}AFX_VIRTUAL

protected:

    //{{AFX_MSG(COptionsDlg)
    afx_msg void OnResizeWithImage();
    afx_msg void OnScaleToFit();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};


/*/////////////////////////////////////////////////////////////////////////////
//                               CJPGViewView                                //
/////////////////////////////////////////////////////////////////////////////*/

class CJPGViewView : public CScrollView
{
    friend UINT APIENTRY PrintHook( HWND, UINT, WPARAM, LPARAM );
public:
    CJPGViewDoc* GetDocument();

    virtual ~CJPGViewView();
#ifdef _DEBUG
    virtual void AssertValid() const;
    virtual void Dump( CDumpContext& dc ) const;
#endif

    //{{AFX_VIRTUAL(CJPGViewView)
    public:
    virtual void OnDraw( CDC* pDC );  // overridden to draw this view
    virtual BOOL PreCreateWindow( CREATESTRUCT& cs );
    virtual void OnInitialUpdate();
    protected:
    virtual BOOL OnPreparePrinting( CPrintInfo* pInfo );
    virtual void OnBeginPrinting( CDC* pDC, CPrintInfo* pInfo );
    virtual void OnEndPrinting( CDC* pDC, CPrintInfo* pInfo );
    //}}AFX_VIRTUAL

    CJPGViewView();
    DECLARE_DYNCREATE( CJPGViewView )

    //{{AFX_MSG(CJPGViewView)
    afx_msg void OnFileSelectDirectory();
    afx_msg void OnViewNextImage();
    afx_msg void OnViewPrevImage();
    afx_msg void OnViewImageInfo();
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnDestroy();
    afx_msg void OnViewOptions();
    afx_msg void OnUpdateViewNext(CCmdUI* pCmdUI);
    afx_msg void OnUpdateViewPrev(CCmdUI* pCmdUI);
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()

    BITMAPINFO                  m_bmi;
    BYTE*                       m_bmp;
    bool                        m_bResizeWithImage;
    bool                        m_bCenterToPrev;
    bool                        m_bCenterInWindow;
    bool                        m_bScaleToFit;
    bool                        m_bCenterOnPage;

    CArray< CString, CString& > m_list;
    int                         m_imageIndex;
    bool                        m_bViewFolder;
    CString                     m_directory;

    void CreateImageList();
    void ResizeImageWindow();
    void OpenValidDocument( CString docName, bool bDirection );
    void OnSaveAs();
};


#ifndef _DEBUG  // debug version in JPGViewView.cpp
inline CJPGViewDoc* CJPGViewView::GetDocument()
{
    return (CJPGViewDoc*)m_pDocument;
}
#endif

//{{AFX_INSERT_LOCATION}}

#endif /*//////////////////////////////////////////////////////////////////////
//                        End of file 'JPGViewView.h'                        //
/////////////////////////////////////////////////////////////////////////////*/
