#include ".\WinView.h"

COScopeCtrl myscope(4);

WinView::WinView(void)
{
	bDone = false;		
}

WinView::~WinView(void)
{
}

void WinView::SetSpeedData(double vfr,double vfl,double vrr,double vrl)
{
	speedmutex.acquire();
	m_dPlotData[ 0 ] = vfr;
	m_dPlotData[ 1 ] =  vfl;
	m_dPlotData[ 2 ] = vrr;
	m_dPlotData[ 3 ] = vrl;
	speedmutex.release();
}

void WinView::Open()
{
	running=true;
	bDone = false;
    AfxBeginThread(run,this);	
}

void WinView::Close()
{
	bDone = true;
	::DestroyWindow(hWnd);	
}

void WinView::Thread(void)
{
	while(ThreadRun)
	{	
	speedmutex.acquire();
	myscope.AppendPoints(m_dPlotData);
	speedmutex.release();
	Sleep(60);
	}	
}

UINT WinView::Thread(LPVOID p)
{
   WinView *me = (WinView *)p;
   me->Thread();
   return 0;
}

void WinView::run(void)
{
	// create the dialog window
	int wmId; 
	int wmEvent; 
	hWnd = ::CreateDialog(NULL,MAKEINTRESOURCE(IDD_DIALOGView),NULL,NULL);
	if(hWnd!=NULL)
	{
		// show dialog
		::ShowWindow(hWnd,SW_SHOW);
		CRect rect;
		::GetDlgItem(this->hWnd,IDC_OSCOPE);
		::GetWindowRect(this->hWnd,rect) ;
		//ScreenToClient(this->hWnd,rect) ;
		// create the control
		CWnd* m_Window = CWnd::FindWindow(0,"scope");
		myscope.Create(WS_VISIBLE | WS_CHILD, rect, m_Window) ;
		// customize the control
		myscope.m_nXGrids = 5;
		myscope.m_nYGrids = 8;
		myscope.m_nYDecimals = 1;
		myscope.m_nTrendPoints = 20;
		myscope.SetRange( 0.0,  70.0, 0 );
		myscope.SetRange( 0.0,  70.0, 1 );
		myscope.SetRange( 0.0,  70.0, 2 );
		myscope.SetRange( 0.0,  70.0, 3 );
		myscope.SetYUnits( "voltage" ) ;
		myscope.SetXUnits( "E", "R", "L" ) ; // That's why I added strings in SetXUnits
		myscope.SetBackgroundColor(RGB(0, 0, 64)) ;
		myscope.SetGridColor(RGB(192, 192, 255)) ;
		ThreadRun=true;
		AfxBeginThread(Thread,this);
	}
	else
	{
		printf("Failed to create dialog\n");
		bDone = true;
		return;
	}
	
	// message loop to process user input
	MSG msg;
	while(!bDone)
	{
		if(::PeekMessage(&msg,hWnd,0,0,PM_REMOVE))
		{
	    	switch (msg.message) {
					
			case WM_COMMAND:
				wmId    = LOWORD(msg.wParam); 
				wmEvent = HIWORD(msg.wParam); 
				// Parse the menu selections:
				switch (wmId)
				{				
				case 2:
					ThreadRun=false;
					bDone = true;
					DestroyWindow(hWnd);
					break;				
				}
			break;		
			}			
			// process message
			::TranslateMessage(&msg);
			::DispatchMessage(&msg);
		}
		else
		{
			// if there is no message to process, 
			// then sleep for a while to avoid burning
			// too much CPU cycles
			::Sleep(100);
		}
	}
}

UINT WinView::run(LPVOID p)
{
   WinView *me = (WinView *)p;
   me->run();
   return 0;
}