#include ".\wifibotwin.h"

CVORegistry m_reg(HKEY_LOCAL_MACHINE, TEXT("Software\\wifibot\\wifibotpcgui"));

wifibotwin::wifibotwin(void)
{
	bDone = false;		
}

wifibotwin::~wifibotwin(void)
{
}

void wifibotwin::GetIPconf()
{
	robotipconf.RobotIP=m_reg.ReadString(TEXT("robotip"), TEXT("192.168.0.6"));
	robotipconf.RobotPort=m_reg.ReadString(TEXT("robotport"), TEXT("15020"));
	robotipconf.CamIP=m_reg.ReadString(TEXT("camip"), TEXT("192.168.0.90"));	
	robotipconf.CamPort=m_reg.ReadString(TEXT("camport"), TEXT("80"));
	robotipconf.CamType=m_reg.ReadString(TEXT("camtype"), TEXT("DCS900"));
	robotipconf.Com_Sleep_ms=m_reg.ReadString(TEXT("comsleepms"), TEXT("80"));
	robotipconf.Com_ms=m_reg.ReadString(TEXT("comms"), TEXT("80"));
	robotipconf.snr_spy_ip=m_reg.ReadString(TEXT("snrspyip"), TEXT("172.16.0.2"));
	robotipconf.topology_ip=m_reg.ReadString(TEXT("topologyip"), TEXT("172.16.0.2"));
	robotipconf.Udp=m_reg.ReadString(TEXT("udp"), TEXT("0"));
	robotipconf.JoyNum=m_reg.ReadString(TEXT("joynum"), TEXT("1"));
	robotipconf.RobotType=m_reg.ReadString(TEXT("robottype"), TEXT("1"));
	robotipconf.MJPEGType=m_reg.ReadString(TEXT("mjpegtype"), TEXT("1"));
}

void wifibotwin::SetIPconf()
{
	m_reg.WriteString(TEXT("robotip"), robotipconf.RobotIP);
	m_reg.WriteString(TEXT("robotport"), robotipconf.RobotPort);
	m_reg.WriteString(TEXT("camip"), robotipconf.CamIP);
	m_reg.WriteString(TEXT("camport"), robotipconf.CamPort);
	m_reg.WriteString(TEXT("camtype"), robotipconf.CamType);
	m_reg.WriteString(TEXT("comsleepms"), robotipconf.Com_Sleep_ms);
	m_reg.WriteString(TEXT("comms"), robotipconf.Com_ms);	
	m_reg.WriteString(TEXT("snrspyip"), robotipconf.snr_spy_ip);
	m_reg.WriteString(TEXT("topologyip"), robotipconf.topology_ip);
	m_reg.WriteString(TEXT("udp"), robotipconf.Udp);
	m_reg.WriteString(TEXT("joynum"), robotipconf.JoyNum);
	m_reg.WriteString(TEXT("robottype"), robotipconf.RobotType);
	m_reg.WriteString(TEXT("mjpegtype"), robotipconf.MJPEGType);
}

void wifibotwin::Open()
{
	running=true;
	bDone = false;
    AfxBeginThread(run,this);	
}

void wifibotwin::Close()
{
	bDone = true;
	::DestroyWindow(hWnd);	
}

/*Object* wifibotwin::core (Object* param)
{


return 0;
}*/

void wifibotwin::run(void)
{
	// create the dialog window
	int wmId; 
	int wmEvent; 
	hWnd = ::CreateDialog(NULL,MAKEINTRESOURCE(IDD_DIALOG),NULL,NULL);
	if(hWnd!=NULL)
	{
		// show dialog
		::ShowWindow(hWnd,SW_SHOW);
	}
	else
	{
		printf("Failed to create dialog\n");
		bDone = true;
		return;
	}
	GetIPconf();
	hEditRobotIP = ::GetDlgItem(hWnd,IDC_EDIT);
	hEditRobotPort = ::GetDlgItem(hWnd,IDC_EDIT2);
	hEditCamIP = ::GetDlgItem(hWnd,IDC_EDIT1);
	hEditCamPort = ::GetDlgItem(hWnd,IDC_EDIT3);
	hEditCamType = ::GetDlgItem(hWnd,IDC_EDIT4);
	hEditComSleepMs = ::GetDlgItem(hWnd,IDC_EDIT5);
	hEditComMs = ::GetDlgItem(hWnd,IDC_EDIT6);
	hEditSnrSpyIp = ::GetDlgItem(hWnd,IDC_EDIT7);
	hEditTopologyIp = ::GetDlgItem(hWnd,IDC_EDIT8);
	hEditJoyNum = ::GetDlgItem(hWnd,IDC_EDIT9);
	hEditRobotType = ::GetDlgItem(hWnd,IDC_EDIT10);
	hEditMjpegType = ::GetDlgItem(hWnd,IDC_EDIT_MJPEG_TYPE);

	if (robotipconf.Udp=="1") SendDlgItemMessage(hWnd, IDC_CHECK5, BM_SETCHECK, 1, 0);
	else if (robotipconf.Udp=="0") SendDlgItemMessage(hWnd, IDC_CHECK5, BM_SETCHECK, 0, 0);

	if (robotipconf.CamType=="MJPEGPTU") 
	{
		SendDlgItemMessage(hWnd, IDC_CHECK1, BM_SETCHECK, 1, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK2, BM_SETCHECK, 0, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK3, BM_SETCHECK, 0, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK4, BM_SETCHECK, 0, 0);
	}
	else if (robotipconf.CamType=="MPEG4PTU") 
	{
		SendDlgItemMessage(hWnd, IDC_CHECK1, BM_SETCHECK, 0, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK2, BM_SETCHECK, 1, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK3, BM_SETCHECK, 0, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK4, BM_SETCHECK, 0, 0);
	}
	else if (robotipconf.CamType=="DCS900") 
	{
		SendDlgItemMessage(hWnd, IDC_CHECK1, BM_SETCHECK, 0, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK2, BM_SETCHECK, 0, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK3, BM_SETCHECK, 1, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK4, BM_SETCHECK, 0, 0);
	}
	else if (robotipconf.CamType=="WEBCAM") 
	{
		SendDlgItemMessage(hWnd, IDC_CHECK1, BM_SETCHECK, 0, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK2, BM_SETCHECK, 0, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK3, BM_SETCHECK, 0, 0);
		SendDlgItemMessage(hWnd, IDC_CHECK4, BM_SETCHECK, 1, 0);
	}
	::SetWindowText(hEditRobotIP,robotipconf.RobotIP);
	::SetWindowText(hEditRobotPort,robotipconf.RobotPort);
	::SetWindowText(hEditCamIP,robotipconf.CamIP);
	::SetWindowText(hEditCamPort,robotipconf.CamPort);
	::SetWindowText(hEditCamType,robotipconf.CamType);
	::SetWindowText(hEditComSleepMs,robotipconf.Com_Sleep_ms);
	::SetWindowText(hEditComMs,robotipconf.Com_ms);
	::SetWindowText(hEditSnrSpyIp,robotipconf.snr_spy_ip);
	::SetWindowText(hEditTopologyIp,robotipconf.topology_ip);
	::SetWindowText(hEditJoyNum,robotipconf.JoyNum);
	::SetWindowText(hEditRobotType,robotipconf.RobotType);
	::SetWindowText(hEditMjpegType,robotipconf.MJPEGType);
	// message loop to process user input
	MSG msg;
	while(!bDone)
	{
		if ((SendDlgItemMessage(hWnd, IDC_CHECK1, BM_GETCHECK, 0, 0))&&
			((SendDlgItemMessage(hWnd, IDC_CHECK2, BM_GETCHECK, 0, 0))||
			(SendDlgItemMessage(hWnd, IDC_CHECK3, BM_GETCHECK, 0, 0))||
			(SendDlgItemMessage(hWnd, IDC_CHECK4, BM_GETCHECK, 0, 0))))		
		{
			SendDlgItemMessage(hWnd, IDC_CHECK2, BM_SETCHECK, 0, 0);
			SendDlgItemMessage(hWnd, IDC_CHECK3, BM_SETCHECK, 0, 0);
			SendDlgItemMessage(hWnd, IDC_CHECK4, BM_SETCHECK, 0, 0);
		}
		else if ((SendDlgItemMessage(hWnd, IDC_CHECK2, BM_GETCHECK, 0, 0))&&
			((SendDlgItemMessage(hWnd, IDC_CHECK1, BM_GETCHECK, 0, 0))||
			(SendDlgItemMessage(hWnd, IDC_CHECK3, BM_GETCHECK, 0, 0))||
			(SendDlgItemMessage(hWnd, IDC_CHECK4, BM_GETCHECK, 0, 0))))			
		{
			SendDlgItemMessage(hWnd, IDC_CHECK1, BM_SETCHECK, 0, 0);
			SendDlgItemMessage(hWnd, IDC_CHECK3, BM_SETCHECK, 0, 0);
			SendDlgItemMessage(hWnd, IDC_CHECK4, BM_SETCHECK, 0, 0);
		}		
		else if ((SendDlgItemMessage(hWnd, IDC_CHECK3, BM_GETCHECK, 0, 0))&&
			((SendDlgItemMessage(hWnd, IDC_CHECK1, BM_GETCHECK, 0, 0))||
			(SendDlgItemMessage(hWnd, IDC_CHECK2, BM_GETCHECK, 0, 0))||
			(SendDlgItemMessage(hWnd, IDC_CHECK4, BM_GETCHECK, 0, 0))))
			{
			SendDlgItemMessage(hWnd, IDC_CHECK1, BM_SETCHECK, 0, 0);
			SendDlgItemMessage(hWnd, IDC_CHECK2, BM_SETCHECK, 0, 0);
			SendDlgItemMessage(hWnd, IDC_CHECK4, BM_SETCHECK, 0, 0);
		}
		else if ((SendDlgItemMessage(hWnd, IDC_CHECK4, BM_GETCHECK, 0, 0))&&
			((SendDlgItemMessage(hWnd, IDC_CHECK1, BM_GETCHECK, 0, 0))||
			(SendDlgItemMessage(hWnd, IDC_CHECK2, BM_GETCHECK, 0, 0))||
			(SendDlgItemMessage(hWnd, IDC_CHECK3, BM_GETCHECK, 0, 0))))
			{
			SendDlgItemMessage(hWnd, IDC_CHECK1, BM_SETCHECK, 0, 0);
			SendDlgItemMessage(hWnd, IDC_CHECK2, BM_SETCHECK, 0, 0);
			SendDlgItemMessage(hWnd, IDC_CHECK3, BM_SETCHECK, 0, 0);
		}
		if(::PeekMessage(&msg,hWnd,0,0,PM_REMOVE))
		{
			
			switch (msg.message) {
		
			
			case WM_COMMAND:
				wmId    = LOWORD(msg.wParam); 
				wmEvent = HIWORD(msg.wParam); 
				// Parse the menu selections:
				switch (wmId)
				{				
				case 2:
					//DestroyWindow(hWnd);
					goto exit;
					break;				
				}
			break;		
			}
			
			if(msg.message==WM_KEYUP)
			{
				int nVirtKey = (int)msg.wParam;
				// if the user pressed the ESCAPE key, then
				// print the text the user entered and quit
				if(nVirtKey==VK_ESCAPE)
				{
exit :
					// get the edit control
					if(hEditRobotIP)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditRobotIP,pText,3200);
						pText[nSize] = 0;
						robotipconf.RobotIP=pText;
						m_reg.WriteString(TEXT("robotip"), robotipconf.RobotIP);
					}
					else
					{
						printf("Failed to get edit control\n");
					}

					// get the edit control
					if(hEditRobotPort)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditRobotPort,pText,3200);
						pText[nSize] = 0;
						robotipconf.RobotPort=pText;
						m_reg.WriteString(TEXT("robotport"), robotipconf.RobotPort);
					}
					else
					{
						printf("Failed to get edit control\n");
					}

					// get the edit control
					if(hEditCamIP)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditCamIP,pText,3200);
						pText[nSize] = 0;
						robotipconf.CamIP=pText;
						m_reg.WriteString(TEXT("camip"), robotipconf.CamIP);
					}
					else
					{
						printf("Failed to get edit control\n");
					}
					// get the edit control
					if(hEditCamPort)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditCamPort,pText,3200);
						pText[nSize] = 0;
						robotipconf.CamPort=pText;
						m_reg.WriteString(TEXT("camport"), robotipconf.CamPort);
					}
					else
					{
						printf("Failed to get edit control\n");
					}

					if(hEditCamType)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditCamType,pText,3200);
						pText[nSize] = 0;
						robotipconf.CamType=pText;
						m_reg.WriteString(TEXT("camtype"), robotipconf.CamType);
					}
					else
					{
						printf("Failed to get edit control\n");
					}
					if(hEditComSleepMs)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditComSleepMs,pText,3200);
						pText[nSize] = 0;
						robotipconf.Com_Sleep_ms=pText;
						m_reg.WriteString(TEXT("comsleepms"), robotipconf.Com_Sleep_ms);
					}
					else
					{
						printf("Failed to get edit control\n");
					}
					if(hEditComMs)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditComMs,pText,3200);
						pText[nSize] = 0;
						robotipconf.Com_ms=pText;
						m_reg.WriteString(TEXT("comms"), robotipconf.Com_ms);
					}
					else
					{
						printf("Failed to get edit control\n");
					}
					
					if(hEditSnrSpyIp)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditSnrSpyIp,pText,3200);
						pText[nSize] = 0;
						robotipconf.snr_spy_ip=pText;
						m_reg.WriteString(TEXT("snrspyip"), robotipconf.snr_spy_ip);
					}
					else
					{
						printf("Failed to get edit control\n");
					}

					if(hEditTopologyIp)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditTopologyIp,pText,3200);
						pText[nSize] = 0;
						robotipconf.topology_ip=pText;
						m_reg.WriteString(TEXT("topologyip"), robotipconf.topology_ip);
					}
					else
					{
						printf("Failed to get edit control\n");
					}

					if(hEditJoyNum)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditJoyNum,pText,3200);
						pText[nSize] = 0;
						robotipconf.JoyNum=pText;
						m_reg.WriteString(TEXT("joynum"), robotipconf.JoyNum);
					}
					else
					{
						printf("Failed to get edit control\n");
					}

					if(hEditRobotType)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditRobotType,pText,3200);
						pText[nSize] = 0;
						robotipconf.RobotType=pText;
						m_reg.WriteString(TEXT("robottype"), robotipconf.RobotType);
					}
					else
					{
						printf("Failed to get edit control\n");
					}

					if(hEditMjpegType)
					{
						// get the input text the user entered and print
						// it to the console window
						char pText[3201];
						int nSize = ::GetWindowText(hEditMjpegType,pText,3200);
						pText[nSize] = 0;
						robotipconf.MJPEGType=pText;
						m_reg.WriteString(TEXT("mjpegtype"), robotipconf.MJPEGType);
					}
					else
					{
						printf("Failed to get edit control\n");
					}

					if (SendDlgItemMessage(hWnd, IDC_CHECK5, BM_GETCHECK, 0, 0))
					{
						robotipconf.Udp="1";
						m_reg.WriteString(TEXT("udp"), robotipconf.Udp);						
					}
					else if (!SendDlgItemMessage(hWnd, IDC_CHECK5, BM_GETCHECK, 0, 0)) 
					{
						robotipconf.Udp="0";
						m_reg.WriteString(TEXT("udp"), robotipconf.Udp);						
					}

					if (SendDlgItemMessage(hWnd, IDC_CHECK1, BM_GETCHECK, 0, 0))
					{
						robotipconf.CamType="MJPEGPTU";
						m_reg.WriteString(TEXT("camtype"), robotipconf.CamType);						
					}
					else if (SendDlgItemMessage(hWnd, IDC_CHECK2, BM_GETCHECK, 0, 0))
					{
						robotipconf.CamType="MPEG4PTU";
						m_reg.WriteString(TEXT("camtype"), robotipconf.CamType);						
					}
					else if (SendDlgItemMessage(hWnd, IDC_CHECK3, BM_GETCHECK, 0, 0))
					{
						robotipconf.CamType="DCS900";
						m_reg.WriteString(TEXT("camtype"), robotipconf.CamType);						
					}
					else if (SendDlgItemMessage(hWnd, IDC_CHECK4, BM_GETCHECK, 0, 0))
					{
						robotipconf.CamType="WEBCAM";
						m_reg.WriteString(TEXT("camtype"), robotipconf.CamType);						
					}
					else 
					{
						robotipconf.CamType="MJPEGPTU";
						m_reg.WriteString(TEXT("camtype"), robotipconf.CamType);						
					}

					// destroy the dialog and get out of the message loop
					::DestroyWindow(hWnd);
					bDone = true;
					break;
				}
			}
			// process message
			::TranslateMessage(&msg);
			::DispatchMessage(&msg);
		}
		else
		{
			// if there is no message to process, 
			// then sleep for a while to avoid burning
			// too much CPU cycles
			::Sleep(100);
		}
	}
}

UINT wifibotwin::run(LPVOID p)
{
   wifibotwin *me = (wifibotwin *)p;
   me->run();
   return 0;
}