// DotGraph.cpp: implementation of the DotGraph class.
//
//////////////////////////////////////////////////////////////////////

#include "../../stdafx.h"
//#include "testdot.h"
#include <atlbase.h>
#include <iostream>
#include <fstream>
#include "DotGraph.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

const IID IID_IDOT = {0xA1080582,0xD33F,0x486E,{0xBD,0x5F,0x58,0x19,0x89,0xA3,0xC7,0xE9}};
						
const CLSID CLSID_DOT = {0x55811839,0x47B0,0x4854,{0x81,0xB5,0x0A,0x00,0x31,0xB8,0xAC,0xEC}};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

DotGraph::DotGraph()
{
	size=0;	
	imagedata = (unsigned char*)calloc( 320*240*3, sizeof( BYTE ) );//Buffer du Jpeg dcompress
	dcok=false;
}

DotGraph::~DotGraph()
{

}

int DotGraph::initDot()
{
	
	HRESULT hr;
		
	hr = CoInitialize(NULL);

	if (FAILED(hr)) {
		cout << "CoInitialize Failed: " << hr << "\n\n";
		exit(1);
	}
	else {
		cout << "CoInitialize succeeded\n";
	}
		
	hr = CoCreateInstance(CLSID_DOT,NULL,CLSCTX_ALL,IID_IDOT,(void**)&pIDOT);

	if (FAILED(hr)) {
	  cout << "CoCreateInstance Failed: " << hr << "\n\n";
	  ;
	}
	else {
	  cout << "CoCreateInstance succeeded\n";
	}

	if (WSAStartup (0x0202, &WSAData)) {
		cout << "return -1"<<endl;
	}
	if (WSAData.wVersion != 0x0202) {
		WSACleanup ();
		cout << "return -1"<<endl;
	}

	sClient = socket (AF_INET, SOCK_STREAM, IPPROTO_IP);
}

int DotGraph::CloseDot()
{
	Thread::stop();
	CoUninitialize();
	return 1;
}

int DotGraph::GetFileSize(char *path)
{
  long size=0;
  ifstream file (path, ios::in|ios::binary|ios::ate);
  size = file.tellg();
  file.close();
return size;
}

int DotGraph::GetBuffFromFile(char* path,char *buffer)
{

  int hr=0;
  long size=0;

  ifstream file (path, ios::in|ios::binary|ios::ate);
  size = file.tellg();
  file.seekg (0, ios::beg);
  file.read (buffer, size);
  file.close();

return 1;
} 

int DotGraph::JpegDot2File(char*recpath,char*buffer)
{
    int hr;
	IBinaryImage * result;	
	USES_CONVERSION;
	LPOLESTR pp = T2OLE(buffer);

    hr = pIDOT->ToJPEG(pp,&result);
	
	if (FAILED(hr)) {
	  cout << "ToSvg Failed: " << hr << "\n\n";
	  ;
	}
	else {
	  cout << "ToSvg succeeded\n";
	}

	VARIANT_BOOL hrr;
	result->Save(A2BSTR(recpath),&hrr);
return 1;
}

int DotGraph::JpegDot2GDI(char*buffer, int iTotalSize, HWND myhwnd, HDC m_hDC)
{
    int hr;
	IBinaryImage * result;	
	USES_CONVERSION;
	LPOLESTR pp = T2OLE(buffer);

    hr = pIDOT->ToJPEG(pp,&result);
	
	if (FAILED(hr)) {
	  cout << "ToSvg Failed: " << hr << "\n\n";
	  ;
	}
	else {
	  cout << "ToSvg succeeded\n";
	}
  
	VARIANT_BOOL hrr;
	result->Save(A2BSTR("temp.jpg"),&hrr);
	BITMAPINFOHEADER * dib;
    DecodeJPGFileToDIB("temp.jpg",&dib);
	DWORD width;
	DWORD height;
	DWORD nchannels;
	DecodeJPGFileToGeneralBuffer("temp.jpg",&width,&height,&nchannels,&imagedata);
	PaintGDI(myhwnd,m_hDC,width,height,imagedata,dib);
return 1;
}
void DotGraph::JpegDot2Viewer()
{
	int hr;
	IBinaryImage * result;	
	USES_CONVERSION;
	LPOLESTR pp = T2OLE(buffer);

    hr = pIDOT->ToJPEG(pp,&result);
	
	if (FAILED(hr)) {
	  cout << "ToSvg Failed: " << hr << "\n\n";
	  ;
	}
	else {
	  cout << "ToSvg succeeded\n";
	}
  
	VARIANT_BOOL hrr;
	result->Save(A2BSTR("temp.jpg"),&hrr);
	char set[40];
	sprintf_s(set,"temp.jpg");
	(32 >= (int)ShellExecute(NULL, "open", set, NULL, NULL, SW_SHOWNORMAL));
}

int DotGraph::StartRcv(CString m_ip)
{
	sprintf_s(ip,"%s",m_ip);
	//Thread::detach();
	Thread::start();
	dcok=false;
  return 1;
}

int DotGraph::StartRcvHWND_DC(HWND hwnd, HDC hDC)
{
	myhwnd=hwnd;
	m_hDC=hDC;
	dcok=true;
	Thread::start();
  return 1;
}


int DotGraph::GetBuffFromSocket(char* buffer)
{    
return 1;
}

Object* DotGraph::core (Object* param)
{
	// fill in the host information
	addr.sin_family = AF_INET;
	addr.sin_port = htons (2004);
	addr.sin_addr.s_addr = inet_addr(ip);//htonl (INADDR_ANY);     
    clientConnected = false;

	//while (1) {
		int err = connect(sClient, (struct sockaddr*)&addr,sizeof(sockaddr));
		if(err == SOCKET_ERROR)
		{ 
		 if(sClient != INVALID_SOCKET)
		 {
		  closesocket(sClient);
		  sClient = INVALID_SOCKET;
		 }
		 //continue;
		}
		else
		{
		clientConnected = true;
		while (clientConnected) {
				int retval = recv(sClient,receiveBuffer,60,0);		
				memcpy(buffer+size, receiveBuffer, retval);
				size=size+retval;
				if (strrchr(buffer,'}'))				
				{
					clientConnected = false;
				}
				Sleep(1);
			}
		}
	//}
if (size>0)
{	if (dcok) JpegDot2GDI(buffer, size, myhwnd, m_hDC);
	else JpegDot2Viewer();
	memset(buffer,0,size);
	size=0;
}
	closesocket (sClient);
	WSACleanup ();    	
	CloseDot();
	return 0;
}

BOOL DotGraph::DecodeJPGFileToDIB(LPCSTR lpszPathName,BITMAPINFOHEADER** dib)
{
BOOL bres;
IJLERR jerr;
DWORD width;
DWORD height;
DWORD nchannels;
DWORD dib_line_width;
DWORD dib_pad_bytes;
DWORD wholeimagesize;
BYTE* buffer = NULL;
BITMAPINFOHEADER* bmih = NULL;
// Allocate the IJL JPEG_CORE_PROPERTIES structure.
JPEG_CORE_PROPERTIES jcprops;
bres = TRUE;
__try
{
// Initialize the IntelR JPEG Library.
jerr = ijlInit(&jcprops);
if(IJL_OK != jerr)
{
bres = FALSE;
__leave;
}
// Get information on the JPEG image
// (i.e., width, height, and channels).
jcprops.JPGFile = const_cast<LPSTR>(lpszPathName);
jerr = ijlRead(&jcprops,IJL_JFILE_READPARAMS);
if(IJL_OK != jerr)
{
bres = FALSE;
__leave;
}
// Set up local data.
width = jcprops.JPGWidth;
height = jcprops.JPGHeight;
nchannels = 3; // Decode into a 3 channel pixel buffer.
// Compute DIB padding
dib_line_width = width * nchannels;
dib_pad_bytes = IJL_DIB_PAD_BYTES(width,nchannels);
// Compute size of desired pixel buffer.
wholeimagesize = ( dib_line_width + dib_pad_bytes ) * height;
// Allocate memory to hold the decompressed image data.
buffer = new BYTE [sizeof(BITMAPINFOHEADER) + wholeimagesize];
if(NULL == buffer)
{
bres = FALSE;
__leave;
}
bmih = reinterpret_cast<BITMAPINFOHEADER*>(buffer);
bmih->biSize = sizeof(BITMAPINFOHEADER);
bmih->biWidth = width;
bmih->biHeight = -1*height;
bmih->biPlanes = 1;
bmih->biBitCount = 24;
bmih->biCompression = BI_RGB;
bmih->biSizeImage = 0;
bmih->biXPelsPerMeter = 0;
bmih->biYPelsPerMeter = 0;
bmih->biClrUsed = 0;
bmih->biClrImportant = 0;
// Set up the info on the desired DIB properties.
jcprops.DIBWidth = width;
jcprops.DIBHeight = height; // Implies a bottom-up DIB.
jcprops.DIBChannels = nchannels;
jcprops.DIBColor = IJL_BGR;
jcprops.DIBPadBytes = dib_pad_bytes;
jcprops.DIBBytes = reinterpret_cast<BYTE*>(buffer +
sizeof(BITMAPINFOHEADER));
// Set the JPG color space ... this will always be
// somewhat of an educated guess at best because JPEG
// is "color blind" (i.e., nothing in the bit stream
// tells you what color space the data was encoded from).
// However, in this example we assume that we are
// reading JFIF files which means that 3 channel images
// are in the YCbCr color space and 1 channel images are
// in the Y color space.
switch(jcprops.JPGChannels)
{
case 1:
{
jcprops.JPGColor = IJL_G;
break;
}
case 3:
{
jcprops.JPGColor = IJL_YCBCR;
break;
}
default:
	{
// This catches everything else, but no
// color twist will be performed by the IJL.
jcprops.DIBColor = (IJL_COLOR)IJL_OTHER;
jcprops.JPGColor = (IJL_COLOR)IJL_OTHER;
break;
}
}
// Now get the actual JPEG image data into the pixel buffer.
jerr = ijlRead(&jcprops,IJL_JFILE_READWHOLEIMAGE);
if(IJL_OK != jerr)
{
bres = FALSE;
__leave;
}
} // __try
__finally
{
if(FALSE == bres)
{
if(NULL != buffer)
{
delete [] buffer;
buffer = NULL;
}
}
// Clean up the IntelR JPEG Library.
ijlFree(&jcprops);
*dib = bmih;
} // __finally
return bres;
} // DecodeJPGFileToDIB()

BOOL DotGraph::DecodeJPGFileToGeneralBuffer(LPCSTR lpszPathName,DWORD* width,DWORD* height,DWORD* nchannels,BYTE** buffer)
{
BOOL bres;
IJLERR jerr;
DWORD x = 0; // pixels in scan line
DWORD y = 0; // number of scan lines
DWORD c = 0; // number of channels
DWORD wholeimagesize;
BYTE* pixel_buf = NULL;
// Allocate the IJL JPEG_CORE_PROPERTIES structure.
JPEG_CORE_PROPERTIES jcprops;
bres = TRUE;
__try
{
// Initialize the IntelR JPEG Library.
jerr = ijlInit(&jcprops);
if(IJL_OK != jerr)
{
bres = FALSE;
__leave;
}
// Get information on the JPEG image
// (i.e., width, height, and channels).
jcprops.JPGFile = const_cast<LPSTR>(lpszPathName);
jerr = ijlRead(&jcprops, IJL_JFILE_READPARAMS);
if(IJL_OK != jerr)
{
bres = FALSE;
__leave;
}
// Set up local data.
x = jcprops.JPGWidth;
y = jcprops.JPGHeight;
c = 3; // Decode into a 3 channel pixel buffer.
// Compute size of desired pixel buffer.
wholeimagesize = (x * y * c);
// Allocate memory to hold the decompressed image data.
pixel_buf = new BYTE [wholeimagesize];
if(NULL == pixel_buf)
{
bres = FALSE;
__leave;
}
// Set up the info on the desired DIB properties.
jcprops.DIBWidth = x;
jcprops.DIBHeight = y; // Implies a bottom-up DIB.
jcprops.DIBChannels = c;
jcprops.DIBColor = IJL_BGR;
jcprops.DIBPadBytes = 0;
jcprops.DIBBytes = pixel_buf;
// Set the JPG color space ... this will always be
// somewhat of an educated guess at best because JPEG
// is "color blind" (i.e., nothing in the bit stream
// tells you what color space the data was encoded from).
// However, in this example we assume that we are
// reading JFIF files which means that 3 channel images
// are in the YCbCr color space and 1 channel images are
// in the Y color space.
switch(jcprops.JPGChannels)
{
case 1:
{
jcprops.JPGColor = IJL_G;
break;
}
case 3:
{
jcprops.JPGColor = IJL_YCBCR;
break;
}
default:
{
// This catches everything else, but no
// color twist will be performed by the IJL.
jcprops.DIBColor = (IJL_COLOR)IJL_OTHER;
jcprops.JPGColor = (IJL_COLOR)IJL_OTHER;
break;
}
}
// Now get the actual JPEG image data into the pixel buffer.
jerr = ijlRead(&jcprops, IJL_JFILE_READWHOLEIMAGE);
if(IJL_OK != jerr)
{
bres = FALSE;
__leave;
}

} // __try
__finally
{
if(FALSE == bres)
{
if(NULL != pixel_buf)
{
delete [] pixel_buf;
pixel_buf = NULL;
}
}
// Clean up the IntelR JPEG Library.
ijlFree(&jcprops);
*width = x;
*height = y;
*nchannels = c;
*buffer = pixel_buf;
} // __finally
return bres;
} // DecodeJPGFileToGeneralBuffer()

void DotGraph::PaintGDI(HWND myhwnd,HDC m_hDC,int Width,int Height, unsigned char *buff,BITMAPINFOHEADER * bih)
{
				///////////////////////////////////////////////
				//////////////////////////////////////////////
				BITMAPINFO bi;
				float Xdest=0,Ydest=0;
				/*bi.bmiHeader.biSize        = sizeof( BITMAPINFOHEADER );
                bi.bmiHeader.biWidth       = Width;
                bi.bmiHeader.biHeight      = Height;
                bi.bmiHeader.biCompression = BI_RGB;
                bi.bmiHeader.biPlanes      = 1;
                bi.bmiHeader.biBitCount    = 24;
*/
				bi.bmiHeader=*bih;
				// Now calculate stretch factor
				RECT rc;
				// Make the preview video fill our window
				GetClientRect(myhwnd,&rc);

				Xdest=(float)(rc.right*(41.0/736.0));
				Ydest=(float)(rc.bottom*(54.0/444.0));
			
				float x_stretch = (float) 320 / Width;
                float y_stretch = (float) 240 / Height;
                float stretch;
                if ( x_stretch < 1 || y_stretch < 1 )
                    stretch = x_stretch < y_stretch ? x_stretch : y_stretch;
                else
                    stretch = x_stretch < y_stretch ? x_stretch : y_stretch;
					SetStretchBltMode(m_hDC, COLORONCOLOR );
					StretchDIBits(m_hDC,
                               (long)Xdest,
							   (long)Ydest,
							   (int)(Width * rc.right *(2/736.0)),              //DestHeight
							   (int)(Height * rc.bottom*(2/444.0)),             //DestWidth
                               0, 0,                                            //XSrc, YSrc
                               Width,Height,       //SrcHeight, SrcWidth
                               buff,
                               &bi,
                               DIB_RGB_COLORS,
                               SRCCOPY );
					///////////////////////////////////////////////
					//////////////////////////////////////////////    
}