// DotGraph.h: interface for the DotGraph class.
//
//////////////////////////////////////////////////////////////////////
#pragma once

#if !defined(AFX_DOTGRAPH_H__1374D61C_EC95_4F08_BDAD_A91408552882__INCLUDED_)
#define AFX_DOTGRAPH_H__1374D61C_EC95_4F08_BDAD_A91408552882__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "WinGraphviz.h"
#include "../Thread.h"
#include "../mutex.h"
#include "../../IJL/include/ijl.h" //Lib Jpeg

using namespace std;

class DotGraph  : Thread
{
public:
	IDOT * pIDOT;
	DotGraph();
	virtual ~DotGraph();
	int initDot();
	int CloseDot();
	int GetBuffFromFile(char* path,char* buffer); 
	int GetBuffFromSocket(char* buffer); 
	int GetFileSize(char* path);
	int JpegDot2File(char*recpath,char*buffer);
	int JpegDot2GDI(char*buffer, int iTotalSize, HWND myhwnd, HDC m_hDC);
	void DotGraph::JpegDot2Viewer();

	BOOL DecodeJPGFileToDIB(LPCSTR lpszPathName,BITMAPINFOHEADER** dib);
	BOOL DecodeJPGFileToGeneralBuffer(LPCSTR lpszPathName,DWORD* width,DWORD* height,DWORD* nchannels,BYTE** buffer);
	void PaintGDI(HWND myhwnd,HDC m_hDC,int Width,int Height, unsigned char *buff,BITMAPINFOHEADER *bih);

	int StartRcv(CString ip);
	int StartRcvHWND_DC(HWND hwnd, HDC hDC);

	WSADATA WSAData;
	SOCKET sListen;
	SOCKADDR_IN addr;
	SOCKET sClient;
	int iAddrLen;
	SOCKADDR_IN remoteAddr;
	char receiveBuffer[257];
	char buffer[6000];
	bool clientConnected;
	Object* core (Object*);
	int size;
	Mutex endrcv;

	JPEG_CORE_PROPERTIES jpeg;
	//BYTE* imagedata;
	unsigned char* imagedata;
	char szCompleteImage[200000];
	HWND myhwnd;
	HDC m_hDC;
	bool dcok;
	char ip[40];
};

#endif // !defined(AFX_DOTGRAPH_H__1374D61C_EC95_4F08_BDAD_A91408552882__INCLUDED_)
