#include <windows.h>
#include <commctrl.h>
#include <basetsd.h>
#include "../directx/dinput.h"
#include "wifibotapidlg.h"

#pragma comment (lib, "dxguid.lib")
#pragma comment (lib, "directx/dinput.lib")


LPDIRECTINPUT8        g_lpDI; 
LPDIRECTINPUTDEVICE8  g_lpDIDevice; 

// The following variables are presumed to be initialized:
HINSTANCE             g_hinst;    // application instance
HWND                  g_hwndMain; // application window
HWND                  g_hwndTemp; // application window

void WINAPI DI_Term();
BOOL WINAPI DI_Init(HWND,bool);
int InitKeybHwnd(HWND);
void WINAPI ProcessKBInput(CWIFIBOTAPIDlg *mydlg);

//#endif 

void WINAPI DI_Term() 
{ 
    if (g_lpDI) 
    { 
        if (g_lpDIDevice) 
        { 
        // Always unacquire device before calling Release(). 
			g_lpDIDevice->Unacquire(); 
			g_lpDIDevice->Release();
            g_lpDIDevice = NULL; 
        } 
        g_lpDI->Release();
        g_lpDI = NULL; 
    } 
} 

int InitKeybHwnd(HWND Hwndc)
{
g_hwndTemp=Hwndc;
return 1;
}

BOOL WINAPI DI_Init(HWND Hwnd,bool old) 
{ 
    HRESULT hr; 
	
	if (!old) g_hwndMain=Hwnd;
	
	if (old) g_hwndMain=g_hwndTemp;

	g_hinst=GetModuleHandle(NULL);

    // Create the DirectInput object. 
    hr = DirectInput8Create(g_hinst, DIRECTINPUT_VERSION, 
                            IID_IDirectInput8, (void**)&g_lpDI, NULL); 

    if FAILED(hr) return FALSE; 

    // Retrieve a pointer to an IDirectInputDevice8 interface 
    hr = g_lpDI->CreateDevice(GUID_SysKeyboard, &g_lpDIDevice, NULL); 

    if FAILED(hr) 
    { 
        DI_Term(); 
        return FALSE; 
    } 

    // Now that you have an IDirectInputDevice8 interface, get 
    // it ready to use. 

    // Set the data format using the predefined keyboard data 
    // format provided by the DirectInput object for keyboards. 

    hr = g_lpDIDevice->SetDataFormat(&c_dfDIKeyboard); 

    if FAILED(hr) 
    { 
        DI_Term(); 
        return FALSE; 
    } 

    // Set the cooperative level 
    hr = g_lpDIDevice->SetCooperativeLevel(g_hwndMain,DISCL_FOREGROUND | DISCL_NONEXCLUSIVE); 
	if FAILED(hr) 
    { 
        DI_Term(); 
        return FALSE; 
    } 

    // Get access to the input device. 
    hr = g_lpDIDevice->Acquire(); 
    if FAILED(hr) 
    { 
        DI_Term(); 
        return FALSE; 
    } 

    return TRUE; 
}

//void WINAPI ProcessKBInput(CVaCtrl *m_pantilt) 
void WINAPI ProcessKBInput(CWIFIBOTAPIDlg *mydlg) 
{ 
    #define KEYDOWN(name, key) (name[key] & 0x80) 

 	char     buffer[256]; 
	HRESULT  hr; 

	hr = g_lpDIDevice->GetDeviceState(sizeof(buffer),(LPVOID)&buffer); 
	if FAILED(hr) 
	{ 
		// If it failed, the device has probably been lost. 
		// Check for (hr == DIERR_INPUTLOST) 
		// and attempt to reacquire it here. 
		// If input is lost then acquire and keep trying 
        hr = g_lpDIDevice->Acquire();
        while( hr == DIERR_INPUTLOST ) 
            hr = g_lpDIDevice->Acquire();
		return; 
	} 

 	// Turn the spaceship right or left 
    if (KEYDOWN(buffer, DIK_RIGHT)) mydlg->PTUright();
	else if(KEYDOWN(buffer, DIK_LEFT)) mydlg->PTUleft(); 
	if (KEYDOWN(buffer, DIK_UP))	mydlg->PTUup();
	else if (KEYDOWN(buffer, DIK_DOWN)) mydlg->PTUdown(); 
	if (KEYDOWN(buffer, DIK_SPACE)) mydlg->PTUhome(); 
} 



