#pragma once
// define _MT so that _beginthread( ) is available
#ifndef _MT
#define _MT
#endif
#include "../stdafx.h"

#include <stdio.h>
#include <process.h>
#include "resource.h"
#include "../tools/Mutex.h"

#define FEEDBACK_WINDOW_X       20
#define FEEDBACK_WINDOW_Y       60
#define FEEDBACK_WINDOW_WIDTH   200

class JoyVirtual
{
public:
	JoyVirtual(void);
	~JoyVirtual(void);
	volatile bool running;
	void run(void);
	static UINT run(LPVOID p);
	void Close();
	void Open();
	bool bDone;
	HWND hWnd;

	volatile bool ThreadRun;
	void Thread(void);
	static UINT Thread(LPVOID p);
	Mutex speedmutex;
	double m_dPlotData[4];
	void SetSpeedData(double vfr,double vfl,double vrr,double vrl);

	CPoint GetJoyVirtVal(int RobType);

private:
	void Calc_Joy(CPoint point);
	void Draw();
	void JoyVirtual::Draw2();
	INT JoyVirtual::CoordToForce( INT nCoord );
	void MOUSEMOVE(int x, int y);
	void OnLButtonUp(int x, int y);
	void OnLButtonDown(int x, int y);
	HANDLE m_thread;
	bool initok;
};
