
/*
//
//                 INTEL CORPORATION PROPRIETARY INFORMATION
//    This software is supplied under the terms of a license agreement or
//   nondisclosure agreement with Intel Corporation and may not be copied
//    or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 1998 Intel Corporation. All Rights Reserved.
//
//  Project:
//    IJL
//
//  Purpose:
//    JPEG viewer
//
//  Author(s):
//    Vladimir V. Dudnik
//
*/

#ifndef __FILEOPENDLG_H__
#define __FILEOPENDLG_H__
#ifdef _FULLDIAG
#pragma message( "  FileOpenDlg.h")
#endif

#ifndef __IJL_H__
#include "ijl.h"
#endif



class CFileDialogEx : public CFileDialog
{
  BYTE*     m_imageData;
  CBitmap   m_bitmap;
  CDC       m_memDC;
  CBrush    m_bkbrush;

public:
  CRect     PreviewRect;
  BOOL      m_bPreview;
  BOOL      m_bChanged;
  CString   m_csFileName;
  CString   m_comments;
  CString   m_color;
  CString   m_subsampling;
  CString   m_size;

  CFileDialogEx(
    BOOL bOpenFileDialog, // TRUE for FileOpen, FALSE for FileSaveAs
    LPCTSTR lpszDefExt = NULL,
    LPCTSTR lpszFileName = NULL,
    DWORD dwFlags = OFN_EXPLORER,
    LPCTSTR lpszFilter = NULL,
    CWnd* pParentWnd = NULL);

  virtual ~CFileDialogEx(void);

protected:
  //{{AFX_VIRTUAL(CFileDialogEx)
  virtual void DoDataExchange(CDataExchange* pDX);
  //}}AFX_VIRTUAL

  //{{AFX_MSG(CFileDialogEx)
  virtual BOOL OnInitDialog();
  afx_msg void OnClickedPreview();
  afx_msg void OnPaint();
  //}}AFX_MSG

  DECLARE_MESSAGE_MAP()

protected:
  virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
  virtual void OnFileNameChange();
  virtual void OnFolderChange();

  int GetImageWidth();
  int GetImageHeight();
  int GetImageWidthBytes();
  BYTE* GetImageBits();

  void DrawPreview(void);
  void SetPreviewFile(const CString& csFileName);
  BOOL GetImageFromJPG(const CString& csFileName);
  CString GetColorStr(IJL_COLOR color);
  CString GetSubsamplingStr(IJL_JPGSUBSAMPLING ss);
  void Clean(void);

  DECLARE_DYNAMIC(CFileDialogEx)
};


#endif /*//////////////////////////////////////////////////////////////////////
//                        End of file 'FileOpenDlg.h'                        //
/////////////////////////////////////////////////////////////////////////////*/
