                               // JPGView.cpp //
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                 INTEL CORPORATION PROPRIETARY INFORMATION                 //
//    This software is supplied under the terms of a license agreement or    //
//   nondisclosure agreement with Intel Corporation and may not be copied    //
//    or disclosed except in accordance with the terms of that agreement.    //
//        Copyright (c) 1998 Intel Corporation. All Rights Reserved.         //
//                                                                           //
//  Project:                                                                 //
//    Intel(R) JPEG Library                                                  //
//  Purpose:                                                                 //
//    Small JPEG viewer to demonstrate the usage of Intel(R) JPEG Library    //
//  Author(s):                                                               //
//    Paul V. Pervov                                                         //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#ifndef __JPGVIEW_H__
#include "JPGView.h"
#endif

#ifndef __JPGVIEWFRAME_H__
#include "JPGViewFrame.h"
#endif
#ifndef __JPGVIEWDOC_H__
#include "JPGViewDoc.h"
#endif
#ifndef __JPGVIEWVIEW_H__
#include "JPGViewView.h"
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
//                                CJPGViewApp                                //
///////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(CJPGViewApp, CWinApp)
    //{{AFX_MSG_MAP(CJPGViewApp)
    ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
    //}}AFX_MSG_MAP
//    ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
    ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
    ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()


CJPGViewApp::CJPGViewApp()
{
}


CJPGViewApp theApp;


BOOL CJPGViewApp::InitInstance()
{
    TRACE( "InitInstance 1: CmdShow = %d\n", m_nCmdShow );

    Enable3dControls();

    SetRegistryKey(_T("Intel"));

    LoadStdProfileSettings( 10 );	// Max number of MRUs

    CSingleDocTemplate* pDocTemplate;

    pDocTemplate = new CSingleDocTemplate(
      IDR_MAINFRAME,
      RUNTIME_CLASS( CJPGViewDoc ),
      RUNTIME_CLASS( CJPGViewFrame ),
      RUNTIME_CLASS( CJPGViewView ) );

    AddDocTemplate( pDocTemplate );

    CCommandLineInfo cmdInfo;
    ParseCommandLine( cmdInfo );
    if( !ProcessShellCommand( cmdInfo ) )
        return FALSE;

    TRACE( "InitInstance 2: CmdShow = %d\n", m_nCmdShow );

    m_pMainWnd->DragAcceptFiles();

    m_pMainWnd->ShowWindow( m_nCmdShow );
    m_pMainWnd->UpdateWindow();

    return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
//                                 CAboutDlg                                 //
///////////////////////////////////////////////////////////////////////////////

class CAboutDlg : public CDialog
{
public:
    //{{AFX_DATA(CAboutDlg)
    enum { IDD = IDD_ABOUTBOX };
    //}}AFX_DATA

    CAboutDlg() : CDialog( CAboutDlg::IDD )                                 { }
};


void CJPGViewApp::OnAppAbout()
{
    CAboutDlg aboutDlg;
    aboutDlg.DoModal();
}


///////////////////////////////////////////////////////////////////////////////
//                         End of file 'JPGView.cpp'                         //
///////////////////////////////////////////////////////////////////////////////
