// WifibotLab.h: interface for the WifibotLab class.
//WIFIBOT laurent@wifibot.com
//////////////////////////////////////////////////////////////////////
#include "../IJL/include/ijl.h" //Lib Jpeg
#include "../opencv/cv/include/cv.h" //Lib OpenCV
#include <io.h>
#include "ipcamstruct.h"
#if !defined(AFX_WIFIBOTLAB_H__683EC0A0_331A_48F9_9C79_FA707DDB1BDD__INCLUDED_)
#define AFX_WIFIBOTLAB_H__683EC0A0_331A_48F9_9C79_FA707DDB1BDD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class WifibotLab  
{
public:
	WifibotLab();
	virtual ~WifibotLab();
	void OnVideoOn();
	void OnVideoOff();
	void init(HWND hwnd,CDC *dc,CString ip,CString p);
	bool videoproc;
private:
	volatile bool VideoRun;
	void VideoThread(void);
	static UINT VideoThread(LPVOID p);
	void RCVCam();
	void VideoProc();
	void Paint();
	int readjpeg(int sock, unsigned char **buf,struct frame_t *headerframe,struct client_t *message,int statOn);
	int WifibotLab::write_sock (int sockhandle, unsigned char *buf, int length);
	int WifibotLab::read_sock (int sockhandle, unsigned char *buf, int length);
	int WifibotLab::open_clientsock(char * address, int port);
	void WifibotLab::close_sock (int sockhandle);
	int initaddr (struct sockaddr_in *servadrr,char *address,int port);
    int spcaClient (char *Ip, short port,int owidth, int oheight, int statOn);
	void init_callbackmessage(struct client_t* callback);
	void reset_callbackmessage(struct client_t* callback);
	const static int videoOk = 1;

	CString camip;
	CString port;
	CDC *hdc;
	HWND myhwnd;
	BYTE* jpegtemp;
	char szMessage[5000];
	char szCompleteImage[200000];

	JPEG_CORE_PROPERTIES jpeg;
	SOCKET	skSocket;
	char DataPacket[128];		// Data Packet to Transmit
	char szAux[15];
	int retval;
	int iTotalSize;
	FILE *stream;
	int imagewidth;
	int imageheight;
	bool rcvok;
	BITMAPINFO bi;
	int quit;
	int sock_client;	
};

#endif // !defined(AFX_WIFIBOTLAB_H__683EC0A0_331A_48F9_9C79_FA707DDB1BDD__INCLUDED_)
