#include "videotools.h"

unsigned char buf[400000];
void PaintGDI(HWND myhwnd,HDC m_hDC,int Width,int Height, unsigned char *buff)
{
				///////////////////////////////////////////////
				//////////////////////////////////////////////
				BITMAPINFO bi;
				float Xdest=0,Ydest=0;
				bi.bmiHeader.biSize        = sizeof( BITMAPINFOHEADER );
                bi.bmiHeader.biWidth       = Width;
                bi.bmiHeader.biHeight      = Height;
                bi.bmiHeader.biCompression = BI_RGB;
                bi.bmiHeader.biPlanes      = 1;
                bi.bmiHeader.biBitCount    = 24;

				// Now calculate stretch factor
				RECT rc;
				// Make the preview video fill our window
				GetClientRect(myhwnd,&rc);

				//Xdest=(float)(rc.right*(41.0/736.0));
				//Ydest=(float)(rc.bottom*(54.0/444.0));
		    	Xdest=0.1*rc.right;
	            Ydest=0.2*rc.bottom;
			
				float x_stretch = (float) 320 / Width;
                float y_stretch = (float) 240 / Height;
                float stretch;
                if ( x_stretch < 1 || y_stretch < 1 )
                    stretch = x_stretch < y_stretch ? x_stretch : y_stretch;
                else
                    stretch = x_stretch < y_stretch ? x_stretch : y_stretch;
					SetStretchBltMode(m_hDC, COLORONCOLOR );
					StretchDIBits(m_hDC,
                               (long)Xdest,
							   (long)Ydest,
							   (int)(Width * rc.right *(1.42/736.0)),              //DestHeight 1.3
							   (int)(Height * rc.bottom*(1.34/444.0)),             //DestWidth 1.3
                               0, 0,                                            //XSrc, YSrc
                               Width,Height,       //SrcHeight, SrcWidth
                               buff,
                               &bi,
                               DIB_RGB_COLORS,
                               SRCCOPY );
					///////////////////////////////////////////////
					//////////////////////////////////////////////    
}

void Mpeg4Processing(HWND m_hWnd,CVactrl1 *mpeg4ocx,CDC  *hdc, BOOL bSignal, BOOL bDecodedImg, VARIANT* vPiece)
{
	// Traitement Video de la camera MPEG4 Pan/Tilt
	if (bDecodedImg)
	{		
		long Dims = SafeArrayGetDim(vPiece->parray);
		if (Dims != 1)
		{
			//MessageBox("Array dimension incorrect!", "Error", MB_OK | MB_ICONERROR);
			return;
		}
		long lUpperBounds;
		long lLowerBounds;
		SafeArrayGetLBound(vPiece->parray, 1, &lLowerBounds);
		SafeArrayGetUBound(vPiece->parray, 1, &lUpperBounds);

		CString strTemp;

		// do nothing here
		unsigned long	m_dwDecodedVideoSize;
		m_dwDecodedVideoSize = (lUpperBounds - lLowerBounds + 1);
		strTemp.Format("%ld", m_dwDecodedVideoSize);
			
		BYTE *pbyTheBuf;

		HRESULT hr = SafeArrayAccessData(vPiece->parray, (void **)&pbyTheBuf);
		if (!FAILED(hr))
		{
		memcpy(buf,pbyTheBuf,m_dwDecodedVideoSize);
		SafeArrayUnaccessData(vPiece->parray);		
		IplImage image;
		int pixelsize=3;//(24 bits)
		int cxImage    = 352;
		int cyImage    = 288;
		int stride     = (cxImage * sizeof( RGBTRIPLE) + 3) & -4;
		cvInitImageHeader( &image, cvSize(cxImage, cyImage), 8, 3, IPL_ORIGIN_BL, 8);
		image.widthStep = stride;
		cvSetImageData( &image,buf, stride );   
		// partir d'ici on peut faire ce qu'on veut du buffer image : &image (sous le formmat IPLIMAGE :Voir la doc OpenCV)
		//Le buffer data RGB : "image->imageData"
		
		    ////////////////////
			////////////////////
		    //mpeg4ocx->ShowWindow(0);
			cvFlip(&image,&image,0);
			//cvThreshold(&image,&image,50,120,0);//Exemple de traitement (Voir Doc ./opencv/doc)
			//CDC  *hdc=GetDC();
			PaintGDI(m_hWnd,hdc->m_hDC,352,288,buf);
			////////////////////
			////////////////////		
		}
		//else SafeArrayUnaccessData(vPiece->parray);
	}	
}