// From: Multi-Thread Programming in C++, Mark Walmsley, Springer

#pragma once
#include "object.h"


static unsigned int __stdcall threadFunction (void*);

struct Thread : public Object
{
	Thread ();
	virtual ~Thread ();

	int isA () { return THREAD; }
	int start (Object* = 0);
	void detach ();
	Object* wait ();
	void stop ();
	unsigned int getThreadId ();
	static unsigned int getCurrentThreadId ();
	static void sleep (int = 1);

protected:
	virtual Object* core (Object*) { return 0; }

private:
	void *handle;
	unsigned int id;
	bool started;
	bool detached;
	Object *param;

	friend unsigned int __stdcall threadFunction (void*);
};
