#include ".\Joy_Virtual.h"
#include <windowsx.h>
#include "../directx/dinput.h"
HINSTANCE g_hInst;

HINSTANCE m_hInst;
HWND m_hwnd;
CString m_XX;
CString m_YY;
int x,xx;
int y,yy;
CPoint initp;
CPoint point;	
bool but_left;
int posx,posy,calcx,calcy;
int deadzone;
int minmax;
float coef;
int minmaxofset;
int oldx,oldy;
Mutex mutex;
bool closed=true;
INT                   g_nXForce2;
INT                   g_nYForce2;

JoyVirtual::JoyVirtual(void)
{
	bDone = false;
	x=0,y=0;xx=0;yy=0;
	posx=120;posy=160;calcx=0;calcy=0;
	but_left=false;
	deadzone=10;
	minmax=60;
	coef=(float)((deadzone*0.01)+(minmax*0.01));
	minmaxofset=minmax+deadzone;
	oldx=0;oldy=0;
	initp.x=120;
	initp.y=160; 
	initok=false;
}

JoyVirtual::~JoyVirtual(void)
{
}

void JoyVirtual::SetSpeedData(double vfr,double vfl,double vrr,double vrl)
{
	speedmutex.acquire();
	m_dPlotData[ 0 ] = vfr;
	m_dPlotData[ 1 ] =  vfl;
	m_dPlotData[ 2 ] = vrr;
	m_dPlotData[ 3 ] = vrl;
	speedmutex.release();
}

void JoyVirtual::Open()
{
	running=true;
	bDone = false;
    AfxBeginThread(run,this);	
}

void JoyVirtual::Close()
{
	bDone = true;
	::DestroyWindow(hWnd);	
}

void JoyVirtual::Thread(void)
{
	while(ThreadRun)
	{	
	speedmutex.acquire();
	Sleep(10);
	speedmutex.release();
	Sleep(100);
	}	
}

UINT JoyVirtual::Thread(LPVOID p)
{
   JoyVirtual *me = (JoyVirtual *)p;
   me->Thread();
   return 0;
}
/*Object* JoyVirtual::core (Object* param)
{


return 0;
}*/

void JoyVirtual::run(void)
{
	// create the dialog window
	int wmId, wmEvent;
	hWnd = ::CreateDialog(NULL,MAKEINTRESOURCE(IDD_DIALOGJoy),NULL,NULL);
	m_hwnd=hWnd;
	if(hWnd!=NULL)
	{
		// show dialog
		::ShowWindow(hWnd,SW_SHOW);
		CRect rect;
		//::GetDlgItem(this->hWnd,IDC_OSCOPE);
		//::GetWindowRect(this->hWnd,rect) ;
		//ScreenToClient(this->hWnd,rect) ;
		// create the control
		CWnd* m_Window = CWnd::FindWindow(0,"Virtual Joystick");
		ThreadRun=true;
		AfxBeginThread(Thread,this);		
	}
	else
	{
		printf("Failed to create dialog\n");
		bDone = true;
		return;
	}
	
	// message loop to process user input
	MSG msg;
	while(!bDone)
	{
		if(::PeekMessage(&msg,hWnd,0,0,PM_REMOVE))
		{	    	
			switch (msg.message) {	
			
			case WM_COMMAND:
				wmId    = LOWORD(msg.wParam); 
				wmEvent = HIWORD(msg.wParam); 
				// Parse the menu selections:
				switch (wmId)
				{				
				case 2:
					//DestroyWindow(hWnd);
					break;				
				}
			break;

			case WM_PAINT:
				//Draw();
				Draw2();
				break;
			
			case WM_INITDIALOG:
			Draw();
			break;

			case WM_LBUTTONUP:
				OnLButtonUp(LOWORD (msg.lParam), HIWORD (msg.lParam));
				break;
			
			case WM_LBUTTONDOWN:
				OnLButtonDown(LOWORD (msg.lParam), HIWORD (msg.lParam));
				break;
			
			case WM_MOUSEMOVE:
				MOUSEMOVE(LOWORD (msg.lParam), HIWORD (msg.lParam));
				break;
			}
			// process message
			::TranslateMessage(&msg);
			::DispatchMessage(&msg);
		}
		else
		{
			// if there is no message to process, 
			// then sleep for a while to avoid burning
			// too much CPU cycles
			::Sleep(100);
		}
	}
}

UINT JoyVirtual::run(LPVOID p)
{
   JoyVirtual *me = (JoyVirtual *)p;
   me->run();
   return 0;
}

void JoyVirtual::Calc_Joy(CPoint point)
{    
	posx=point.x;
	posy=point.y;
	
	point.x -= FEEDBACK_WINDOW_X;
    point.y -= FEEDBACK_WINDOW_Y;
	g_nXForce2=CoordToForce(point.x);
	g_nYForce2=CoordToForce(point.y);
	
	x=(int)((posx-120)*coef);
	y=-(int)(((posy-160)*coef)*-1);
		
	if (x<-minmaxofset)  x=-minmaxofset;
	if (x>minmaxofset) x=minmaxofset;
	if ((x<deadzone)&&(x>-deadzone)) x=0;  //dead zone

	if (y<-minmaxofset) y=-minmaxofset;
	if (y>minmaxofset) y=minmaxofset;
    if ((y<deadzone)&&(y>-deadzone)) y=0;  //dead zone
    
	if (x<=-deadzone) x+=deadzone;
    if (x>=deadzone) x-=deadzone;

	if (y<=-deadzone) y+=deadzone;
    if (y>=deadzone) y-=deadzone;
	mutex.acquire();
	calcx=x;
	calcy=y;
	mutex.release();
}

CPoint JoyVirtual::GetJoyVirtVal(int RobType)
{
	CPoint point;
	mutex.acquire();
	if (RobType==1||RobType==3){
		point.x=calcx;
		point.y=calcy;
	}
	else if (RobType==2){
		point.x=(int)calcx*1000/60;
		point.y=(int)calcy*1000/60/5;// /5
	}
	mutex.release();

return point;
}

void JoyVirtual::Draw()
{
    PAINTSTRUCT ps;
    RECT rect;
    HBRUSH hBr, hOldBr;
    HPEN hPenErase;
    GetClientRect(m_hwnd,&rect);
	HDC m_hDC = BeginPaint(m_hwnd,&ps);
		
	hPenErase   = CreatePen(PS_SOLID, 1, 1);
	
	hOldBr = (HBRUSH) SelectObject(m_hDC, hPenErase);
	
    Rectangle (m_hDC, 60, 60, 180, 280);
	
	SelectObject(m_hDC, hOldBr );
	
	// Draw ellipse.
    hBr = (HBRUSH) GetStockObject (DKGRAY_BRUSH);
    hOldBr = (HBRUSH) SelectObject (m_hDC, hBr);
    //Ellipse (hdc->m_hDC, 10, 50, 90, 130);
    Ellipse (m_hDC, posx-6, posy-6, posx+6, posy+6);
	SelectObject (m_hDC, hOldBr);
	oldx=x;oldy=y;
	DeleteObject(hPenErase);
	EndPaint(m_hwnd,&ps);	
}

void JoyVirtual::MOUSEMOVE(int xx,int yy)
{
	if (but_left)
	{	
		Calc_Joy(CPoint(xx,yy));
		m_XX.Format("%d",xx);
		m_YY.Format("%d",yy);
		InvalidateRect(m_hwnd,0, TRUE );
        //UpdateWindow(m_hwnd);		
	}	
}

void JoyVirtual::OnLButtonDown(int xx,int yy)
{
	but_left=true;
	Calc_Joy(CPoint(xx,yy));
	m_XX.Format("%d",xx);
	m_YY.Format("%d",yy);
	InvalidateRect(m_hwnd,0, TRUE );
    //UpdateWindow(m_hwnd);
}

void JoyVirtual::OnLButtonUp(int xx,int yy)
{
	but_left=false;
	posx=120;
	posy=160;
	xx=120;
	yy=160;
	Calc_Joy(CPoint(xx,yy));
	m_XX.Format("%d",xx);
	m_YY.Format("%d",yy);
	InvalidateRect(m_hwnd,0, TRUE );
    //UpdateWindow(m_hwnd);	
}


void JoyVirtual::Draw2()

{
    
	PAINTSTRUCT ps;
    //HDC         hDC;
    HPEN        hpenOld;
    HPEN        hpenBlack;
    HBRUSH      hbrOld;
    HBRUSH      hbrBlack;
	int x,y;
    
	HDC m_hDC=BeginPaint( m_hwnd, &ps );
    
    // Everything is scaled to the size of the window.
    hpenBlack = GetStockPen( BLACK_PEN );
    hpenOld   = SelectPen( m_hDC, hpenBlack );

    // Draw force feedback bounding rect
    MoveToEx( m_hDC, FEEDBACK_WINDOW_X, FEEDBACK_WINDOW_Y, NULL );

    LineTo( m_hDC, FEEDBACK_WINDOW_X, 
                 FEEDBACK_WINDOW_Y + FEEDBACK_WINDOW_WIDTH );
    LineTo( m_hDC, FEEDBACK_WINDOW_X + FEEDBACK_WINDOW_WIDTH, 
                 FEEDBACK_WINDOW_Y + FEEDBACK_WINDOW_WIDTH );
    LineTo( m_hDC, FEEDBACK_WINDOW_X + FEEDBACK_WINDOW_WIDTH, 
                 FEEDBACK_WINDOW_Y );
    LineTo( m_hDC, FEEDBACK_WINDOW_X, 
                 FEEDBACK_WINDOW_Y );

    // Calculate center of feedback window for center marker
    x = FEEDBACK_WINDOW_X + FEEDBACK_WINDOW_WIDTH / 2;
    y = FEEDBACK_WINDOW_Y + FEEDBACK_WINDOW_WIDTH / 2;

    // Draw center marker
    MoveToEx( m_hDC, x, y - 10, NULL );
    LineTo(   m_hDC, x, y + 10 + 1 );
    MoveToEx( m_hDC, x - 10, y, NULL );
    LineTo(   m_hDC, x + 10 + 1, y );

    hbrBlack = GetStockBrush( BLACK_BRUSH );
    hbrOld   = SelectBrush( m_hDC, hbrBlack );

    x = MulDiv( FEEDBACK_WINDOW_WIDTH,
                g_nXForce2 + DI_FFNOMINALMAX, 
                2 * DI_FFNOMINALMAX );

    y = MulDiv( FEEDBACK_WINDOW_WIDTH, 
                g_nYForce2 + DI_FFNOMINALMAX, 
                2 * DI_FFNOMINALMAX );

    x += FEEDBACK_WINDOW_X;
    y += FEEDBACK_WINDOW_Y;

 	Ellipse( m_hDC, x-5, y-5, x+6, y+6 );

    SelectBrush( m_hDC, hbrOld );
    SelectPen( m_hDC, hpenOld );

    EndPaint( m_hwnd, &ps );
}

INT JoyVirtual::CoordToForce( INT nCoord )
{
    INT nForce = MulDiv( nCoord, 2 * DI_FFNOMINALMAX, FEEDBACK_WINDOW_WIDTH )
                 - DI_FFNOMINALMAX;

    // Keep force within bounds
    if( nForce < -DI_FFNOMINALMAX ) 
        nForce = -DI_FFNOMINALMAX;

    if( nForce > +DI_FFNOMINALMAX ) 
        nForce = +DI_FFNOMINALMAX;

    return nForce;
}