                             /* FolderBrowser.h */
/*/////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                 INTEL CORPORATION PROPRIETARY INFORMATION                 //
//    This software is supplied under the terms of a license agreement or    //
//   nondisclosure agreement with Intel Corporation and may not be copied    //
//    or disclosed except in accordance with the terms of that agreement.    //
//        Copyright (c) 1998 Intel Corporation. All Rights Reserved.         //
//                                                                           //
//  Project:                                                                 //
//                                                                           //
//  Purpose:                                                                 //
//                                                                           //
//  Author(s):                                                               //
//    Paul V. Pervov                                                         //
//                                                                           */
#ifndef __FOLDERBROWSER_H__ /*///////////////////////////////////////////////*/
#define __FOLDERBROWSER_H__
#ifdef _FULLDIAG
#pragma message( "  FolderBrowser.h")
#endif

#include "afxcmn.h"
#include "afxtempl.h"

/*/////////////////////////////////////////////////////////////////////////////
//                            CFolderTree window                             //
/////////////////////////////////////////////////////////////////////////////*/

class CFolderTree : public CTreeCtrl
{
public:
    void SetMask( CString mask )                             { m_mask = mask; }

    //{{AFX_VIRTUAL(CFolderTree)
    //}}AFX_VIRTUAL

protected:
    //{{AFX_MSG(CFolderTree)
    afx_msg void OnItemExpanded(NMHDR* pNMHDR, LRESULT* pResult);
    afx_msg void OnSelChanged(NMHDR* pNMHDR, LRESULT* pResult);
    afx_msg void OnItemExpanding(NMHDR* pNMHDR, LRESULT* pResult);
    afx_msg void OnPaint();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()

    CString m_mask;
    CMap<HANDLE, HANDLE, RECT, RECT&> m_item;

    bool HasMaskedFiles( CString path );
    CString TracePathToRoot( HTREEITEM tvi );
    bool HasEmptyMask()                 { return (m_mask.Compare( "" ) == 0); }
    // UINT GetIndentLevel( HTREEITEM hItem );
};


/*/////////////////////////////////////////////////////////////////////////////
//                           CFolderBrowser dialog                           //
/////////////////////////////////////////////////////////////////////////////*/

class CFolderBrowser : public CDialog
{
    friend int __stdcall BrowseCallback( HWND, UINT, LPARAM, LPARAM );
    friend BOOL CALLBACK EnumChild( HWND, LPARAM );
public:
    CFolderBrowser( CWnd* pParentWnd );
    ~CFolderBrowser();

    //{{AFX_DATA(CFolderBrowser)
    //}}AFX_DATA
    bool Browse( CString mask = _T("") );
    CString GetDirectory() const                        { return m_directory; }
    void SetDirectory( CString dir )                     { m_directory = dir; }

    //{{AFX_VIRTUAL(CFolderBrowser)
protected:
    virtual void DoDataExchange(CDataExchange* pDX);
    virtual void PreSubclassWindow();
    virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
    virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
    //}}AFX_VIRTUAL

protected:
    //{{AFX_MSG(CFolderBrowser)
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
    CString m_directory;
    CFolderTree m_tree;
    CWnd*   m_parentWnd;
    bool    m_bSubclassedAll;
};

#endif /*//////////////////////////////////////////////////////////////////////
//                       End of file 'FolderBrowser.h'                       //
/////////////////////////////////////////////////////////////////////////////*/
