                              /* JPGViewDoc.h */
/*/////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                 INTEL CORPORATION PROPRIETARY INFORMATION                 //
//    This software is supplied under the terms of a license agreement or    //
//   nondisclosure agreement with Intel Corporation and may not be copied    //
//    or disclosed except in accordance with the terms of that agreement.    //
//        Copyright (c) 1998 Intel Corporation. All Rights Reserved.         //
//                                                                           //
//  Project:                                                                 //
//    IJL                                                                    //
//  Purpose:                                                                 //
//    JPEG viewer                                                            //
//  Author(s):                                                               //
//    Paul V. Pervov                                                         //
//                                                                           */
#ifndef __JPGVIEWDOC_H__ /*//////////////////////////////////////////////////*/
#define __JPGVIEWDOC_H__
#ifdef _FULLDIAG
#pragma message( "  JPGViewDoc.h")
#endif

#ifndef __IJL_H__
#include "IJL.h"
#endif

/*/////////////////////////////////////////////////////////////////////////////
//                                CJPGViewDoc                                //
/////////////////////////////////////////////////////////////////////////////*/

class CJPGViewDoc : public CDocument
{
public:
    //{{AFX_VIRTUAL(CJPGViewDoc)
    public:
//    virtual BOOL OnNewDocument();
    virtual void Serialize( CArchive& ar );
    virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
    virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
    //}}AFX_VIRTUAL

    virtual ~CJPGViewDoc();
#ifdef _DEBUG
    virtual void AssertValid() const;
    virtual void Dump( CDumpContext& dc ) const;
#endif

    SIZE   GetImageDims() const     { return m_imageDims; }
    int    GetImageChannels() const { return m_imageChannels; }
    BYTE*  GetImageData() const     { return m_imageData; }
    bool   IsEmpty() const          { return (m_imageData == NULL); }

protected:
    BYTE*  m_imageData;
    SIZE   m_imageDims;
    int    m_imageChannels;

    CJPGViewDoc();
    BOOL SaveAsJPEG(LPCTSTR lpszPathName);
    BOOL SaveAsBMP(LPCTSTR lpszPathName);
    void CleanDocument();
    void RGBA_FPX_to_BGRA(BYTE* data,int width,int height);
    void BGRA_to_RGBA(BYTE* data,int width,int height);
    virtual void DeleteContents();

    DECLARE_DYNCREATE( CJPGViewDoc )

    //{{AFX_MSG(CJPGViewDoc)
    afx_msg void OnFileOpen(void);
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}

#endif /*//////////////////////////////////////////////////////////////////////
//                        End of file 'JPGViewDoc.h'                         //
/////////////////////////////////////////////////////////////////////////////*/
