                            // JPGViewFrame.cpp //
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                 INTEL CORPORATION PROPRIETARY INFORMATION                 //
//    This software is supplied under the terms of a license agreement or    //
//   nondisclosure agreement with Intel Corporation and may not be copied    //
//    or disclosed except in accordance with the terms of that agreement.    //
//        Copyright (c) 1998 Intel Corporation. All Rights Reserved.         //
//                                                                           //
//  Project:                                                                 //
//    IJL                                                                    //
//  Purpose:                                                                 //
//    JPEG viewer                                                            //
//  Author(s):                                                               //
//    Paul V. Pervov                                                         //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#ifndef __JPGVIEW_H__
#include "JPGView.h"
#endif

#ifndef __JPGVIEWFRAME_H__
#include "JPGViewFrame.h"
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
//                               CJPGViewFrame                               //
///////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNCREATE(CJPGViewFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CJPGViewFrame, CFrameWnd)
    //{{AFX_MSG_MAP(CJPGViewFrame)
    ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


static UINT indicators[] =
{
    ID_SEPARATOR            // status line indicator
};

static const int CmdShowNONE = INT_MIN;


int CJPGViewFrame::OnCreate( LPCREATESTRUCT lpCreateStruct )
{
    m_bAutoMenuEnable = FALSE;

    if( CFrameWnd::OnCreate( lpCreateStruct ) == -1 )
        return -1;

    if( !m_wndToolBar.Create( this ) ||
        !m_wndToolBar.LoadToolBar( IDR_MAINFRAME ) )
    {
        TRACE0( "Failed to create toolbar\n" );
        return -1;
    }

    if( !m_wndStatusBar.Create( this ) ||
        !m_wndStatusBar.SetIndicators( indicators,
        sizeof(indicators)/sizeof(UINT) ) )
    {
        TRACE0( "Failed to create status bar\n" );
        return -1;
    }

    m_wndToolBar.SetBarStyle( m_wndToolBar.GetBarStyle() |
                              CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC );

    m_wndToolBar.ModifyStyle( 0, TBSTYLE_FLAT );

    m_wndToolBar.EnableDocking( CBRS_ALIGN_ANY );
    m_wndToolBar.SetWindowText( _T("Standard") );

    EnableDocking( CBRS_ALIGN_ANY );
    DockControlBar( &m_wndToolBar );

    // Load window position saved in registry
    CWinApp* pwa = AfxGetApp();
    ASSERT_VALID( pwa );

    CRect*  pRect;
    UINT    size;
    if( pwa->GetProfileBinary( "Settings", "Position", (BYTE**)&pRect, &size ) )
    {
        ASSERT_POINTER( pRect, CRect );
        ASSERT( size == sizeof(CRect) );
        MoveWindow( *pRect );
        delete pRect;
    }
    m_savedCmdShow = (int)pwa->GetProfileInt( "Settings", "CmdShow", -1 );
    if( m_savedCmdShow == SW_SHOWMINIMIZED ) m_savedCmdShow = SW_SHOWMINNOACTIVE;

    LoadBarState( "ControlBars\\id" );
    return 0;
}


BOOL CJPGViewFrame::DestroyWindow()
{
    SaveBarState( "ControlBars\\id" );

    // Save window position
    CWinApp* pwa = AfxGetApp();
    ASSERT_VALID( pwa );

    WINDOWPLACEMENT  wp;

    memset( &wp, 0, sizeof(wp) );
    wp.length = sizeof(wp);
    VERIFY( GetWindowPlacement( &wp ) );

   #ifdef _DEBUG
    switch( wp.showCmd )
    {
        case SW_SHOWNORMAL:
        case SW_SHOWMINNOACTIVE:
        case SW_SHOWMAXIMIZED:
        case SW_SHOWMINIMIZED:
            m_savedCmdShow = wp.showCmd;
            break;
        default:
            TRACE( "wp.showCmd == %d\n", wp.showCmd );
            ASSERT( FALSE );    // Analyse what else can be...
    }
   #endif

    VERIFY(pwa->WriteProfileBinary( "Settings", "Position",
                                   (BYTE*)&wp.rcNormalPosition, sizeof(RECT) ));
    VERIFY(pwa->WriteProfileInt( "Settings", "CmdShow", wp.showCmd ));

	return CFrameWnd::DestroyWindow();
}


void CJPGViewFrame::ActivateFrame(int nCmdShow)
{
    // If the app is not forced to start maximized or minimized,
    // use stored CmdShow value.
    if( nCmdShow == SW_SHOWNORMAL ) nCmdShow = m_savedCmdShow;
    CFrameWnd::ActivateFrame(nCmdShow);
}


///////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
void CJPGViewFrame::AssertValid() const
{
    CFrameWnd::AssertValid();
}

void CJPGViewFrame::Dump( CDumpContext& dc ) const
{
    CFrameWnd::Dump(dc);
}
#endif //_DEBUG


///////////////////////////////////////////////////////////////////////////////
//                      End of file 'JPGViewFrame.cpp'                       //
///////////////////////////////////////////////////////////////////////////////

