#include "StdAfx.h"
#include ".\wifibotlab.h"

// WifibotLab.cpp: implementation of the WifibotLab class.
////WIFIBOT laurent@wifibot.com
//////////////////////////////////////////////////////////////////////

#include "../WIFIBOTAPI.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

WifibotLab::WifibotLab()
{
	VideoRun=false;
	videoproc=false;
	jpegtemp = NULL;
	hdc=0;
	jpegtemp = (BYTE*)calloc( 320*240*3, sizeof( BYTE ) );//Buffer du Jpeg dcompress
	quit =1;
}

WifibotLab::~WifibotLab()
{
}

void WifibotLab::init(HWND hwnd,CDC *dc,CString ip,CString p)//Rcupration du "Window Handler" et du "device context" 
{														 //de l'application mre qui cre une instance de la class WifibotLab		
	hdc=dc;
	myhwnd=hwnd;
	camip=ip;
	port=p;
	rcvok=false;
	imagewidth=0;
	imageheight=0;
}

void WifibotLab::VideoThread(void)
{
	while(VideoRun)
	{		
		//RCVCam();	  //Rception de l'image
		//if (videoproc) VideoProc(); //Traitement Video DCS 900 (commenter pour le dsactiver)
		//Paint();	 //Affichage dans le GDI de l'application mre
		char szServerAddress[30];
		char portdcs[10];
		sprintf_s(szServerAddress,"%s",camip);
		sprintf_s(portdcs,"%s",port);
		spcaClient(szServerAddress,atoi(portdcs),320,240, 0);
	}	
}

UINT WifibotLab::VideoThread(LPVOID p)
{
   WifibotLab *me = (WifibotLab *)p;
   me->VideoThread();
   return 0;
}	
	
void WifibotLab::OnVideoOn()
{
	VideoRun=true;
	AfxBeginThread(VideoThread,this);  // Lancement du Thread Video
}

void WifibotLab::OnVideoOff()
{
	quit=0;
	VideoRun=false;
	Sleep(1000);
	//close_sock (sock_client);
	//closesocket(skSocket);
	//sock_client = INVALID_SOCKET;
}

void WifibotLab::VideoProc()
{
	if (rcvok)
		{
			IplImage image;
			int pixelsize=3;//(24 bits)
			int cxImage    = imagewidth;
			int cyImage    = imageheight;
			int stride     = (cxImage * sizeof( RGBTRIPLE) + 3) & -4;
			cvInitImageHeader( &image, cvSize(cxImage, cyImage), 8, 3, IPL_ORIGIN_BL, 4);
			image.widthStep = stride;
			cvSetImageData( &image, jpegtemp, stride );   
		    // partir d'ici on peut faire ce qu'on veut du buffer image : &image (sous le formmat IPLIMAGE :Voir la doc OpenCV)
			//Le buffer data RGB : "image->imageData"
			
			////////////////////
			////////////////////
			cvThreshold(&image,&image,50,120,0);//Exemple de traitement (Voir Doc ./opencv/doc)
			////////////////////
			////////////////////
		}
}

void WifibotLab::RCVCam()
{
		HRESULT hr = 0;
		RGBTRIPLE * pData = NULL;
		iTotalSize = 0;

		retval = recv(skSocket,szMessage,sizeof(szMessage),0);

		if((retval == 0)||(retval == SOCKET_ERROR))
		{

		char szServerAddress[30];
		char portdcs[10];
		sprintf_s(szServerAddress,"%s",camip);
		sprintf_s(portdcs,"%s",port);
		int iPort=atoi(portdcs);
		//int iPort = 80;

		struct		sockaddr_in serv_addr;
		LPHOSTENT	lphost;
		WSADATA wsaData;
		WORD	wVersionRequested;
		int		iStatus;
		int	 iBytesSent = 0;			// # of Bytes Sent

		rcvok=false;
		wVersionRequested = MAKEWORD( 2, 0 );
		skSocket = INVALID_SOCKET;
		iStatus = WSAStartup(wVersionRequested,&wsaData);

		memset(&serv_addr,0,sizeof(sockaddr_in));
		serv_addr.sin_family = AF_INET;
		serv_addr.sin_addr.s_addr = inet_addr (szServerAddress);

		if (serv_addr.sin_addr.s_addr == INADDR_NONE)
		{
		lphost = gethostbyname(szServerAddress);
		if (lphost != NULL)
		serv_addr.sin_addr.s_addr = ((LPIN_ADDR)lphost->h_addr)->s_addr;
		else
		{
		WSASetLastError(WSAEINVAL);
		}
		}

		serv_addr.sin_port = htons(iPort);

		// Open the socket
		skSocket = socket(AF_INET, SOCK_STREAM, 0);

		int err = connect(skSocket, (struct sockaddr*)&serv_addr,sizeof(sockaddr));
		if(err == SOCKET_ERROR)
		{ 
		if(skSocket != INVALID_SOCKET)
		{
		closesocket(skSocket);
		skSocket = INVALID_SOCKET;
		}
		}

		// Populate the data packet
		strcpy(DataPacket, "GET /VIDEO.CGI HTTP/1.0\r\nUser-Agent: \r\nAuthorization: Basic \r\n\r\n");
		iBytesSent = send(skSocket,DataPacket,128,0);

		}//end of if
		else 
		{  
		    
		ZeroMemory(szCompleteImage,200000);
		memcpy(szAux,szMessage,15);
		   
		if(!strcmp(szAux,"Content-length:"))//we continue only if we are at the beginning of a new image
		{
		memcpy(szCompleteImage,szMessage,retval);
		iTotalSize = retval;
		   
		while((strcmp(szAux,"video boundary:")!=0)&&(retval!=0)&&(retval!=SOCKET_ERROR))   
		{
			retval = recv(skSocket,szMessage,sizeof(szMessage),0);
			memcpy(szCompleteImage+iTotalSize,szMessage,retval);
			iTotalSize = iTotalSize + retval;
			memcpy(szAux,szMessage+(retval-18),14);
		}
		  
		if(!strcmp(szAux,"video boundary:"))	
		{
			ijlInit(&jpeg);
			jpeg.JPGFile = NULL;
			jpeg.JPGBytes=(unsigned char*)szCompleteImage;
			jpeg.JPGSizeBytes=iTotalSize;
		  
			ijlRead(&jpeg, IJL_JBUFF_READPARAMS);
		   
			jpeg.JPGColor = IJL_YCBCR;
		   
			// Set up the info on the desired DIB properties.
			jpeg.DIBColor = IJL_BGR;
			jpeg.DIBChannels = 3;
			jpeg.DIBWidth = jpeg.JPGWidth;
			jpeg.DIBHeight = -jpeg.JPGHeight;
			jpeg.DIBPadBytes = 0;
			jpeg.DIBBytes = jpegtemp;

			// Now get the actual JPEG image data into the pixel buffer.
			ijlRead(&jpeg, IJL_JBUFF_READWHOLEIMAGE);
			rcvok=true;
			imagewidth=jpeg.JPGWidth;
			imageheight=jpeg.JPGHeight;
 
			ijlFree(&jpeg);
   }
  }//end of if
}//end if
	
		}

void WifibotLab::Paint()
{
				///////////////////////////////////////////////
				//////////////////////////////////////////////
				float Xdest=0,Ydest=0;
				bi.bmiHeader.biSize        = sizeof( BITMAPINFOHEADER );
                bi.bmiHeader.biWidth       = jpeg.JPGWidth;
                bi.bmiHeader.biHeight      = jpeg.JPGHeight;
                bi.bmiHeader.biCompression = BI_RGB;
                bi.bmiHeader.biPlanes      = 1;
                bi.bmiHeader.biBitCount    = 24;

				// Now calculate stretch factor
				RECT rc;
				// Make the preview video fill our window
				GetClientRect(myhwnd,&rc);

				//Xdest=(float)(rc.right*(41.0/736.0));
				//Ydest=(float)(rc.bottom*(54.0/444.0));
		    	Xdest=0.1*rc.right;
	            Ydest=0.2*rc.bottom;
				float x_stretch = (float) 320 / jpeg.JPGWidth;
                float y_stretch = (float) 240 / jpeg.JPGHeight;
                float stretch;
                if ( x_stretch < 1 || y_stretch < 1 )
                    stretch = x_stretch < y_stretch ? x_stretch : y_stretch;
                else
                    stretch = x_stretch < y_stretch ? x_stretch : y_stretch;
					SetStretchBltMode( hdc->m_hDC, COLORONCOLOR );
					StretchDIBits( hdc->m_hDC,
                               (long)Xdest,
							   (long)Ydest,
							   (int)(jpeg.JPGWidth * rc.right *(1.42/736.0)),              //DestHeight 1.5
							   (int)(jpeg.JPGHeight * rc.bottom*(1.34/444.0)),             //DestWidth 1.5
                               //(long)0.92*rc.bottom,
       						   //(long)0.715*rc.right,
 							   0, 0,                                            //XSrc, YSrc
                               jpeg.JPGWidth,jpeg.JPGHeight,       //SrcHeight, SrcWidth
                               jpegtemp,
                               &bi,
                               DIB_RGB_COLORS,
                               SRCCOPY );
					///////////////////////////////////////////////
					//////////////////////////////////////////////    
}


int WifibotLab::readjpeg(int sock, unsigned char **buf,struct frame_t *headerframe,struct client_t *message,int statOn)
{  	
	int byteread,bytewrite;
	
	bytewrite = write_sock(sock,(unsigned char*)message,sizeof(struct client_t));
	// is sleeping ?
	if ((byteread= read_sock(sock,(unsigned char*)headerframe,sizeof(struct frame_t))) < 0){
	printf("Seem server is gone !! try later \n");
	goto error;
	}

	if(statOn)
		printf (" key %s nb %d width %d height %d times %dms size %d \n",headerframe->header,
		headerframe->nbframe,headerframe->w,headerframe->h,headerframe->deltatimes,headerframe->size);
	if(headerframe->size && !headerframe->wakeup){
	//if(headerframe->size){
			*buf=(unsigned char*) realloc(*buf,headerframe->size);
			if((byteread = read_sock(sock,*buf,headerframe->size)) < 0){
			printf("Seem server is gone !! try later \n");
			goto error;}
		}
		//printf("buf read %d \n",byteread);
	if(headerframe->acknowledge)
			reset_callbackmessage(message);//!!!!!!!!!!!!!!!!!!!
		Sleep(5);
	return ((headerframe->wakeup)?0:(headerframe->size));
	//return (headerframe->size);
error:
return -1;
}

int
WifibotLab::write_sock (int sockhandle, unsigned char *buf, int length)
{
  int byte_send = -1;
  //byte_send = write (sockhandle, buf, length);
  byte_send = send(sockhandle, (char*)buf, length,0);
  //printf("byte_send %d \n",byte_send);
  return (length - byte_send);
}

int
WifibotLab::read_sock (int sockhandle, unsigned char *buf, int length)
{
  int byte_read = -1;
  unsigned char *ptbuf = buf;
  int mlength = length;
  int i = 0;
  do {
 // byte_read = read (sockhandle, ptbuf,mlength);
  if (length!=50) //PB with MSS !=1448 on Windows ????
  byte_read = recv(sockhandle, (char*)ptbuf,1448,0);
  else byte_read = recv(sockhandle, (char*)ptbuf,mlength,0);
   
  //printf("byte_read %d \n",byte_read);
  if (byte_read > 0){
  	ptbuf = ptbuf+byte_read;
  	mlength = mlength-byte_read;
	//printf("reste to read %d \n",mlength);
  }
  //printf("buffer value 0x%02X 0x%02X \n",buf[0],buf[1]);
	i++;
	//printf("waiting %d \n",i);
	if(i > 10000) return -1;
  } while (mlength > 0);
  return (mlength);
}

int WifibotLab::open_clientsock(char * address, int port)
{
  struct sockaddr_in servadr;
  int client_handle;
 
  /* Create a new socket */
  if ((client_handle = socket (AF_INET, SOCK_STREAM, 0)) == -1)
    return -1;//exit_fatal ("Error opening socket Abort !");
  
/* Now set the server address struct and connect client socket to the port*/
  initaddr (&servadr,address,port);

  if (connect(client_handle,(struct sockaddr *) &servadr,
       sizeof (struct sockaddr)) == -1)
	  return -1;//exit_fatal ("connect failed Abort !");
  return client_handle;
}

void
WifibotLab::close_sock (int sockhandle)
{
  closesocket(sockhandle);
}

int
WifibotLab::initaddr (struct sockaddr_in *servadrr,char *address,int port)
{  
int adrsize = 0;
	if(address){
		adrsize = strlen(address);
		if(adrsize < 7 || adrsize > 15)
			return -1;//exit_fatal("setting wrong address Abort !!");
		servadrr->sin_addr.s_addr = inet_addr(address);
	} else {
		servadrr->sin_addr.s_addr = INADDR_ANY;
	}
		
	servadrr->sin_family = AF_INET;
  	servadrr->sin_port = htons (port);
   	memset (&(servadrr->sin_zero), '\0', 8);
	
}

int WifibotLab::spcaClient (char *Ip, short port,int owidth, int oheight, int statOn)
{
	struct frame_t *headerframe;
	struct client_t *messcallback;
	unsigned char *buf = NULL;
	int width,height;
	int jpegsize;
	int run = 1; 
	int keypressed  =0;
	int bpp = 3;
	unsigned char* p= NULL;
	unsigned char *picture = NULL;
	struct tm *tdate;
	time_t curdate;
	char titre[21];
    rcvok=false;

	sock_client = open_clientsock(Ip,port);
	headerframe=(struct frame_t*)malloc(sizeof(struct frame_t));
	messcallback=(struct client_t*)malloc(sizeof(struct client_t));
	init_callbackmessage(messcallback);
	if ((jpegsize = readjpeg(sock_client,&buf,headerframe,messcallback,statOn)) < 0){
	printf("got size = 0 \n");
		goto error;
		}
	width = headerframe->w;
	height = headerframe->h;
	if(!owidth || !oheight){
		owidth	= width;
		oheight	= height;
		}

	do{	
	if((jpegsize = readjpeg(sock_client,&buf,headerframe,messcallback,statOn)) < 0){
	  printf(" No size !!! exit fatal \n");
		goto error;
		}
/* mode sleep off */
	//if(!jpegsize && videoOk)
	//	close_sdlvideo();
	//if( !videoOk && jpegsize){
	//	init_sdlvideo();		
	//	pscreen = SDL_SetVideoMode (owidth, oheight, bpp * 8,
	//				  SDL_DOUBLEBUF | SDL_SWSURFACE);
	//	p=pscreen->pixels;
	//}
	curdate = (time_t) (headerframe->seqtimes / 1000);
	tdate = localtime(&curdate);
	//printf (titre,21,"%02d/%02d/%04d-%02d:%02d:%02d\0",
	  //  tdate->tm_mday, tdate->tm_mon + 1, tdate->tm_year + 1900,
	    //tdate->tm_hour, tdate->tm_min, tdate->tm_sec);
	if(jpegsize && videoOk){
		//jpeg_decode(&picture,buf,&width,&height);
		//resize (p,picture,owidth,oheight,width,height) ;
		ijlInit(&jpeg);
			jpeg.JPGFile = NULL;
			jpeg.JPGBytes=(unsigned char*)buf;
			jpeg.JPGSizeBytes=jpegsize;
		  
			ijlRead(&jpeg, IJL_JBUFF_READPARAMS);
		   
			jpeg.JPGColor = IJL_YCBCR;
		   
			// Set up the info on the desired DIB properties.
			jpeg.DIBColor = IJL_BGR;
			jpeg.DIBChannels = 3;
			jpeg.DIBWidth = jpeg.JPGWidth;
			jpeg.DIBHeight = -jpeg.JPGHeight;
			jpeg.DIBPadBytes = 0;
			jpeg.DIBBytes = jpegtemp;

			// Now get the actual JPEG image data into the pixel buffer.
			ijlRead(&jpeg, IJL_JBUFF_READWHOLEIMAGE);
			rcvok=true;
			imagewidth=jpeg.JPGWidth;
			imageheight=jpeg.JPGHeight;
 
			ijlFree(&jpeg);
			if (videoproc) VideoProc(); //Traitement Video DCS 900 (commenter pour le dsactiver)
			Paint();
		//printf("ok ok ok ok jpegsize=%d \n",jpegsize);
		}
	//printf("bright %05d contrast %05d \r",headerframe->bright,headerframe->contrast);
	//fflush (stdout);
}while(quit);

error:
if(picture){
free(picture);
picture = NULL;
}
//Sleep(1000);
close_sock(sock_client);
free(buf);
free(messcallback);
free(headerframe);
return 0;
}

void WifibotLab::init_callbackmessage(struct client_t* callback)
{   char key[4] ={'O','K','\0','\0'} ;
	int x = 128;
	int y = 128;
	unsigned char sleepon=0;
	unsigned char bright=0;
	unsigned char contrast =0;
	unsigned char exposure = 0;
	unsigned char colors = 0;
	unsigned char size = 0;
	unsigned char fps = 0;
	memcpy(callback->message,key,4);
	callback->x = x;
	callback->y = y;
	callback->updobright=bright;
	callback->updocontrast=contrast;
	callback->updoexposure = exposure;
	callback->updocolors = colors;
	callback->sleepon=sleepon;
	callback->updosize = size;
	callback->fps = fps;	
}

void WifibotLab::reset_callbackmessage(struct client_t* callback)
{    	
	callback->updobright= 0;
	callback->updocontrast= 0;
	callback->updoexposure = 0;
	callback->updocolors = 0;
	callback->sleepon= 0;
	callback->updosize = 0;
	callback->fps = 0;	
}	