// dcs900.cpp: implementation of the dcs900 class.
////WIFIBOT laurent@wifibot.com
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "../WIFIBOTAPI.h"
#include "dcs900.h"
#include <iostream>
#include <string>
using namespace std;

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

int retval;
char tmp[4];
int size=0;
int toget=0;
int first=0;		
int num=5000;
int iTotalSize;
int pos=0,posend=0;	
int endbuf;
int ok=0;
int cursize=0;
int sizetmp=0;
int SetLeft=0;
int shift=62;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

dcs900::dcs900()
{
	VideoRun=false;
	videoproc=false;
	jpegtemp = NULL;
	hdc=0;
	jpegtemp = (BYTE*)calloc( 352*288*3, sizeof( BYTE ) );//Buffer du Jpeg dcompress
	iTotalSize = 0;
	initok=false;
	countimg=0;
	go=false;
	first=1;
}

dcs900::~dcs900()
{
}

void dcs900::init(HWND hwnd,CDC *dc,CString ip,CString p,CString mjpegtype)//Rcupration du "Window Handler" et du "device context" 
{														 //de l'application mre qui cre une instance de la class dcs900		
	hdc=dc;
	myhwnd=hwnd;
	camip=ip;
	port=p;
	rcvok=false;
	imagewidth=0;
	imageheight=0;
	typemjpeg = atoi(mjpegtype);
}

void dcs900::VideoThread(void)
{
	while(VideoRun)
	{	RCVCamTalitor42();	  //Rception de l'image
	if (videoproc) VideoProc(); //Traitement Video DCS 900 (commenter pour le dsactiver)
	Paint();	 //Affichage dans le GDI de l'application mre	
	}	
}

UINT dcs900::VideoThread(LPVOID p)
{
	dcs900 *me = (dcs900 *)p;
	me->VideoThread();
	return 0;
}	

void dcs900::OnVideoOn()
{
	VideoRun=true;
	AfxBeginThread(VideoThread,this);  // Lancement du Thread Video
}

void dcs900::OnVideoOff()
{
	VideoRun=false;
	Sleep(1000);
	closesocket(skSocket);
	skSocket = INVALID_SOCKET;
}

void dcs900::MjpegPtuCmd(int cammodel,char*cmd)
{
	char szServerAddress[30];
	char portdcs[10];
	sprintf_s(szServerAddress,"%s",camip);
	sprintf_s(portdcs,"%s",port);
	int iPort=atoi(portdcs);

	struct		sockaddr_in serv_addr;
	LPHOSTENT	lphost;
	WSADATA wsaData;
	WORD	wVersionRequested;
	int		iStatus;
	int	 iBytesSent = 0;			// # of Bytes Sent

	wVersionRequested = MAKEWORD( 2, 0 );
	SOCKET myskSocket = INVALID_SOCKET;
	iStatus = WSAStartup(wVersionRequested,&wsaData);

	memset(&serv_addr,0,sizeof(sockaddr_in));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = inet_addr (szServerAddress);

	if (serv_addr.sin_addr.s_addr == INADDR_NONE)
	{
		lphost = gethostbyname(szServerAddress);
		if (lphost != NULL)
			serv_addr.sin_addr.s_addr = ((LPIN_ADDR)lphost->h_addr)->s_addr;
		else
		{
			WSASetLastError(WSAEINVAL);
		}
	}
	serv_addr.sin_port = htons(iPort);
	// Open the socket
	myskSocket = socket(AF_INET, SOCK_STREAM, 0);
	int err = connect(myskSocket, (struct sockaddr*)&serv_addr,sizeof(sockaddr));
	if(err == SOCKET_ERROR)
	{ 
		if(skSocket != INVALID_SOCKET)
		{
			closesocket(myskSocket);
			skSocket = INVALID_SOCKET;
		}
	}
	char ptumsg[400];
	if (cammodel==3) {
		sprintf(DataPacketPtu,"GET /?action=command&command=%s HTTP/1.1\r\n\r\n",cmd);
		send(myskSocket,DataPacketPtu,62,0);
	}
	else if (cammodel==2) {
		sprintf(DataPacketPtu,"GET /cameras/1/control/?%s HTTP/1.1\r\n\r\n",cmd);
		send(myskSocket,DataPacketPtu,45,0);
	}
	closesocket(myskSocket);
	myskSocket = INVALID_SOCKET;
}

void dcs900::OnVideoPtuLeft()
{
	if (typemjpeg==2) {
		//strcpy(DataPacketPtu, "GET /cameras/1/control/?pan=-5 HTTP/1.1\r\n\r\n");
		//send(skSocket,DataPacketPtu,44,0);63
		MjpegPtuCmd(2,"pan=-5");
	}
	else if (typemjpeg==3) {
		MjpegPtuCmd(3,"pan_plus");
	} 
}

void dcs900::OnVideoPtuRight()
{
	if (typemjpeg==2) {
		//strcpy(DataPacketPtu, "GET /cameras/1/control/?pan=5 HTTP/1.1\r\n\r\n");
		//send(skSocket,DataPacketPtu,43,0);
		MjpegPtuCmd(2,"pan=5");
	}
	else if (typemjpeg==3) {
		MjpegPtuCmd(3,"pan_minus");
	}  
}

void dcs900::OnVideoPtuUp()
{
	if (typemjpeg==2) {
		//strcpy(DataPacketPtu, "GET /cameras/1/control/?tilt=-5 HTTP/1.1\r\n\r\n");
		//send(skSocket,DataPacketPtu,45,0);
		MjpegPtuCmd(2,"tilt=5");
	}
	else if (typemjpeg==3) {
		MjpegPtuCmd(3,"tilt_minus");
	}
}

void dcs900::OnVideoPtuDown()
{
	if (typemjpeg==2) {
		//strcpy(DataPacketPtu, "GET /cameras/1/control/?tilt=5 HTTP/1.1\r\n\r\n");
		//send(skSocket,DataPacketPtu,44,0);
		MjpegPtuCmd(2,"tilt=-5");
	}
	else if (typemjpeg==3) {
		MjpegPtuCmd(3,"tilt_plus");
	}
}

void dcs900::OnVideoPtuHome()
{
	if (typemjpeg==3) {
		MjpegPtuCmd(3,"reset_pan_tilt");
	}
}

void dcs900::VideoProc()
{
	if (rcvok)
	{
		IplImage image;
		int pixelsize=3;//(24 bits)
		int cxImage    = imagewidth;
		int cyImage    = imageheight;
		int stride     = (cxImage * sizeof( RGBTRIPLE) + 3) & -4;
		cvInitImageHeader( &image, cvSize(cxImage, cyImage), 8, 3, IPL_ORIGIN_BL, 4);
		image.widthStep = stride;
		cvSetImageData( &image, jpegtemp, stride );   
		// partir d'ici on peut faire ce qu'on veut du buffer image : &image (sous le formmat IPLIMAGE :Voir la doc OpenCV)
		//Le buffer data RGB : "image->imageData"

		////////////////////
		////////////////////
		cvThreshold(&image,&image,50,120,0);//Exemple de traitement (Voir Doc ./opencv/doc)
		////////////////////
		////////////////////
	}
}

void Left()
{
	SetLeft=1;
	Sleep(2);
	SetLeft=0;
}

void dcs900::RCVCam()
{
	HRESULT hr = 0;
	RGBTRIPLE * pData = NULL;
	iTotalSize = 0;

	retval = recv(skSocket,szMessage,sizeof(szMessage),0);
	//printf("retval \n %d ",retval);

	if((retval == 0)||(retval == SOCKET_ERROR))
	{

		char szServerAddress[30];
		char portdcs[10];
		sprintf_s(szServerAddress,"%s",camip);
		sprintf_s(portdcs,"%s",port);
		int iPort=atoi(portdcs);

		struct		sockaddr_in serv_addr;
		LPHOSTENT	lphost;
		WSADATA wsaData;
		WORD	wVersionRequested;
		int		iStatus;
		int	 iBytesSent = 0;			// # of Bytes Sent

		rcvok=false;
		wVersionRequested = MAKEWORD( 2, 0 );
		skSocket = INVALID_SOCKET;
		iStatus = WSAStartup(wVersionRequested,&wsaData);

		memset(&serv_addr,0,sizeof(sockaddr_in));
		serv_addr.sin_family = AF_INET;
		serv_addr.sin_addr.s_addr = inet_addr (szServerAddress);

		if (serv_addr.sin_addr.s_addr == INADDR_NONE)
		{
			lphost = gethostbyname(szServerAddress);
			if (lphost != NULL)
				serv_addr.sin_addr.s_addr = ((LPIN_ADDR)lphost->h_addr)->s_addr;
			else
			{
				WSASetLastError(WSAEINVAL);
			}
		}

		serv_addr.sin_port = htons(iPort);

		// Open the socket
		skSocket = socket(AF_INET, SOCK_STREAM, 0);

		int err = connect(skSocket, (struct sockaddr*)&serv_addr,sizeof(sockaddr));
		if(err == SOCKET_ERROR)
		{ 
			if(skSocket != INVALID_SOCKET)
			{
				closesocket(skSocket);
				skSocket = INVALID_SOCKET;
			}
		}
		// Populate the data packet
		strcpy(DataPacket, "GET /VIDEO.CGI HTTP/1.0\r\nUser-Agent: \r\nAuthorization: Basic \r\n\r\n");
		iBytesSent = send(skSocket,DataPacket,128,0);
	}//end of if
	else 
	{  
		ZeroMemory(szCompleteImage,200000);
		memcpy(szAux,szMessage,15);

		if(!strcmp(szAux,"Content-length:"))//we continue only if we are at the beginning of a new image

		{
			memcpy(szCompleteImage,szMessage,retval);
			iTotalSize = retval;

			while((strcmp(szAux,"video boundary:")!=0)&&(retval!=0)&&(retval!=SOCKET_ERROR))   
			{
				retval = recv(skSocket,szMessage,sizeof(szMessage),0);
				memcpy(szCompleteImage+iTotalSize,szMessage,retval);
				iTotalSize = iTotalSize + retval;
				memcpy(szAux,szMessage+(retval-18),14);
			}

			if(!strcmp(szAux,"video boundary:"))	
			{
				ijlInit(&jpeg);
				jpeg.JPGFile = NULL;
				jpeg.JPGBytes=(unsigned char*)szCompleteImage;
				jpeg.JPGSizeBytes=iTotalSize;

				ijlRead(&jpeg, IJL_JBUFF_READPARAMS);

				jpeg.JPGColor = IJL_YCBCR;

				// Set up the info on the desired DIB properties.
				jpeg.DIBColor = IJL_BGR;
				jpeg.DIBChannels = 3;
				jpeg.DIBWidth = jpeg.JPGWidth;
				jpeg.DIBHeight = -jpeg.JPGHeight;
				jpeg.DIBPadBytes = 0;
				jpeg.DIBBytes = jpegtemp;

				// Now get the actual JPEG image data into the pixel buffer.
				ijlRead(&jpeg, IJL_JBUFF_READWHOLEIMAGE);
				rcvok=true;
				imagewidth=jpeg.JPGWidth;
				imageheight=jpeg.JPGHeight;

				ijlFree(&jpeg);
			}
		}//end of if
	}//end if

}


void dcs900::RCVCamTalitor()
{
	HRESULT hr = 0;
	RGBTRIPLE * pData = NULL;
	ZeroMemory(szMessage,5000);
	retval = recv(skSocket,szMessage,sizeof(szMessage),0);
	//retval = recv(skSocket,szMessage,7000,0);//num

	//printf("%d\n ",retval);

	if((retval == 0)||(retval == SOCKET_ERROR))
	{

		char szServerAddress[30];
		char portdcs[10];
		sprintf_s(szServerAddress,"%s",camip);
		sprintf_s(portdcs,"%s",port);
		int iPort=atoi(portdcs);

		struct		sockaddr_in serv_addr;
		LPHOSTENT	lphost;
		WSADATA wsaData;
		WORD	wVersionRequested;
		int		iStatus;
		int	 iBytesSent = 0;			// # of Bytes Sent

		rcvok=false;
		wVersionRequested = MAKEWORD( 2, 0 );
		skSocket = INVALID_SOCKET;
		iStatus = WSAStartup(wVersionRequested,&wsaData);

		memset(&serv_addr,0,sizeof(sockaddr_in));
		serv_addr.sin_family = AF_INET;
		serv_addr.sin_addr.s_addr = inet_addr (szServerAddress);

		if (serv_addr.sin_addr.s_addr == INADDR_NONE)
		{
			lphost = gethostbyname(szServerAddress);
			if (lphost != NULL)
				serv_addr.sin_addr.s_addr = ((LPIN_ADDR)lphost->h_addr)->s_addr;
			else
			{
				WSASetLastError(WSAEINVAL);
			}
		}

		serv_addr.sin_port = htons(iPort);

		// Open the socket
		skSocket = socket(AF_INET, SOCK_STREAM, 0);

		int err = connect(skSocket, (struct sockaddr*)&serv_addr,sizeof(sockaddr));
		if(err == SOCKET_ERROR)
		{ 
			if(skSocket != INVALID_SOCKET)
			{
				closesocket(skSocket);
				skSocket = INVALID_SOCKET;
			}
		}

		// Populate the data packet
		//strcpy(DataPacket, "GET /VIDEO.CGI HTTP/1.0\r\nUser-Agent: \r\nAuthorization: Basic \r\n\r\n");
		//iBytesSent = send(skSocket,DataPacket,128,0);

		//strcpy(DataPacket, "GET /cgi/sf.cgi HTTP/1.1\r\nUser-Agent: \r\nAuthorization: Basic \r\n\r\n");
		//iBytesSent = send(skSocket,DataPacket,128,0);

		//strcpy(DataPacket, "GET /cgi/ieng HTTP/1.1\r\nUser-Agent: \r\nAccept: image/png,image/*;q=0.8,*/*;q=0.5\r\nAccept-Language: fr,fr-fr;q=0.8,en-us;q=0.5,en;q=0.3\r\nAccept-Encoding: gzip,deflate\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\nReferer: http://192.168.0.25/cgi/ieng?320&auto\r\n\r\n");


		//strcpy(DataPacket2, "GET /cgi/sf.cgi HTTP/1.1\r\nHost: 192.168.0.25\r\nUser-Agent: \r\nAccept: image/png,image/*;q=0.8,*/*;q=0.5\r\nAccept-Language: fr,fr-fr;q=0.8,en-us;q=0.5,en;q=0.3\r\nAccept-Encoding: gzip,deflate\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\nReferer: http://192.168.0.25/cgi/ieng?320&auto\r\n\r\n");
		//strcpy(DataPacket2, "GET /cgi/sf.cgi HTTP/1.1\r\nHost: 192.168.0.25\r\nUser-Agent: \r\nAccept: image/png,image/*;q=0.8,*/*;q=0.5\r\nAccept-Language: fr,fr-fr;q=0.8,en-us;q=0.5,en;q=0.3\r\nAccept-Encoding: gzip,deflate\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\nReferer: \r\n\r\n");
		//strcpy(DataPacket2, "GET /cgi/sf.cgi HTTP/1.1\r\nUser-Agent: \r\n\r\n");
		//Accept: image/png,image/*;q=0.8,*/*;q=0.5\r\nAccept-Language: fr,fr-fr;q=0.8,en-us;q=0.5,en;q=0.3\r\nAccept-Encoding: gzip,deflate\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\nReferer: \r\n\r\n");

		//strcpy(DataPacket2, "GET /cgi/sf.cgi HTTP/1.1\r\nHost: 192.168.0.25\r\nUser-Agent: Mozilla/5.0 (Windows; U; Windows NT 6.0; fr; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11\r\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\r\nAccept-Language: fr,fr-fr;q=0.8,en-us;q=0.5,en;q=0.3\r\nAccept-Encoding: gzip,deflate\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\n\r\n");
		//strcpy(DataPacket2, "GET /cgi/sf.cgi HTTP/1.1\r\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\r\nAccept-Language: fr,fr-fr;q=0.8,en-us;q=0.5,en;q=0.3\r\nAccept-Encoding: gzip,deflate\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\n\r\n");
		strcpy(DataPacket2, "GET /cgi/sf.cgi HTTP/1.1\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\n\r\n");
		// Populate the data packet
		//strcpy(DataPacket2, "GET /VIDEO.CGI HTTP/1.0\r\nUser-Agent: \r\nAuthorization: Basic \r\n\r\n");
		iBytesSent = send(skSocket,DataPacket2,69,0);

	}//end of if
	else 
	{  

		//if (SetLeft==1)
		//Sleep(2000);
		//{	
		//		strcpy(DataPacket2,"GET /cgi-bin/action?action=cam_mv&diretion=cam_left&lang=eng HTTP/1.1\r\nHost: 192.168.0.25\r\nUser-Agent: Mozilla/5.0 (Windows; U; Windows NT 6.0; fr; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11\r\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,en;q=0.8\r\nAccept-Language: fr,fr-fr;q=0.8,en-us;q=0.5,en;q=0.3\r\nAccept-Encoding: gzip,deflate\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\nAuthorization: Basic YWRtaW46MTIzNDU2\r\n\r\n\");
		//strcpy(DataPacket2,"GET /cgi-bin/action?action=cam_mv&diretion=cam_left HTTP/1.1\r\nUser-Agent: \r\nAuthorization: Basic \r\n\r\n");
		//		int res = send(skSocket,DataPacket2,638,0);}


		string test;// = szMessage;
		test.assign((char*)szMessage,retval);
		//posend = test.find("Content-Length:");
		//int pos2 = test.find("--IPCAMJPG\r\nContent-Type: image/jpeg\r\nContent-Length: ");
		pos = test.find("");
		posend = test.find(""); 

		if((pos>=shift)&&(pos<retval-2))
		{


			if (posend>-1)if (retval!=-1) memcpy(szCompleteImage+iTotalSize,szMessage,posend+2);

			ijlInit(&jpeg);
			jpeg.JPGFile = NULL;
			jpeg.JPGBytes=(unsigned char*)szCompleteImage;
			jpeg.JPGSizeBytes=iTotalSize+posend+2;
			//jpeg.JPGSizeBytes=6000+64;

			if(ijlRead(&jpeg, IJL_JBUFF_READPARAMS)==0)

			{

				jpeg.JPGColor = IJL_YCBCR;

				// Set up the info on the desired DIB properties.
				jpeg.DIBColor = IJL_BGR;
				jpeg.DIBChannels = 3;
				jpeg.DIBWidth = jpeg.JPGWidth;
				jpeg.DIBHeight = -jpeg.JPGHeight;
				jpeg.DIBPadBytes = 0;
				jpeg.DIBBytes = jpegtemp;

				// Now get the actual JPEG image data into the pixel buffer.
				ijlRead(&jpeg, IJL_JBUFF_READWHOLEIMAGE);
				rcvok=true;
				imagewidth=jpeg.JPGWidth;
				imageheight=jpeg.JPGHeight;
			}
			ijlFree(&jpeg);




			ZeroMemory(szCompleteImage,200000);

			//iTotalSize = retval-pos;
			iTotalSize = retval-(pos-shift);

			//if (retval!=-1) memcpy(szCompleteImage,(szMessage+pos+20),retval-pos-20);
			if (retval!=-1) memcpy(szCompleteImage,szMessage+(pos-shift),iTotalSize);

			//if (retval!=-1) memcpy(szCompleteImage,szMessage,retval);

			printf("HEAD endbuf %d pose %d size %d  retval %d itotalsize %d toget %d posend %d\n ",endbuf,pos,size,retval,iTotalSize,toget,posend);


		}
		else//posend>-1
		{


			printf("endbuf %d pose %d size %d  retval %d itotalsize %d toget %d posend %d\n ",endbuf,pos,size,retval,iTotalSize,toget,posend);
			if (retval!=-1) memcpy(szCompleteImage+iTotalSize,szMessage,retval);


			iTotalSize+=retval;

		}
		////////////////////////////////////////////////////////////////////////////////////////


	}

}


void dcs900::RCVCamTalitor42()
{
	HRESULT hr = 0;
	RGBTRIPLE * pData = NULL;
	ZeroMemory(szMessage,1048);
	//retval = recv(skSocket,szMessage,sizeof(szMessage),0);
	retval = recv(skSocket,szMessage,1048,0);

	if((retval == 0)||(retval == SOCKET_ERROR))
	{
		char szServerAddress[30];
		char portdcs[10];
		sprintf_s(szServerAddress,"%s",camip);
		sprintf_s(portdcs,"%s",port);
		int iPort=atoi(portdcs);

		struct		sockaddr_in serv_addr;
		LPHOSTENT	lphost;
		WSADATA wsaData;
		WORD	wVersionRequested;
		int		iStatus;
		int	 iBytesSent = 0;			// # of Bytes Sent

		rcvok=false;
		wVersionRequested = MAKEWORD( 2, 0 );
		skSocket = INVALID_SOCKET;
		iStatus = WSAStartup(wVersionRequested,&wsaData);

		memset(&serv_addr,0,sizeof(sockaddr_in));
		serv_addr.sin_family = AF_INET;
		serv_addr.sin_addr.s_addr = inet_addr (szServerAddress);

		if (serv_addr.sin_addr.s_addr == INADDR_NONE)
		{
			lphost = gethostbyname(szServerAddress);
			if (lphost != NULL)
				serv_addr.sin_addr.s_addr = ((LPIN_ADDR)lphost->h_addr)->s_addr;
			else
			{
				WSASetLastError(WSAEINVAL);
			}
		}

		serv_addr.sin_port = htons(iPort);

		// Open the socket
		skSocket = socket(AF_INET, SOCK_STREAM, 0);

		int err = connect(skSocket, (struct sockaddr*)&serv_addr,sizeof(sockaddr));
		if(err == SOCKET_ERROR)
		{ 
			if(skSocket != INVALID_SOCKET)
			{
				closesocket(skSocket);
				skSocket = INVALID_SOCKET;
			}
		}

		if (typemjpeg==1) {
			strcpy(DataPacket2, "GET /mjpg/video.mjpg HTTP/1.1\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\n\r\n"); //size 74 axis M7001
			iBytesSent = send(skSocket,DataPacket2,74,0);
		}		
		else if (typemjpeg==2) {
			strcpy(DataPacket2, "GET /cameras/1?q=40 HTTP/1.1\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\n\r\n");//73 wia server
			iBytesSent = send(skSocket,DataPacket2,73,0);
		}
		else if (typemjpeg==3) {
			strcpy(DataPacket2, "GET /?action=stream HTTP/1.1\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\n\r\n"); //size 74 webcam mjpegserver
			iBytesSent = send(skSocket,DataPacket2,74,0);
		}
		else if (typemjpeg==4) {
			strcpy(DataPacket2, "GET /cgi/sf.cgi HTTP/1.1\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\n\r\n");//cam low cost ldlc size 69
			iBytesSent = send(skSocket,DataPacket2,69,0);
		}
		else if (typemjpeg==5) {
			strcpy(DataPacket, "GET /VIDEO.CGI HTTP/1.0\r\nUser-Agent: \r\nAuthorization: Basic \r\n\r\n");//DCS900 DLINK
			iBytesSent = send(skSocket,DataPacket,128,0);
		}
		else if (typemjpeg==6) {
			strcpy(DataPacket2, "GET /axis-cgi/mjpg/video.cgi?resolution=320x240 HTTP/1.1\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\n\r\n");//axis2100 size 101
			iBytesSent = send(skSocket,DataPacket,101,0);
		}	
		else printf("NOT WIFIBOT IP\n");
	}//end of if
	else 
	{  
		int pos=findfirst(retval);
		int posend=findlast(retval);

		if (posend>-1) {
			memcpy(szCompleteImage+iTotalSize,szMessage,posend);
			iTotalSize+=posend;
			//printf("size%d\n",iTotalSize);
			//pthread_mutex_lock (&mutex_video);				
			{
				//sio2JPEGtoBuff(videobuffer,(unsigned char*)szCompleteImage+62,iTotalSize*2);//+posend+2);
				initok=true;
				if (countimg==1) {
					//sio2JPEGtoBuff(videobuffer,(unsigned char*)szCompleteImage,iTotalSize);//+posend+2);
					mutexjpeg.acquire();
					ijlInit(&jpeg);
					jpeg.JPGFile = NULL;
					jpeg.JPGBytes=(unsigned char*)szCompleteImage;
					jpeg.JPGSizeBytes=iTotalSize;//+posend+2;
					//jpeg.JPGSizeBytes=6000+64;
					if(ijlRead(&jpeg, IJL_JBUFF_READPARAMS)==0)

					{
						jpeg.JPGColor = IJL_YCBCR;
						// Set up the info on the desired DIB properties.
						jpeg.DIBColor = IJL_BGR;
						jpeg.DIBChannels = 3;
						jpeg.DIBWidth = jpeg.JPGWidth;
						jpeg.DIBHeight = -jpeg.JPGHeight;
						jpeg.DIBPadBytes = 0;
						jpeg.DIBBytes = jpegtemp;
						// Now get the actual JPEG image data into the pixel buffer.
						ijlRead(&jpeg, IJL_JBUFF_READWHOLEIMAGE);
						rcvok=true;
						imagewidth=jpeg.JPGWidth;
						imageheight=jpeg.JPGHeight;
					}
					ijlFree(&jpeg);
					mutexjpeg.release();
					countimg=0;go=true;}
				else go=false;
				countimg++;
			}
			//pthread_mutex_unlock (&mutex_video);	
		}

		if (pos>-1) {
			iTotalSize=retval-pos;
			memcpy(szCompleteImage,szMessage+pos,(retval-pos));
		}

		if ((pos==-1)&&(posend==-1)) {
			memcpy(szCompleteImage+iTotalSize,szMessage,retval);
			iTotalSize+=retval;
		}
	}
}

int dcs900::findfirst(int retval) {

	char a=(char)0xff;
	char b=(char)0xd8;
	int ii=0;

	for (ii = 0; ii < retval-1; ii++) {
		char tmp=szMessage[ii];
		char tmp2=szMessage[ii+1];

		//if ((strcmp( &a,&tmp) == 0)&&(strcmp(&b,&tmp2)==0))
		if ((a== tmp)&&(b==tmp2))
			return ii;
	}
	return -1;
}

int dcs900::findlast(int retval) {
	char a=(char)0xff;
	int ii=0;
	char e=(char)0xd9;

	for (ii = 0; ii < retval-1; ii++) {
		char tmp=szMessage[ii];
		char tmp2=szMessage[ii+1];

		//if ((strcmp( &a,&tmp) == 0)&&(strcmp(&b,&tmp2)==0))
		if ((a== tmp)&&(e==tmp2))
			return ii;
	}
	return -1;
}

void dcs900::Paint()
{
	mutexjpeg.acquire();
	///////////////////////////////////////////////
	//////////////////////////////////////////////
	float Xdest=0,Ydest=0;
	bi.bmiHeader.biSize        = sizeof( BITMAPINFOHEADER );
	bi.bmiHeader.biWidth       = jpeg.JPGWidth;
	bi.bmiHeader.biHeight      = jpeg.JPGHeight;
	bi.bmiHeader.biCompression = BI_RGB;
	bi.bmiHeader.biPlanes      = 1;
	bi.bmiHeader.biBitCount    = 24;

	// Now calculate stretch factor
	RECT rc;
	// Make the preview video fill our window
	GetClientRect(myhwnd,&rc);

	//Xdest=(float)(rc.right*(41.0/736.0));
	//Ydest=(float)(rc.bottom*(54.0/444.0));



	//float x_stretch = (float) 320 / jpeg.JPGWidth;
	//float y_stretch = (float) 240 / jpeg.JPGHeight;

	/*float x_stretch = (float) 352 / jpeg.JPGWidth;
	float y_stretch = (float) 288 / jpeg.JPGHeight;


	float stretch;
	if ( x_stretch < 1 || y_stretch < 1 )
	stretch = x_stretch < y_stretch ? x_stretch : y_stretch;
	else
	stretch = x_stretch < y_stretch ? x_stretch : y_stretch;
	*/
	SetStretchBltMode( hdc->m_hDC, COLORONCOLOR );
	if (typemjpeg==1) {
		Xdest=0.1*rc.right;
		Ydest=0.2*rc.bottom;
		StretchDIBits( hdc->m_hDC,
			(long)Xdest,
			(long)Ydest,
			(int)(jpeg.JPGWidth ),//* rc.right *(1.30/736.0)),  //1.30            
			(int)(jpeg.JPGHeight ),//* rc.bottom*(1.14/444.0)),       //1.14     
			//(long)0.92*rc.bottom,
			//(long)0.715*rc.right,
			0, 0,                                            //XSrc, YSrc
			jpeg.JPGWidth,jpeg.JPGHeight,       //SrcHeight, SrcWidth
			jpegtemp,
			&bi,
			DIB_RGB_COLORS,
			SRCCOPY );
	}
	else if (typemjpeg==2) {
		Xdest=0.1*rc.right;
		Ydest=0.2*rc.bottom;
		StretchDIBits( hdc->m_hDC,
			(long)Xdest,
			(long)Ydest,
			(int)(jpeg.JPGWidth * rc.right *(1.30/736.0)),  //1.30            
			(int)(jpeg.JPGHeight * rc.bottom*(1.14/444.0)),       //1.14     
			//(long)0.92*rc.bottom,
			//(long)0.715*rc.right,
			0, 0,                                            //XSrc, YSrc
			jpeg.JPGWidth,jpeg.JPGHeight,       //SrcHeight, SrcWidth
			jpegtemp,
			&bi,
			DIB_RGB_COLORS,
			SRCCOPY );
	}
	else {
		Xdest=0.1*rc.right;
		Ydest=0.2*rc.bottom;
		StretchDIBits( hdc->m_hDC,
			(long)Xdest,
			(long)Ydest,
			(int)(jpeg.JPGWidth * rc.right *(1.42/736.0)),              
			(int)(jpeg.JPGHeight * rc.bottom*(1.34/444.0)),        
			//(long)0.92*rc.bottom,
			//(long)0.715*rc.right,
			0, 0,                                            //XSrc, YSrc
			jpeg.JPGWidth,jpeg.JPGHeight,       //SrcHeight, SrcWidth
			jpegtemp,
			&bi,
			DIB_RGB_COLORS,
			SRCCOPY );
	}
	///////////////////////////////////////////////
	////////////////////////////////////////////// 
	mutexjpeg.release();
}

