// WIFIBOTAPIDlg.cpp : fichier d'implmentation
//WIFIBOT laurent@wifibot.com

#include "stdafx.h"
#include "WIFIBOTAPI.h"
#include "WIFIBOTAPIDlg.h"

//WIFIBOTAPI////
#include "api.h"
#include ".\wifibotapidlg.h"
////////////////

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// bote de dialogue CWIFIBOTAPIDlg

CWIFIBOTAPIDlg::CWIFIBOTAPIDlg(CWnd* pParent /*=NULL*/)
: CDialog(CWIFIBOTAPIDlg::IDD, pParent)
, m_val1(_T(""))
, m_val2(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);	
}

void CWIFIBOTAPIDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_Val1, m_val1);
	DDX_Text(pDX, IDC_Val2, m_val2);
	DDX_Control(pDX, IDC_DLED1, m_dled1);
	DDX_Control(pDX, IDC_DLED2, m_dled2);
	DDX_Control(pDX, IDC_Sharp1, m_sharp1);
	DDX_Control(pDX, IDC_Sharp2, m_sharp2);
	DDX_Control(pDX, IDC_BatText, m_battext);	
	DDX_Control(pDX, IDC_LSpeed, m_leftspeed);
	DDX_Control(pDX, IDC_RSpeed, m_rightspeed);
	DDX_Control(pDX, IDC_SharpL, m_sharpl);
	DDX_Control(pDX, IDC_SharpR, m_sharpr);
	DDX_Control(pDX, IDC_TSpeedFL, m_tspeedfl);
	DDX_Control(pDX, IDC_SpeedFL, m_speedfl);
	DDX_Control(pDX, IDC_TSpeedFR, m_tspeedfr);
	DDX_Control(pDX, IDC_SpeedFR, m_speedfr);
	DDX_Control(pDX, IDC_TSpeedRL, m_tspeedrl);
	DDX_Control(pDX, IDC_SpeedRL, m_speedrl);
	DDX_Control(pDX, IDC_TSpeedRR, m_tspeedrr);
	DDX_Control(pDX, IDC_SpeedRR, m_speedrr);
	DDX_Control(pDX, IDC_TPing, m_tping);
	DDX_Control(pDX, IDC_Ping, m_ping);
	DDX_Control(pDX, IDC_SNR, m_snr);
	DDX_Control(pDX, IDC_TSNR, m_tsnr);
	DDX_Control(pDX, IDC_OdoLeft, m_odoleft);
	DDX_Control(pDX, IDC_OdoRight, m_odoright);
	DDX_Control(pDX, IDC_Odo, m_odo);
	DDX_Control(pDX, IDC_BUTTON_CAMERA, m_button_camera);
	DDX_Control(pDX, IDC_BUTTON_ROBOT, m_button_robot);
}

BEGIN_MESSAGE_MAP(CWIFIBOTAPIDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_BN_CLICKED(IDC_PTUHome, OnBnClickedPtuhome)
	ON_BN_CLICKED(IDC_PTUUp, OnBnClickedPtuup)
	ON_BN_CLICKED(IDC_PTULeft, OnBnClickedPtuleft)
	ON_BN_CLICKED(IDC_PTURight, OnBnClickedPturight)
	ON_BN_CLICKED(IDC_PTUDown, OnBnClickedPtudown)
	ON_COMMAND(ID_ROBOT_SETTINGS, OnRobotSettings)
	ON_COMMAND(ID_INPUT_VIRTUAL, OnInputVirtual)
	ON_COMMAND(ID_ROBOT_CONNECT, OnRobotConnect)
	ON_COMMAND(ID_ROBOT_DISCONNECT, OnRobotDisconnect)
	ON_COMMAND(ID_VIDEO_VIDEOON, OnVideoVideoon)
	ON_COMMAND(ID_VIDEO_VIDEOOFF, OnVideoVideooff)
	ON_COMMAND(ID_INPUT_JOYSTICK, OnInputJoystick)
	ON_COMMAND(ID_INPUT_CONTROLPANEL, OnInputControlpanel)
	ON_COMMAND(ID_VIDEO_VIDEOPROCESSING, OnVideoVideoprocessing)
	ON_COMMAND(ID_VIDEO_VIDEOPROCESSINGOFF, OnVideoVideoprocessingoff)
	ON_COMMAND(ID_MOTORS_SPEEDVIEW, OnMotorsSpeedview)
	ON_COMMAND(ID_VIDEO_WEBSETTINGS, OnVideoWebsettings)
	ON_COMMAND(ID_MESHNETWORK_GETTOPOLOGIE, OnMeshnetworkGettopologie)
	ON_COMMAND(ID_ABOUT, OnAbout)
	ON_COMMAND(ID_VIDEO_STAY, OnVideoStay)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_SetConstSpeed, OnBnClickedSetconstspeed)
	ON_COMMAND(ID_MOTORS_CONTROLON, OnMotorsControlon)
	ON_COMMAND(ID_MOTORS_CONTROLOFF, OnMotorsControloff)
	ON_COMMAND(ID_VIDEO_SNAPSHOT, OnVideoSnapshot)
	ON_COMMAND(ID_ROBOT_PINGON, OnRobotPingon)
	ON_COMMAND(ID_VIDEO_PINGOFF, OnVideoPingoff)
	ON_COMMAND(ID_VIDEO_PINGON, OnVideoPingon)
	ON_COMMAND(ID_ROBOT_PINGOFF, OnRobotPingoff)
	ON_COMMAND(ID_MESHNETWORK_GETSNRFROMIP, OnMeshnetworkGetsnrfromip)
	ON_COMMAND(ID_MESHNETWORK_SETSNRROBOTSERVER, OnMeshnetworkSetsnrrobotserver)
	ON_COMMAND(ID_MESHNETWORK_STOPSNR, OnMeshnetworkStopsnr)
	ON_COMMAND(ID_MESHNETWORK_CLEARSPYLIST, OnMeshnetworkClearspylist)
	ON_COMMAND(ID_ROBOT_WEB, OnRobotWeb)
	ON_COMMAND(ID_INPUT_WIIMOTE, &CWIFIBOTAPIDlg::OnInputWiimote)
	ON_BN_CLICKED(IDC_BUTTON_ROBOT, &CWIFIBOTAPIDlg::OnBnClickedButtonRobot)
	ON_BN_CLICKED(IDC_BUTTON_CAMERA, &CWIFIBOTAPIDlg::OnBnClickedButtonCamera)
END_MESSAGE_MAP()


// gestionnaires de messages pour CWIFIBOTAPIDlg

BOOL CWIFIBOTAPIDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Dfinir l'icne de cette bote de dialogue. L'infrastructure effectue cela automatiquement
	//  lorsque la fentre principale de l'application n'est pas une bote de dialogue
	SetIcon(m_hIcon, TRUE);			// Dfinir une grande icne
	SetIcon(m_hIcon, FALSE);		// Dfinir une petite icne

	// TODO : ajoutez ici une initialisation supplmentaire
	//	m_button_robot.set .SetButtonStyle(0,1);// .SetColors(100, 100, 100, 100);

	/////////////////////////////////////////////////////////////////
	//WIFIBOTAPI INIT////////////////////////////////////////////////

	SetTimer(1,100 ,NULL);
	SetTimer(2,500 ,NULL);
	SetTimer(3,400 ,NULL);
	m_eventSink.m_pDlgCaller = this;
	m_dwCookie=0;
	setupwin.GetIPconf();

	corethread_running=false;

	//joywindow->Show(joywindow,this->m_hWnd);//Init joystick virtuel	
	//OnInputVirtual();
	wifibotsc12.joyusb=false;
	wifibotsc12.joyvirtual=false;	

	m_dled1.SetText("0");
	m_dled2.SetText("0");
	m_battext.SetText("");
	m_odoleft.SetText("0");
	m_odoright.SetText("0");
	m_odo.SetText("ODOMETRY");

	m_brush.CreateSolidBrush(RGB(0, 0, 0)); // color white brush

	m_sharp1.SetRange(0,150);
	m_sharp2.SetRange(0,150);

	m_meterLeft.SetRange (0, 160) ;
	m_meterLeft.SetRangeDecimals(1) ;
	m_meterLeft.SetValueDecimals(3) ;
	m_meterLeft.SetTitle("Battery") ;
	m_leftspeed.SetWindowText("20");
	m_rightspeed.SetWindowText("20");
	m_tspeedfl.SetText("F L");
	m_tspeedfr.SetText("F R");
	m_tspeedrl.SetText("I A");
	m_tspeedrr.SetText("I A");
	m_speedfl.SetText("0");
	m_speedfr.SetText("0");
	m_speedrl.SetText("0");
	m_speedrr.SetText("0");
	m_tping.SetText("PING");
	m_ping.SetText("0");
	m_tsnr.SetText("SNR Level");
	//OnInputVirtual();
	OnInputJoystick();
	UDP=false;
	//SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, 0,false, 0);//Disable screen saver
	//SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, 0,(PVOID)TRUE, 0);//Disable screen saver
	//WIFIBOTAPI INIT////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////
	fliprobot=false;
	flipcamera=false;
	m_button_robot.SetColors(RGB_BLACK, RGB_GRAY, RGB_WHITE, RGB_BLACK);
	//m_button_robot.SetColors(RGB_GREEN, RGB_BLACK, RGB_WHITE, RGB_RED);
	m_button_camera.SetColors(RGB_BLACK, RGB_GRAY, RGB_WHITE, RGB_BLACK);
	//m_button_robot.SetColors(RGB_GREEN, RGB_BLACK, RGB_WHITE, RGB_RED);
	Sleep(500);
	return TRUE;  // retourne TRUE, sauf si vous avez dfini le focus sur un contrle
}

// Si vous ajoutez un bouton Rduire  votre bote de dialogue, vous devez utiliser le code ci-dessous
//  pour dessiner l'icne. Pour les applications MFC utilisant le modle Document/Vue,
//  cela est fait automatiquement par l'infrastructure.

void CWIFIBOTAPIDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // contexte de priphrique pour la peinture

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Centrer l'icne dans le rectangle client
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Dessiner l'icne
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CPaintDC dc(this);
		CRect rectClient ;
		GetClientRect (&rectClient);

		// make two side-by-side rectangles 
		m_rectLeftMeter.left = rectClient.right*0.70;
		m_rectLeftMeter.top = rectClient.bottom*0.60;

		m_rectLeftMeter.right = rectClient.right*0.97;
		m_rectLeftMeter.bottom =rectClient.bottom*0.85;

		// force them to be square
		if (m_rectLeftMeter.Height() > m_rectLeftMeter.Width())
		{
			m_rectLeftMeter.bottom = m_rectLeftMeter.top + m_rectLeftMeter.Width() ;
		}
		else
		{
			m_rectLeftMeter.left = m_rectLeftMeter.right-m_rectLeftMeter.Height() ;
		}

		m_meterLeft.ShowMeter (&dc, m_rectLeftMeter) ;

		CDialog::OnPaint();
	}
}

// Le systme appelle cette fonction pour obtenir le curseur  afficher lorsque l'utilisateur fait glisser
//  la fentre rduite.
HCURSOR CWIFIBOTAPIDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

/////////////////////////////////////////////////////////////////
//WIFIBOTAPI EVENT MPEG4 Video Processing/////////////////////////////
BEGIN_EVENTSINK_MAP(CWIFIBOTAPIDlg, CDialog)
END_EVENTSINK_MAP()

void CWIFIBOTAPIDlg::OnNewVideoVactrl1(BOOL bSignal, BOOL bDecodedImg, VARIANT* vPiece)
{
	CDC  *hdc=GetDC();
	//WIFIBOTAPI MPEG4 Video Processing Function/////////////////////////////
	////Traitement Video Pan/Tilt Mpeg4 (commenter pour le dsactiver)
	//Mpeg4Processing(this->m_hWnd, &mpeg4ocx, hdc, bSignal, bDecodedImg,vPiece);
	ReleaseDC(hdc);	
	////WIFIBOTAPI MPEG4 Video ProcessingFunction/////////////////////////////
}

void CWIFIBOTAPIDlg::OnNewVideo(BOOL bSignal, BOOL bImage, VARIANT *pvPiece)
{
	if (bImage)
	{		
		CDC  *hdc=GetDC();
		//WIFIBOTAPI MPEG4 Video Processing Function/////////////////////////////
		////Traitement Video Pan/Tilt Mpeg4 (commenter pour le dsactiver)
		if (videoproc&&(setupwin.robotipconf.CamType=="MPEG4PTU")) Mpeg4Processing(this->m_hWnd, m_ControlWrapper, hdc, bSignal, bImage,pvPiece);
		ReleaseDC(hdc);
		////WIFIBOTAPI MPEG4 Video ProcessingFunction//////////////////////////////
	}
}
//WIFIBOTAPI MPEG4 Video Processing//////////////////////////////
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
//WIFIBOTAPI CORE////////////////////////////////////////////////
void CWIFIBOTAPIDlg::CoreThread(void)  //Thread Robot Control 
{	
	CClientDC 	dcClient(this);
	CPoint point;
	int i=0;
	int RobotType=atoi(setupwin.robotipconf.RobotType);

	while(corethread_running)
	{		
		if(wifibotsc12.joyvirtual)	point = virtualjoy.GetJoyVirtVal(RobotType); //Valeur X Y joystick virtuel
		else if (wifibotsc12.joyusb) point = joystick.GetJoyVal(RobotType);      //Valeur X Y joystick USB
		else if (wifibotsc12.joywii) point = mywii.GetWiiVal(RobotType);      //Valeur X Y joystick USB
		else {point.x=0;point.y=0;}

		if (point.x==0&&point.y==0) countt++;
		else countt=0;

		if (countt>200) dog=atoi(setupwin.robotipconf.Com_Sleep_ms);
		else dog=atoi(setupwin.robotipconf.Com_ms);

		SensorData RobotSensors;	
		wifibotsc12.GetSensorData(&RobotSensors); //Rcupration valeurs capteurs

		if (!const_speed) 
		{
			CPoint speed; 
			CPoint steer;

			if(RobotType==1){
				CPoint point2 = wifibotsc12.CalculConsigne(point,RobotSensors.SpeedFrontLeft,RobotSensors.SpeedFrontRight); //Calcule des consignes moteurs (Var : "point" ou "point2")
				if (!UDP) wifibotsc12.SendConsigne(point2); //Envoie des consignes moteurs au robot
				else wifibotsc12.SendConsigneUdp(point2);
				//printf("X %d  Y %d llll consx %d  consy %d\n",point.x,point.y,point2.x,point2.y);
			}
			else if(RobotType==2){
				CPoint point2 = wifibotsc12.CalculConsigneRC(point,&speed,&steer); //Calcule des consignes moteurs (Var : "point" ou "point2")
				if (!UDP) wifibotsc12.SendConsigneRC(speed,steer);
				else wifibotsc12.SendConsigneRC_UDP(point,point);
				//printf("X %d  Y %d llll consx %d  consy %d\n",point.x,point.y,point2.x,point2.y);
				//printf("%d %d cc %d %d\n",speed.x,speed.y,steer.x,steer.y);
			}
			else if(RobotType==3){
				CPoint point2 = wifibotsc12.CalculConsigne(point,RobotSensors.SpeedFrontLeft,RobotSensors.SpeedFrontRight); //Calcule des consignes moteurs (Var : "point" ou "point2")
				if (!UDP) wifibotsc12.SendConsigneNoOdometry(point2); //Envoie des consignes moteurs au robot
				else wifibotsc12.SendConsigneUdp(point2);
				//printf("X %d  Y %d llll consx %d  consy %d\n",point.x,point.y,point2.x,point2.y);
			}
			i++;
		}
		else 
		{
			CString stemp;
			char ctemp[20];
			m_leftspeed.GetWindowText(stemp);
			sprintf_s(ctemp,"%s",stemp);
			int l=atoi(ctemp);
			m_rightspeed.GetWindowText(stemp);
			sprintf_s(ctemp,"%s",stemp);
			int r=atoi(ctemp);
			dog=atoi(setupwin.robotipconf.Com_ms);

			if(RobotType==1){
				if (!UDP) wifibotsc12.SendConsigne(wifibotsc12.CalculConstConsigne(CPoint(l,r)));
				else wifibotsc12.SendConsigneUdp(wifibotsc12.CalculConstConsigne(CPoint(l,r)));
			}
			else if(RobotType==2){

			}
			else if(RobotType==3){
				if (!UDP) wifibotsc12.SendConsigneNoOdometry(wifibotsc12.CalculConstConsigne(CPoint(l,r)));
				else wifibotsc12.SendConsigneUdp(wifibotsc12.CalculConstConsigne(CPoint(l,r)));
			}
		}

		char led1[20];
		sprintf_s(led1,"%d",point.x);
		m_dled1.SetText(led1);
		sprintf_s(led1,"%d",point.y);
		m_dled2.SetText(led1);

		if (RobotSensors.BatVoltage<97&&RobotSensors.BatVoltage>50) m_battext.SetText("Battery Low");
		else  m_battext.SetText("");

		m_meterLeft.UpdateNeedle (&dcClient,RobotSensors.BatVoltage);

		speedview.SetSpeedData(abs(RobotSensors.SpeedFrontLeft),abs(RobotSensors.SpeedFrontRight),abs(point.x),abs(point.y));

		sprintf_s(led1,"%d",RobotSensors.SpeedFrontLeft);
		m_speedfl.SetText(led1);
		sprintf_s(led1,"%d",RobotSensors.SpeedFrontRight);
		m_speedfr.SetText(led1);
		sprintf_s(led1,"%d",RobotSensors.SpeedRearLeft);
		m_speedrl.SetText(led1);
		sprintf_s(led1,"%d",RobotSensors.SpeedRearRight);
		m_speedrr.SetText(led1);

		//m_sharp1.SetPos(SharpLUT[RobotSensors.IRLeft]);// warning : delay when activex on
		//m_sharp2.SetPos(SharpLUT[RobotSensors.IRRight]);
		sharpl=SharpLUT[RobotSensors.IRLeft];
		sharpr=SharpLUT[RobotSensors.IRRight];		
		sprintf_s(led1,"%d",SharpLUT[RobotSensors.IRLeft]);
		m_sharpl.SetText(led1);
		sprintf_s(led1,"%d",SharpLUT[RobotSensors.IRRight]);
		m_sharpr.SetText(led1);		
		char odol[20];
		char odor[20];
		sprintf_s(odol,"%ld",RobotSensors.OdometryLeft);
		m_odoleft.SetText(odol);
		sprintf_s(odor,"%ld",RobotSensors.OdometryRight);
		m_odoright.SetText(odor);		
		Sleep(dog);		
	}	
}

UINT CWIFIBOTAPIDlg::CoreThread(LPVOID p)
{
	CWIFIBOTAPIDlg *me = (CWIFIBOTAPIDlg *)p;
	me->CoreThread();
	return 0;
}
//WIFIBOTAPI CORE////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

void CWIFIBOTAPIDlg::OnBnClickedCancel()
{	
	if(videoproc)
	{
		if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			if(activexmpeg4ok) {
				m_ControlWrapper->put_NotifyVideoData(false);
				m_ControlWrapper->ShowWindow(1);
				videoproc=false;
			}
		}
		else if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{		
			mydcs900.videoproc=false;
			th0=false;
			mydcs900.OnVideoOff();
			m_ControlWrapperPTU->Play();
			videoproc=false;
		}
		else if(setupwin.robotipconf.CamType=="DCS900")
		{
			mydcs900.videoproc=false;
			videoproc=false;
		}
	}

	if(videoON)
	{
		setupwin.GetIPconf();
		if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{
			m_ControlWrapperPTU->DestroyWindow();
			activexmjpegok=false;
		}
		else if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			m_ControlWrapper->DestroyWindow();
			activexmpeg4ok=false;
		}
		else if(setupwin.robotipconf.CamType=="DCS900")
		{	
			th0=false;
			mydcs900.OnVideoOff();
		}
		videoON=false;	
	}

	corethread_running=false;
	virtualjoy.Close();
	//delete(joywindow);
	wifibotsc12.DisconnectRobot();
	KillTimer(1);
	KillTimer(2);
	OnMeshnetworkClearspylist();
	OnCancel();
}

void CWIFIBOTAPIDlg::OnTimer(UINT nIDEvent)
{
	if (nIDEvent==1) 
	{		
		if(myping.host)
		{
			char ping[10];
			sprintf_s(ping,"%d",myping.GetPing_ms());
			m_ping.SetText(ping);
		}
		else m_ping.SetText("No Host");
		UpdateData(false);
	}
	//else if ((nIDEvent==2)&&videoON) ;//ProcessKBInput(this);
	else if (nIDEvent==2)
	{
		m_sharp1.SetPos(sharpl);
		m_sharp2.SetPos(sharpr);
	}
	else if (nIDEvent==3) 
	{
		SNRData snr_data;	
		mysnr.GetSNR(&snr_data);
		if (snr_data.tictac)
		{
			m_snr.SetColor(BLACK,LIGHTGREEN);			
		}
		else
		{
			m_snr.SetColor(BLACK,LIGHTRED);			
		}
		m_snr.SetText(snr_data.data);
	}
	CDialog::OnTimer(nIDEvent);	
}

void CWIFIBOTAPIDlg::OnVideoVideoprocessing()
{
	if(!videoproc&&videoON)
	{
		if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			if (activexmpeg4ok) {
				m_ControlWrapper->put_NotifyVideoData(true);
				m_ControlWrapper->ShowWindow(0);
				videoproc=true;
			}
		}
		else if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{
			m_ControlWrapperPTU->Stop();
			mydcs900.videoproc=true;
			UpdateData(true);
			CDC  *hdc=GetDC();
			mydcs900.init(this->m_hWnd,hdc,setupwin.robotipconf.CamIP,setupwin.robotipconf.CamPort,setupwin.robotipconf.MJPEGType);
			if (th0==false) {
				mydcs900.OnVideoOn();
				th0=true;  // Pour ne pas lancer plusieurs Threads*/
				videoproc=true;
			}
		}
		else if(setupwin.robotipconf.CamType=="DCS900")
		{
			mydcs900.videoproc=true;
			videoproc=true;
		}
		else if(setupwin.robotipconf.CamType=="WEBCAM")
		{
			mywebcam.videoproc=true;
			videoproc=true;
		}
	}
}

void CWIFIBOTAPIDlg::OnVideoVideoprocessingoff()
{	
	if(videoproc&&videoON)
	{
		if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			if(activexmpeg4ok) {
				m_ControlWrapper->put_NotifyVideoData(false);
				m_ControlWrapper->ShowWindow(1);
				videoproc=false;
			}
		}
		else if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{		
			mydcs900.videoproc=false;
			th0=false;
			mydcs900.OnVideoOff();
			m_ControlWrapperPTU->Play();
			videoproc=false;
		}
		else if(setupwin.robotipconf.CamType=="DCS900")
		{
			mydcs900.videoproc=false;
			videoproc=false;
		}
		else if(setupwin.robotipconf.CamType=="WEBCAM")
		{
			mywebcam.videoproc=false;
			videoproc=false;
		}
	}
}

void CWIFIBOTAPIDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	OnOK();
}

void CWIFIBOTAPIDlg::PTUright() {OnBnClickedPturight();}
void CWIFIBOTAPIDlg::PTUleft() {OnBnClickedPtuleft();}
void CWIFIBOTAPIDlg::PTUhome() {OnBnClickedPtuhome();}
void CWIFIBOTAPIDlg::PTUup() {OnBnClickedPtuup();}
void CWIFIBOTAPIDlg::PTUdown() {OnBnClickedPtudown();}

void CWIFIBOTAPIDlg::OnBnClickedPtuhome()
{
	if(setupwin.robotipconf.CamType=="DCS900")
	{
			mydcs900.OnVideoPtuHome();
	}
	else if (activexmjpegok||activexmpeg4ok)
	{
		if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{
			m_ControlWrapperPTU->put_PanSingleMoveDegree(5);	
			if (activexmjpegok) m_ControlWrapperPTU->put_MovePanTiltDegree(4);
		}
		else if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			if (activexmpeg4ok) m_ControlWrapper->SendCameraControl("home",30000);
		}
	}
}

void CWIFIBOTAPIDlg::OnBnClickedPtuup()
{
	if(setupwin.robotipconf.CamType=="DCS900")
	{
		mydcs900.OnVideoPtuUp();
	}
	else if (activexmjpegok||activexmpeg4ok)
	{
		if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{
			//m_ControlWrapperPTU->pput_PanSingleMoveDegree(10);
			//m_ControlWrapperPTU->put_PanSingleMoveDegree(10);
			if (activexmjpegok) m_ControlWrapperPTU->put_MovePanTiltDegree(1);
			//if (activexmjpegok) m_ControlWrapperPTU->MovePanTiltToPos(120,60);
		}
		else if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			if (activexmpeg4ok) m_ControlWrapper->SendCameraControl("up",30000);
		}
	}
}

void CWIFIBOTAPIDlg::OnBnClickedPtuleft()
{
	if(setupwin.robotipconf.CamType=="DCS900")
	{
		mydcs900.OnVideoPtuLeft();
	}
	else if (activexmjpegok||activexmpeg4ok)
	{
		if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{
			m_ControlWrapperPTU->put_PanSingleMoveDegree(5);	
			if (activexmjpegok) m_ControlWrapperPTU->put_MovePanTiltDegree(3);
		}
		else if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			if (activexmpeg4ok) m_ControlWrapper->SendCameraControl("left",30000);
		}
	}
}

void CWIFIBOTAPIDlg::OnBnClickedPturight()
{
	if(setupwin.robotipconf.CamType=="DCS900")
	{
		mydcs900.OnVideoPtuRight();
	}
	else if (activexmjpegok||activexmpeg4ok)
	{
		if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{
			m_ControlWrapperPTU->put_PanSingleMoveDegree(5);	
			if (activexmjpegok) m_ControlWrapperPTU->put_MovePanTiltDegree(5);
		}
		else if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			if (activexmpeg4ok) m_ControlWrapper->SendCameraControl("right",30000);
		}
	}
}

void CWIFIBOTAPIDlg::OnBnClickedPtudown()
{
	if(setupwin.robotipconf.CamType=="DCS900")
	{
		mydcs900.OnVideoPtuDown();
	}
	else if (activexmjpegok||activexmpeg4ok)
	{
		if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{
			m_ControlWrapperPTU->put_PanSingleMoveDegree(10);	
			if (activexmjpegok) m_ControlWrapperPTU->put_MovePanTiltDegree(7);
		}
		else if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			if (activexmpeg4ok) m_ControlWrapper->SendCameraControl("down",30000);
		}
	}
}

void CWIFIBOTAPIDlg::OnRobotSettings()
{
	//joywindow->Close();
	//setupwindow->Show(setupwindow,this->m_hWnd);//Init fenetre setup
	setupwin.Open();
}

void CWIFIBOTAPIDlg::OnInputVirtual()
{
	//if(!wifibotsc12.joyvirtual)
	//{
	joystick.Close();
	mywii.stopwiimote();
	//joywindow->Show(joywindow,this->m_hWnd);//Init joystick virtuel	
	virtualjoy.Open();
	wifibotsc12.joyusb=false;
	wifibotsc12.joywii=false;
	wifibotsc12.joyvirtual=true;	
	//}	
}

void CWIFIBOTAPIDlg::OnInputJoystick()
{
	if(!wifibotsc12.joyusb)
	{
		//joywindow->Close();
		virtualjoy.Close();
		mywii.stopwiimote();
		char ctemp[10];
		sprintf_s(ctemp,"%s",setupwin.robotipconf.JoyNum);
		int hr = joystick.start(this->m_hWnd,atoi(ctemp));//Init joystick physique
		wifibotsc12.joyusb=true;
		wifibotsc12.joyvirtual=false;
		wifibotsc12.joywii=false;
	}
}

void CWIFIBOTAPIDlg::OnInputWiimote()
{
	// TODO: Add your command handler code here
	if(!wifibotsc12.joywii)
	{		
		wifibotsc12.joyusb=false;
		wifibotsc12.joywii=true;
		wifibotsc12.joyvirtual=false;
		virtualjoy.Close();
		joystick.Close();
		mywii.startwiimote();
	}	
}

void CWIFIBOTAPIDlg::OnInputControlpanel()
{
	joystick.ControlPanel();
}

void CWIFIBOTAPIDlg::OnRobotConnect()
{
	char ctemp[10];
	sprintf_s(ctemp,"%s",setupwin.robotipconf.Udp);
	UDP=atoi(ctemp);

	char ctempip[30];
	sprintf_s(ctempip,"%s",setupwin.robotipconf.RobotIP);

	if (!corethread_running)
	{
		if (!UDP)
		{
			//if (!wifibotsc12.ConnectToRobot(setupwin.robotipconf.RobotIP,atoi(setupwin.robotipconf.RobotPort))) 
			if (!wifibotsc12.ConnectToRobot(ctempip,atoi(setupwin.robotipconf.RobotPort))) 

			{		
				corethread_running=true;
				AfxBeginThread(CoreThread,this);			
			}

		}
		else 
		{
			//if (!wifibotsc12.ConnectToRobotUdp(setupwin.robotipconf.RobotIP,atoi(setupwin.robotipconf.RobotPort)))
			if (!wifibotsc12.ConnectToRobotUdp(ctempip,atoi(setupwin.robotipconf.RobotPort)))
			{		
				corethread_running=true;
				AfxBeginThread(CoreThread,this);			
			}	
		}
	}
}

void CWIFIBOTAPIDlg::OnRobotDisconnect()
{
	const_speed=false;
	if(corethread_running)
	{
		if (!UDP) wifibotsc12.DisconnectRobot();
		else wifibotsc12.DisconnectRobotUdp();
		corethread_running=false;
	}
}

void CWIFIBOTAPIDlg::OnVideoVideoon()
{
	if (!videoON)
	{
		InitKeybHwnd(this->m_hWnd);
		bool ok = DI_Init(this->m_hWnd,0); 
		if (!ok) MessageBox("error Keyboard");

		setupwin.GetIPconf();	
		if (setupwin.robotipconf.CamType=="MJPEGPTU")
		{
			RECT rc;
			::GetClientRect(m_hWnd,&rc);
			//create the ActiveX control with the given prog id
			rc.left=0.1*rc.right;
			rc.top=0.2*rc.bottom;
			rc.bottom=0.92*rc.bottom;
			rc.right=0.715*rc.right;

			BOOL bStat=FALSE;
			bStat=
				m_ControlWrapperPTU->CreateControl (
				GetMJPEGPTUClsid(),
				"",
				WS_VISIBLE,
				rc,
				this,
				5000,
				NULL,
				FALSE,
				NULL);
			if (bStat == FALSE)
			{
				MessageBox ("Error!! Could not place control Please register xplug.ocx");
				return;
			}  
			UpdateData();
			m_ControlWrapperPTU->put_RemoteHost(setupwin.robotipconf.CamIP);
			m_ControlWrapperPTU->put_RemoteWeb(atoi(setupwin.robotipconf.CamPort));
			m_ControlWrapperPTU->put_RemotePort(8481);
			m_ControlWrapperPTU->put_PreviewWidth(320);
			m_ControlWrapperPTU->put_PreviewHeight(240);
			m_ControlWrapperPTU->Play();
			activexmjpegok=true;
		}
		else if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			RECT rc;
			::GetClientRect(m_hWnd,&rc);
			//create the ActiveX control with the given prog id
			rc.left=0.1*rc.right;
			rc.top=0.2*rc.bottom;
			rc.bottom=0.92*rc.bottom;
			rc.right=0.715*rc.right;

			BOOL bStat=FALSE;
			bStat=
				m_ControlWrapper->CreateControl (
				GetVatClsid(),
				"",
				WS_VISIBLE,
				rc,
				this,
				5000,
				NULL,
				FALSE,
				NULL);
			if (bStat == FALSE)
			{
				MessageBox ("Error!! Could not place control Please register VaDecoder.dll");
				return;
			}  
			UpdateData();
			BOOL bRet = AfxConnectionAdvise( 
				m_ControlWrapper->GetControlUnknown(),
				DIID__IVaCtrlEvents, 
				m_eventSink.GetIDispatch(FALSE), //get the IDispatch assocaiated with Mainframe...
				FALSE, //donod addref
				&m_dwCookie );//cookie to break connection later...
			//	ASSERT(bRet);

			CString strUrl, strServIP;	
			strUrl = _T("/cgi-bin/video.vam");	
			m_ControlWrapper->ShowWindow(1);
			m_ControlWrapper->put_RemoteIPAddr(setupwin.robotipconf.CamIP);
			m_ControlWrapper->put_RemotePort(atoi(setupwin.robotipconf.CamPort));
			m_ControlWrapper->put_Url(strUrl);
			m_ControlWrapper->put_VideoProtocol(1);
			m_ControlWrapper->put_NotifyImageFormat(4);
			m_ControlWrapper->Connect();
			m_ControlWrapper->put_NotifyVideoData(false);
			activexmpeg4ok=true;	
		}
		else if(setupwin.robotipconf.CamType=="DCS900")
		{
			UpdateData(true);
			CDC  *hdc=GetDC();
			mydcs900.init(this->m_hWnd,hdc,setupwin.robotipconf.CamIP,setupwin.robotipconf.CamPort,setupwin.robotipconf.MJPEGType);
			if (th0==false) {
				mydcs900.OnVideoOn();
				th0=true;  // Pour ne pas lancer plusieurs Threads
			}
		}
		else if(setupwin.robotipconf.CamType=="WEBCAM")
		{
			//////////////////
			UpdateData(true);
			CDC  *hdc=GetDC();
			mywebcam.init(this->m_hWnd,hdc,setupwin.robotipconf.CamIP,setupwin.robotipconf.CamPort);
			if (th0==false) {
				mywebcam.OnVideoOn();
				th0=true;  // Pour ne pas lancer plusieurs Threads
			}
			//////////////////		
		}
	}
	videoON=true;
}

void CWIFIBOTAPIDlg::OnVideoVideooff()
{	
	if(videoproc)
	{
		if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			if(activexmpeg4ok) {
				m_ControlWrapper->put_NotifyVideoData(false);
				m_ControlWrapper->ShowWindow(1);
				videoproc=false;
			}
		}
		else if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{		
			mydcs900.videoproc=false;
			th0=false;
			mydcs900.OnVideoOff();
			m_ControlWrapperPTU->Play();
			videoproc=false;
		}
		else if(setupwin.robotipconf.CamType=="DCS900")
		{
			mydcs900.videoproc=false;
			videoproc=false;
		}
	}

	if(videoON)
	{
		setupwin.GetIPconf();
		if(setupwin.robotipconf.CamType=="MJPEGPTU")
		{
			m_ControlWrapperPTU->DestroyWindow();
			activexmjpegok=false;
		}
		else if(setupwin.robotipconf.CamType=="MPEG4PTU")
		{
			m_ControlWrapper->DestroyWindow();
			activexmpeg4ok=false;
		}
		else if(setupwin.robotipconf.CamType=="DCS900")
		{	
			th0=false;
			mydcs900.OnVideoOff();
		}
		else if(setupwin.robotipconf.CamType=="WEBCAM")
		{	
			th0=false;
			mywebcam.OnVideoOff();
		}
		videoON=false;	
	}
}
void CWIFIBOTAPIDlg::OnMotorsSpeedview()
{
	speedview.Open();	
}

void CWIFIBOTAPIDlg::OnVideoWebsettings()
{
	char set[40];
	sprintf_s(set,"http://%s:%s",setupwin.robotipconf.CamIP,setupwin.robotipconf.CamPort);
	(32 >= (int)ShellExecute(NULL, "open", set, NULL, NULL, SW_SHOWNORMAL));
}

void CWIFIBOTAPIDlg::OnMeshnetworkGettopologie()
{
	char * buffer;
	buffer = new char [257];
	mydot.initDot();
	CDC  *hdc=GetDC();
	UpdateData(TRUE);
	//mydot.StartRcv("192.168.0.250");	
	mydot.StartRcv(setupwin.robotipconf.topology_ip);
}

void CWIFIBOTAPIDlg::OnAbout()
{
	MessageBox("WIFIBOT GUI V5.0 laurent@wifibot.com");
}

void CWIFIBOTAPIDlg::OnVideoStay()
{
	CRect rect;

	// get the current window size and position
	GetWindowRect( rect );

	// now change the size, position, and Z order
	// of the window.
	::SetWindowPos(m_hWnd ,       // handle to window
		HWND_TOPMOST,  // placement-order handle
		rect.left,     // horizontal position
		rect.top,      // vertical position
		rect.Width(),  // width
		rect.Height(), // height
		SWP_SHOWWINDOW );// window-positioning options
}

HBRUSH CWIFIBOTAPIDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	//HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	// TODO:  Change any attributes of the DC here

	// TODO:  Return a different brush if the default is not desired
	return m_brush;
}

void CWIFIBOTAPIDlg::OnBnClickedSetconstspeed()
{
	if(const_speed) const_speed=false;
	else const_speed=true;	
}

void CWIFIBOTAPIDlg::OnMotorsControlon()
{
	wifibotsc12.SetControl(1);
}

void CWIFIBOTAPIDlg::OnMotorsControloff()
{
	wifibotsc12.SetControl(0);
}

void CWIFIBOTAPIDlg::OnVideoSnapshot()
{	
}

void CWIFIBOTAPIDlg::OnRobotPingon()
{
	if (!pingcam&&!pingrobot)
	{
		myping.StartPinging(setupwin.robotipconf.RobotIP);
		pingrobot=true;
		m_tping.SetColor(BLACK,LIGHTRED);
		m_ping.SetColor(BLACK,LIGHTRED);
	}
}

void CWIFIBOTAPIDlg::OnVideoPingon()
{
	if (!pingcam&&!pingrobot)
	{
		myping.StartPinging(setupwin.robotipconf.CamIP);
		pingcam=true;		
		m_tping.SetColor(BLACK,LIGHTRED);
		m_ping.SetColor(BLACK,LIGHTRED);		
	}
}

void CWIFIBOTAPIDlg::OnRobotPingoff()
{
	if (!pingcam&&pingrobot)
	{	
		myping.StopPinging();
		pingrobot=false;
		m_tping.SetColor(BLACK,LIGHTGREEN);
		m_ping.SetColor(BLACK,LIGHTGREEN);
	}
}

void CWIFIBOTAPIDlg::OnVideoPingoff()
{
	if (pingcam&&!pingrobot)
	{	
		myping.StopPinging();
		pingcam=false;
		m_tping.SetColor(BLACK,LIGHTGREEN);
		m_ping.SetColor(BLACK,LIGHTGREEN);
	}
}
void CWIFIBOTAPIDlg::OnMeshnetworkGetsnrfromip()
{
	mysnr.StartSNR();	
}

void CWIFIBOTAPIDlg::OnMeshnetworkSetsnrrobotserver()
{
	char buff[30];
	sprintf_s(buff,"IP%s}",setupwin.robotipconf.snr_spy_ip);
	char buff2[30];
	if (!mysnr.firstudp) 
	{		
		mysnr.UDPStart();
		mysnr.firstudp=true;
		sprintf_s(buff2,"%s",setupwin.robotipconf.RobotIP);
		mysnr.Sendtosnr(buff2,15002,buff,30);
		mysnr.StartSNR();
	}
	else
	{
		sprintf_s(buff2,"%s",setupwin.robotipconf.RobotIP);
		mysnr.Sendtosnr(buff2,15002,buff,30);
		mysnr.StartSNR();
	}
}

void CWIFIBOTAPIDlg::OnMeshnetworkStopsnr()
{
	if(mysnr.firstudp) mysnr.StopSNR();
}

void CWIFIBOTAPIDlg::OnMeshnetworkClearspylist()
{
	// TODO: Add your command handler code here
	char buff2[30];
	if(mysnr.firstudp)
	{
		sprintf_s(buff2,"%s",setupwin.robotipconf.RobotIP);
		mysnr.Sendtosnr(buff2,15002,"CLEARSPY",8);
		mysnr.StopSNR();
	}
}

void CWIFIBOTAPIDlg::OnRobotWeb()
{
	char set[40];
	sprintf_s(set,"http://%s:%s",setupwin.robotipconf.RobotIP,setupwin.robotipconf.CamPort);
	(32 >= (int)ShellExecute(NULL, "open", set, NULL, NULL, SW_SHOWNORMAL));
}
void CWIFIBOTAPIDlg::OnBnClickedButtonRobot()
{
	if (!fliprobot) {
		CButton *btnOK;
		btnOK = reinterpret_cast<CButton *>(GetDlgItem(IDC_BUTTON_ROBOT));
		btnOK->SetWindowText("ROBOT OK");
		OnRobotConnect();

	/*if (!corethread_running)
	{
		if (!UDP)
		{
			//if (!wifibotsc12.ConnectToRobot(setupwin.robotipconf.RobotIP,atoi(setupwin.robotipconf.RobotPort))) 
			if (!wifibotsc12.ConnectToRobot("192.168.0.6",atoi(setupwin.robotipconf.RobotPort))) 

			{		
				corethread_running=true;
				AfxBeginThread(CoreThread,this);			
			}
		}
		else 
		{
			//if (!wifibotsc12.ConnectToRobotUdp(setupwin.robotipconf.RobotIP,atoi(setupwin.robotipconf.RobotPort)))
			if (!wifibotsc12.ConnectToRobotUdp("192.168.0.6",atoi(setupwin.robotipconf.RobotPort)))
			{		
				corethread_running=true;
				AfxBeginThread(CoreThread,this);			
			}	
		}
	}*/
	////////////////////////
	////////////////////////
	fliprobot=true;
	}
	else {
		CButton *btnOK;
		btnOK = reinterpret_cast<CButton *>(GetDlgItem(IDC_BUTTON_ROBOT));
		btnOK->SetWindowText("ROBOT");
		OnRobotDisconnect();
		fliprobot=false;
	}
}

void CWIFIBOTAPIDlg::OnBnClickedButtonCamera()
{
	if (!flipcamera) {
		CButton *btnOK;
		btnOK = reinterpret_cast<CButton *>(GetDlgItem(IDC_BUTTON_CAMERA));
		btnOK->SetWindowText("CAMERA OK");		
		OnVideoVideoon();
/*		if (!videoON)
	{
		InitKeybHwnd(this->m_hWnd);
		bool ok = DI_Init(this->m_hWnd,0); 
		if (!ok) MessageBox("error Keyboard");

		setupwin.GetIPconf();	
		UpdateData(true);
			CDC  *hdc=GetDC();
			mydcs900.init(this->m_hWnd,hdc,"192.168.0.90","80","1");
			if (th0==false) {
				mydcs900.OnVideoOn();
				th0=true;  // Pour ne pas lancer plusieurs Threads
			}
		videoON=true;
		}*/
		flipcamera=true;
	}
	else {
		CButton *btnOK;
		btnOK = reinterpret_cast<CButton *>(GetDlgItem(IDC_BUTTON_CAMERA));
		btnOK->SetWindowText("CAMERA");
		OnVideoVideooff();
		flipcamera=false;
	}
}