#include "physical_joy.h"

//-----------------------------------------------------------
// Defines, constants, and global variables
//-----------------------------------------------------------------------------
#define SAFE_DELETE(p)  { if(p) { delete (p);     (p)=NULL; } }
#define SAFE_RELEASE(p) { if(p) { (p)->Release(); (p)=NULL; } }

LPDIRECTINPUT8       g_pDI2              = NULL;      
LPDIRECTINPUT8      g_pDI2temp			 = NULL;
LPDIRECTINPUTDEVICE8 g_pJoystick2        = NULL;  
HWND hDlgtemp;
int numjoy=1;

//-----------------------------------------------------------------------------
// Name: EnumJoysticksCallback()
// Desc: Called once for each enumerated joystick. If we find one, create a
//       device interface on it so we can play with it.
//-----------------------------------------------------------------------------
BOOL CALLBACK EnumJoysticksCallback( const DIDEVICEINSTANCE* pdidInstance,
                                     VOID* pContext )
{
    HRESULT hr;
	numjoy--;

    // Obtain an interface to the enumerated joystick.
    hr = g_pDI2->CreateDevice( pdidInstance->guidInstance, &g_pJoystick2, NULL );

	// If it failed, then we can't use this joystick. (Maybe the user unplugged
    // it while we were in the middle of enumerating it.)
    if( FAILED(hr) ) 
        return DIENUM_CONTINUE;

    // Stop enumeration. Note: we're just taking the first joystick we get. You
    // could store all the enumerated joysticks and let the user pick.
    
	//return DIENUM_STOP;
	//return DIENUM_CONTINUE;//////////////////////:wii
	if (numjoy==0) return DIENUM_STOP;
	else return DIENUM_CONTINUE;
}

//-----------------------------------------------------------------------------
// Name: EnumObjectsCallback()
// Desc: Callback function for enumerating objects (axes, buttons, POVs) on a 
//       joystick. This function enables user interface elements for objects
//       that are found to exist, and scales axes min/max values.
//-----------------------------------------------------------------------------
BOOL CALLBACK EnumObjectsCallback( const DIDEVICEOBJECTINSTANCE* pdidoi,
                                   VOID* pContext )
{
    HWND hDlg = (HWND)pContext;

    static int nSliderCount = 0;  // Number of returned slider controls
    static int nPOVCount = 0;     // Number of returned POV controls

    
	// Set deadzone.
    DIPROPDWORD dipdw;
    
	dipdw.diph.dwSize       = sizeof( dipdw ); 
    dipdw.diph.dwHeaderSize = sizeof( dipdw.diph ); 
    dipdw.diph.dwObj        = 0;
    dipdw.diph.dwHow        = DIPH_DEVICE;
    dipdw.dwData            = JOYDEAD;

    if ( FAILED( g_pJoystick2->SetProperty( DIPROP_DEADZONE, &dipdw.diph ) ) )
    return FALSE;

    // Set saturation.
    dipdw.dwData = JOYSAT;

    if ( FAILED( g_pJoystick2->SetProperty( DIPROP_SATURATION, &dipdw.diph ) ) )
    return FALSE;

	// For axes that are returned, set the DIPROP_RANGE property for the
    // enumerated axis in order to scale min/max values.
    if( pdidoi->dwType & DIDFT_AXIS )
    {
        DIPROPRANGE diprg; 
        diprg.diph.dwSize       = sizeof(DIPROPRANGE); 
        diprg.diph.dwHeaderSize = sizeof(DIPROPHEADER); 
        diprg.diph.dwHow        = DIPH_BYID; 
        diprg.diph.dwObj        = pdidoi->dwType; // Specify the enumerated axis
        diprg.lMin              = -1000; //-60
        diprg.lMax              = 1000; //60
    
      // Set the range for the axis
      if( FAILED( g_pJoystick2->SetProperty( DIPROP_RANGE, &diprg.diph ) ) ) 
      return DIENUM_STOP;         
    }
    // Set the UI to reflect what objects the joystick supports
    if (pdidoi->guidType == GUID_XAxis)
    {
        //EnableWindow( GetDlgItem( hDlg, IDC_X_AXIS ), TRUE );
        //EnableWindow( GetDlgItem( hDlg, IDC_X_AXIS_TEXT ), TRUE );
    }
    if (pdidoi->guidType == GUID_YAxis)
    {
        //EnableWindow( GetDlgItem( hDlg, IDC_Y_AXIS ), TRUE );
        //EnableWindow( GetDlgItem( hDlg, IDC_Y_AXIS_TEXT ), TRUE );
    }
    if (pdidoi->guidType == GUID_ZAxis)
    {
        //EnableWindow( GetDlgItem( hDlg, IDC_Z_AXIS ), TRUE );
        //EnableWindow( GetDlgItem( hDlg, IDC_Z_AXIS_TEXT ), TRUE );
    }
    if (pdidoi->guidType == GUID_RxAxis)
    {
        //EnableWindow( GetDlgItem( hDlg, IDC_X_ROT ), TRUE );
        //EnableWindow( GetDlgItem( hDlg, IDC_X_ROT_TEXT ), TRUE );
    }
    if (pdidoi->guidType == GUID_RyAxis)
    {
        //EnableWindow( GetDlgItem( hDlg, IDC_Y_ROT ), TRUE );
        //EnableWindow( GetDlgItem( hDlg, IDC_Y_ROT_TEXT ), TRUE );
    }
    if (pdidoi->guidType == GUID_RzAxis)
    {
        //EnableWindow( GetDlgItem( hDlg, IDC_Z_ROT ), TRUE );
        //EnableWindow( GetDlgItem( hDlg, IDC_Z_ROT_TEXT ), TRUE );
    }
    if (pdidoi->guidType == GUID_Slider)
    {
        switch( nSliderCount++ )
        {
            case 0 :
                //EnableWindow( GetDlgItem( hDlg, IDC_SLIDER0 ), TRUE );
                //EnableWindow( GetDlgItem( hDlg, IDC_SLIDER0_TEXT ), TRUE );
                break;

            case 1 :
                //EnableWindow( GetDlgItem( hDlg, IDC_SLIDER1 ), TRUE );
                //EnableWindow( GetDlgItem( hDlg, IDC_SLIDER1_TEXT ), TRUE );
                break;
        }
    }
    if (pdidoi->guidType == GUID_POV)
    {
        switch( nPOVCount++ )
        {
            case 0 :
                //EnableWindow( GetDlgItem( hDlg, IDC_POV0 ), TRUE );
                //EnableWindow( GetDlgItem( hDlg, IDC_POV0_TEXT ), TRUE );
                break;

            case 1 :
                //EnableWindow( GetDlgItem( hDlg, IDC_POV1 ), TRUE );
                //EnableWindow( GetDlgItem( hDlg, IDC_POV1_TEXT ), TRUE );
                break;

            case 2 :
                //EnableWindow( GetDlgItem( hDlg, IDC_POV2 ), TRUE );
                //EnableWindow( GetDlgItem( hDlg, IDC_POV2_TEXT ), TRUE );
                break;

            case 3 :
                //EnableWindow( GetDlgItem( hDlg, IDC_POV3 ), TRUE );
                //EnableWindow( GetDlgItem( hDlg, IDC_POV3_TEXT ), TRUE );
                break;
        }
    }

    return DIENUM_CONTINUE;
}

Physical_Joy::Physical_Joy()
{
}
Physical_Joy::~Physical_Joy()
{
}

//-----------------------------------------------------------------------------
// Name: InitDirectInput()
// Desc: Initialize the DirectInput variables.
//-----------------------------------------------------------------------------
HRESULT Physical_Joy::InitDirectInput( HWND hDlg , int num)
{
    HRESULT hr;
	hDlgtemp=hDlg;
	numjoy=num;

    // Register with the DirectInput subsystem and get a pointer
    // to a IDirectInput interface we can use.
    // Create a DInput object
    if( FAILED( hr = DirectInput8Create( GetModuleHandle(NULL), DIRECTINPUT_VERSION, 
                                         IID_IDirectInput8, (VOID**)&g_pDI2, NULL ) ) )
        return -1;
	g_pDI2temp=g_pDI2;
    // Look for a simple joystick we can use for this sample program.
    if( FAILED( hr = g_pDI2->EnumDevices( DI8DEVCLASS_GAMECTRL, 
                                         EnumJoysticksCallback,
                                         NULL, DIEDFL_ATTACHEDONLY ) ) )
        return -1;

    // Make sure we got a joystick
    if( NULL == g_pJoystick2 )
    {
        //ReportInfo("Joystick not found");
		return -1;
    }

    // Set the data format to "simple joystick" - a predefined data format 
    //
    // A data format specifies which controls on a device we are interested in,
    // and how they should be reported. This tells DInput that we will be
    // passing a DIJOYSTATE2 structure to IDirectInputDevice::GetDeviceState().
    if( FAILED( hr = g_pJoystick2->SetDataFormat( &c_dfDIJoystick2 ) ))
        return -1;

    // Set the cooperative level to let DInput know how this device should
    // interact with the system and with other DInput applications but here in RTMAPS we are not dealing with windows.
    
	 //if( FAILED( hr = g_pJoystick2->SetCooperativeLevel( hDlg, DISCL_EXCLUSIVE | 
     //                                                        DISCL_FOREGROUND ) ) )
     //  return hr;

    // Enumerate the joystick objects. The callback function enabled user
    // interface elements for objects that are found, and sets the min/max
    // values property for discovered axes.
    if( FAILED( hr = g_pJoystick2->EnumObjects( EnumObjectsCallback, 
                                                (VOID*)hDlg, DIDFT_ALL ) ) )
        return -1;

    return S_OK;
}

//-----------------------------------------------------------------------------
// Name: UpdateInputState()
// Desc: Get the input device's state and display it.
//-----------------------------------------------------------------------------
HRESULT Physical_Joy::UpdateInputState( HWND hDlg)
{
    HRESULT     hr;
    //TCHAR       strText[512]; // Device state text
    //TCHAR*      str;

    if( NULL == g_pJoystick2 ) 
        return -1;

    // Poll the device to read the current state
    hr = g_pJoystick2->Poll(); 
    if( FAILED(hr) )  
    {
        // DInput is telling us that the input stream has been
        // interrupted. We aren't tracking any state between polls, so
        // we don't have any special reset that needs to be done. We
        // just re-acquire and try again.
        hr = g_pJoystick2->Acquire();
        while( hr == DIERR_INPUTLOST ) 
            hr = g_pJoystick2->Acquire();

        // hr may be DIERR_OTHERAPPHASPRIO or other errors.  This
        // may occur when the app is minimized or in the process of 
        // switching, so just try again later 
        return S_OK; 
    }

    // Get the input's device state
    if( FAILED( hr = g_pJoystick2->GetDeviceState( sizeof(DIJOYSTATE2), &js ) ) )
        return -1; // The device should have been acquired during the Poll()
	//if (!js.rgbButtons[4]) {js.lX=0;js.lY=0;}///////////////////////wii

    return S_OK;
}

//-----------------------------------------------------------------------------
// Name: FreeDirectInput()
// Desc: Initialize the DirectInput variables.
//-----------------------------------------------------------------------------
VOID Physical_Joy::FreeDirectInput()
{
    // Unacquire the device one last time just in case 
    // the app tried to exit while the device is still acquired.
    if( g_pJoystick2 ) 
        g_pJoystick2->Unacquire();
    
    // Release any DirectInput objects.
    SAFE_RELEASE( g_pJoystick2 );
    SAFE_RELEASE( g_pDI2 );
}
void Physical_Joy::RunControlPanel()
{
	if(!g_pDI2) return;
	g_pDI2temp->RunControlPanel(hDlgtemp,NULL);
}