// (c)INRIA 2004   Tony.Noel@inria.fr
// From: Multi-Thread Programming in C++, Mark Walmsley, Springer

#include "windows.h"
#include "thread.h"
#include <process.h>

Thread::Thread ()
{
	started = false;
	detached = false;
}

Thread::~Thread ()
{
	stop ();
}

int Thread::start (Object *param)
{
	if (!started) {
		Thread::param = param;
		if (handle = (void *)_beginthreadex (0, 0, threadFunction, this, 0, &id)) {
			if (detached) {
				CloseHandle (handle);
			}
		}
		started = true;
	}
	return started;
}

static unsigned int __stdcall threadFunction (void* p)
{
	Thread* t = (Thread*)p;
	return (unsigned int)t->core ( (Object*)t->param);
}

Object* Thread::wait ()
{
	unsigned long status = 0;
	if (started && !detached) {
		WaitForSingleObject (handle, INFINITE);
		GetExitCodeThread (handle, &status);
		CloseHandle (handle);
		detached = true;
	}
	return (Object*)status;
}

void Thread::detach ()
{
	if (started && !detached) {
		CloseHandle (handle);
	}
	detached = true;
}

void Thread::stop ()
{
	if (started && !detached) {
		started = false;
		detached = false;
		TerminateThread (handle, 0);
		CloseHandle (handle);			
	}
}

unsigned int Thread::getThreadId ()
{
	return id;
}

unsigned int Thread::getCurrentThreadId ()
{
	return GetCurrentThreadId ();
}

void Thread::sleep (int delay)
{
	Sleep (delay);
}