.PHONY: bird bird-install bird-clean

bird_cflags = ${build_cflags} -Os
bird_target_dir = ${build_install_directory}/sbin
bird_ldflags = ${build_ldflags}

bird/.configured:
	( cd bird && touch configure && rm -f config.cache && \
	  LDFLAGS="${bird_ldflags} -lm" \
	  CFLAGS="${bird_cflags}" \
	  CC="${build_toolchain_prefix}gcc" \
	  AR="${build_toolchain_prefix}ar" \
	  LD="${build_toolchain_prefix}ld" \
	  CXX="${build_toolchain_prefix}g++" \
	  RANLIB="${build_toolchain_prefix}ranlib" \
	  PREFIX=${build_install_directory} \
	  EPREFIX=${build_install_directory} \
	  ./configure --prefix=/ \
	  --host=mips-linux \
	  --build=i686-linux \
	  --endian=big-endian \
	  --disable-memcheck \
	  --disable-client \
	  --sysconfdir=/etc \
         && touch .configured)


bird: bird/.configured
	$(MAKE) -C bird

bird-clean:
	rm -f bird/.configured	
	$(MAKE) -C bird distclean || echo "Ignoring errors"

bird-install: bird
	cp -f bird/bird $(bird_target_dir)/bird
	$(STRIP) $(bird_target_dir)/bird
