.PHONY: boa-openssl boa-openssl-install boa-openssl-clean

boa-openssl: 
	LDFLAGS="${build_ldflags} -L$(BUILDDIR)/apps/open/zlib-1.2.3 -lz \
	-L$(BUILDDIR)/apps/open/openssl" \
	CFLAGS="${build_cflags} -I${BUILDDIR}/apps/open/openssl/include" \
	CC="${build_toolchain_prefix}gcc" \
	AR="${build_toolchain_prefix}ar" \
	CONFIG_USER_BOA_WITH_SSL=1 \
	CONFIG_USER_FORCE_REDIRECT_SSL=1 \
	LIBSSL=-lssl \
	LIBCRYPTO=-lcrypto \
	RANLIB="${build_toolchain_prefix}ranlib" \
	$(MAKE) -C boa

boa-openssl-clean:
	$(MAKE) -C boa clean || echo "Ignoring boa-openssl-clean errors"

boa-openssl-install: boa-openssl
	mkdir -p $(build_install_directory)/sbin/
	cp -f boa/src/boa $(build_install_directory)/sbin/
	$(STRIP) $(build_install_directory)/sbin/boa
	cp -f boa/cert/server.key $(build_install_directory)/usr/etc/
	cp -f boa/cert/server.crt $(build_install_directory)/usr/etc/

