.PHONY: boa boa-install boa-clean

boa: 
	LDFLAGS="${build_ldflags} -L$(BUILDDIR)/apps/open/zlib-1.2.3 -lz \
	-L$(BUILDDIR)/apps/gpl/matrixssl/src" \
	CFLAGS="${build_cflags} -Wall -Wstrict-prototypes \
		-Os -I${BUILDDIR}/apps/gpl" \
	CC="${build_toolchain_prefix}gcc" \
	AR="${build_toolchain_prefix}ar" \
	CONFIG_USER_BOA_WITH_SSL=1 CONFIG_USER_BOA_WITH_MATRIX_SSL_COMPAT=1 \
	CONFIG_USER_FORCE_REDIRECT_SSL=1 \
	LIBMATRIXSSL=-lmatrixssl \
	RANLIB="${build_toolchain_prefix}ranlib" \
	$(MAKE) -C boa

boa-clean:
	$(MAKE) -C boa clean || echo "Ignoring boa-clean errors"

boa-install: boa
	mkdir -p $(build_install_directory)/sbin/
	cp -f boa/src/boa $(build_install_directory)/sbin/
	$(STRIP) $(build_install_directory)/sbin/boa
	cp -f boa/cert/server.key $(build_install_directory)/usr/etc/
	cp -f boa/cert/server.crt $(build_install_directory)/usr/etc/

