.PHONY: bridge-utils-1.2 bridge-utils-1.2-install bridge-utils-1.2-clean

brctl_dir = bridge-utils-1.2
brctl_cflags = ${build_cflags} -Os -g
brctl_ldflags = ${build_ldflags}
brctl_target_dir = ${build_install_directory}/sbin

$(brctl_dir)/.configured:
	(cd $(brctl_dir) && autoconf && touch configure && rm -f config.cache && \
	 LDFLAGS="${brctl_ldflags}" \
	 CFLAGS="${brctl_cflags}" \
	 CC="${build_toolchain_prefix}gcc" \
	 AR="${build_toolchain_prefix}ar" \
	 CXX="${build_toolchain_prefix}g++" \
	 RANLIB="${build_toolchain_prefix}ranlib" \
	 PREFIX=${build_install_directory} \
	 KERNEL_HEADERS="${build_kernel_directory}/include/linux" \
	 ./configure --prefix=/ \
	 --build=i686-linux \
	 --host=mips-linux \
	 --with-linux-headers="${build_kernel_directory}/include" \
         && touch .configured)


bridge-utils-1.2: $(brctl_dir)/.configured
	$(MAKE) -C $(brctl_dir)

bridge-utils-1.2-clean:
	rm -f $(brctl_dir)/.configured
	$(MAKE) -C $(brctl_dir) clean || echo "Ignoring errors"

bridge-utils-1.2-install: bridge-utils-1.2
	cp -f $(brctl_dir)/brctl/brctl $(brctl_target_dir)/brctl
	$(STRIP) $(brctl_target_dir)/brctl
