/* vi: set sw=4 ts=4: */
#include <sys/mman.h>
#include <linux/mtd/mtd.h>

#ifndef CONFIG_FEATURE_RESETD_GPIO_FILE
#error CONFIG_FEATURE_RESETD_GPIO_FILE undefined
#endif
#ifndef CONFIG_FEATURE_RESETD_MTD_PART
#error CONFIG_FEATURE_RESETD_MTD_PART undefined
#endif
#ifndef CONFIG_FEATURE_RESETD_MTD_PART_SIZE
#error CONFIG_FEATURE_RESETD_MTD_PART_SIZE undefined
#endif

/* if reset button is pressed - then clear the
 * cfg partition and reboot
 */
static void check_reset_button(void)
{
#define PX2_GPIO "RTL865Xgpio"
#define DEVICE_MAJOR_EXPERIMENTAL       63
#define IOCTL_GET_GPIO                  _IOR(DEVICE_MAJOR_EXPERIMENTAL, 1, int)
	int fd;
	char btn[2];

	/* check if gpio file contains '0' */
	fd = open(CONFIG_FEATURE_RESETD_GPIO_FILE, O_RDONLY);

	if (fd < 0) return;

	if (strstr(CONFIG_FEATURE_RESETD_GPIO_FILE, PX2_GPIO))
	{
		unsigned int r;
		if (ioctl(fd, IOCTL_GET_GPIO, &r)) {
			close(fd);
			return;
		}
                close(fd);
		if (r & 0x20000000)
		{
		    struct mtd_info_user mtdInfo;
		    struct erase_info_user mtdEraseInfo;

		    message(LOG, "Reseting system configuration, please wait...\n");
                    fd = open(CONFIG_FEATURE_RESETD_MTD_PART, O_RDWR | O_SYNC);
		    if(fd < 0) {
			message(LOG, "Could not open mtd device: <%s>\n", CONFIG_FEATURE_RESETD_MTD_PART);
			return;
		    }

		    if(ioctl(fd, MEMGETINFO, &mtdInfo)) {
			message(LOG, "Could not get MTD device info from <%s>\n", CONFIG_FEATURE_RESETD_MTD_PART);
			close(fd);
			return;
		    }
		    mtdEraseInfo.length = mtdInfo.erasesize;
		    for (mtdEraseInfo.start = 0;
			 mtdEraseInfo.start < mtdInfo.size;
			 mtdEraseInfo.start += mtdInfo.erasesize) {

			ioctl(fd, MEMUNLOCK, &mtdEraseInfo);
			if(ioctl(fd, MEMERASE, &mtdEraseInfo))
			    message(LOG, "Failed to erase block on <%s> at 0x%x\n", CONFIG_FEATURE_RESETD_MTD_PART, mtdEraseInfo.start);
		    }
		    close(fd);
                    reboot_signal(0);
		}
                return;
	}

        if (read(fd, btn, sizeof(btn)) != sizeof(btn)) {
		close(fd);
		return;
	}

	close(fd);

	if (btn[0] == '0') {
		char *addr;

		message(LOG, "Reseting system configuration, please wait...\n");
		fd = open(CONFIG_FEATURE_RESETD_MTD_PART, O_RDWR);

		if (fd < 0) {
			message(LOG, "Unable to open <%s>\n", CONFIG_FEATURE_RESETD_MTD_PART);
			return;
		}
		/* mmap cfg partition. size could be determined by MTDGETINFO ioctl. oh well */
		if ((addr=(char*) mmap(0, CONFIG_FEATURE_RESETD_MTD_PART_SIZE,
						PROT_WRITE, MAP_SHARED, fd, 0)) == MAP_FAILED) {
			message(LOG, "Unable to mmap '%s': %s",
					CONFIG_FEATURE_RESETD_MTD_PART, strerror(errno));
			close(fd);
	 		return;
		}

		/* clear it */
		memset(addr, 0xFF, CONFIG_FEATURE_RESETD_MTD_PART_SIZE);

		/* unmap - it also does sync, right ? */
		munmap(addr, CONFIG_FEATURE_RESETD_MTD_PART_SIZE);
		close(fd);
                sync();

		/* kaboom (c) kaleda */
		reboot_signal(0);
	}

	return;
}
