.PHONY: dropbear dropbear-install dropbear-clean

dropbear_cflags = ${build_cflags} -Os
dropbear_cflags += -DDSS_PRIV_FILENAME="\"\\\"/etc/persistent/dropbear_dss_host_key\\\"\""
dropbear_cflags += -DRSA_PRIV_FILENAME="\"\\\"/etc/persistent/dropbear_rsa_host_key\\\"\""
dropbear_cflags += -DKEX_REKEY_TIMEOUT=1800
dropbear_target_dir = ${build_install_directory}/sbin
dropbear_ldflags = ${build_ldflags}
dropbear_programs = "dropbear dropbearkey dbclient scp"

dropbear/.configured:
	( cd dropbear && touch configure && rm -f config.cache && \
	  LDFLAGS="${dropbear_ldflags} -lm" \
	  CFLAGS="${dropbear_cflags}" \
	  CC="${build_toolchain_prefix}gcc" \
	  AR="${build_toolchain_prefix}ar" \
	  CXX="${build_toolchain_prefix}g++" \
	  RANLIB="${build_toolchain_prefix}ranlib" \
	  PREFIX=${build_install_directory} \
	  EPREFIX=${build_install_directory} \
	  ./configure --prefix=/bin \
	  --host=mips-linux \
	  --build=i686-linux \
	  --disable-largefile \
	  --disable-zlib \
	  --disable-syslog \
	  --disable-shadow \
	  --disable-lastlog \
	  --disable-utmp \
	  --disable-utmpx \
	  --disable-wtmp \
	  --disable-wtmpx \
	  --disable-loginfunc \
	  --disable-pututline \
	  --disable-pututxline \
         && touch .configured)


dropbear: dropbear/.configured
	$(MAKE) -C dropbear PROGRAMS=${dropbear_programs} MULTI=1

dropbear-clean:
	rm -f dropbear/.configured
	$(MAKE) -C dropbear clean || echo "Ignoring errors"

dropbear-install: dropbear
	cp -f dropbear/dropbearmulti $(dropbear_target_dir)/dropbearmulti
	$(STRIP) $(dropbear_target_dir)/dropbearmulti
	cd $(dropbear_target_dir); \
	for fn in `echo $(dropbear_programs)`; do \
		rm -rf $$fn; \
		ln -s dropbearmulti $$fn; \
	done; \
	rm -rf ssh; \
	ln -s dropbearmulti ssh

