.PHONY: hostapd-0.6.3 hostapd-0.6.3-clean \
	hostapd-0.6.3-install

HOSTAPD_0_6_3_DIR = hostapd-0.6.3/hostapd

HOSTAPD_0_6_3_CFLAGS = -Os -Wall -Wstrict-prototypes \
	-I${BUILDDIR}/drivers/madwifi-5.0 \
	-DCONFIG_NO_IFACE_DOWN_CONTROL \
	-DCONFIG_NO_MTU_CONTROL

HOSTAPD_0_6_3_MAKE_ENV= \
	CC=$(build_toolchain_prefix)gcc \
	CONFIG_IAPP=y \
	CONFIG_RSN_PREAUTH=y \
	CONFIG_DRIVER_HOSTAP=y \
	CONFIG_DRIVER_MADWIFI=y \
	CONFIG_NO_STDOUT_DEBUG=y

$(HOSTAPD_0_6_3_DIR)/.patched:
	@for i in $(HOSTAPD_0_6_3_DIR)/patches/*; do \
		echo "[PATCH] Applying: $$i" ; \
		patch -p1 -N -s -d $(HOSTAPD_0_6_3_DIR)/.. < $$i || exit 1; \
	done
	@touch $(HOSTAPD_0_6_3_DIR)/.patched

hostapd-0.6.3: $(HOSTAPD_0_6_3_DIR)/.patched
	rm -f $(HOSTAPD_0_6_3_DIR)/.config
	touch $(HOSTAPD_0_6_3_DIR)/.config
	CFLAGS="$(HOSTAPD_0_6_3_CFLAGS)" \
		$(MAKE) -C $(HOSTAPD_0_6_3_DIR) $(HOSTAPD_0_6_3_MAKE_ENV) \
		hostapd

hostapd-0.6.3-clean:
	$(MAKE) -C $(HOSTAPD_0_6_3_DIR) $(HOSTAPD_0_6_3_MAKE_ENV) clean \
		|| echo "Ignoring errors!"
	@for i in $(HOSTAPD_0_6_3_DIR)/patches/*; do \
		echo "[PATCH] Reversing: $$i" ; \
		patch -p1 -R -N -r /dev/null -s -d $(HOSTAPD_0_6_3_DIR)/.. < $$i \
			|| echo "Ignoring errors!"; \
	done
	rm -f $(HOSTAPD_0_6_3_DIR)/.patched
	
hostapd-0.6.3-install: hostapd-0.6.3
	cp -f $(HOSTAPD_0_6_3_DIR)/hostapd ${build_install_directory}/bin/
	${build_toolchain_prefix}strip ${build_install_directory}/bin/hostapd
	# leave code as it was. Unpatch it after install
	@for i in $(HOSTAPD_0_6_3_DIR)/patches/*; do \
		echo "[PATCH] Reversing: $$i" ; \
		patch -p1 -R -N -r /dev/null -s -d $(HOSTAPD_0_6_3_DIR)/.. < $$i \
			|| echo "Ignoring errors!"; \
	done
	rm -f $(HOSTAPD_0_6_3_DIR)/.patched
