.PHONY: hostapd-openssl hostapd-openssl-clean hostapd-openssl-install

CFLAGS = -Os -Wall -Wstrict-prototypes \
	-I${BUILDDIR}/apps/open/openssl/include
LDFLAGS= -L${BUILDDIR}/apps/open/openssl
HOSTAPD_OPENSSL_MAKE_ENV= CFLAGS_OVERRIDE="$(CFLAGS)" LDFLAGS="$(LDFLAGS)" \
	CROSS=$(build_toolchain_prefix) CONFIG_USE_OPENSSL=y \
	LIB_ZLIB="-L${BUILDDIR}/apps/open/zlib-1.2.3 -lz" PLATFORM=madwifi

hostapd-openssl: hostapd-openssl-clean
	$(MAKE) -C hostap/hostapd $(HOSTAPD_OPENSSL_MAKE_ENV) mkconfig
	$(MAKE) -C hostap/hostapd $(HOSTAPD_OPENSSL_MAKE_ENV) hostapd

hostapd-openssl-clean:
	$(MAKE) -C hostap/hostapd $(HOSTAPD_OPENSSL_MAKE_ENV) clean \
		|| echo "Ignoring errors!"
	$(MAKE) -C hostap/wpasupplicant $(HOSTAPD_OPENSSL_MAKE_ENV) clean \
		|| echo "Ignoring errors!"

hostapd-openssl-install: hostapd-openssl
	cp -f hostap/hostapd/hostapd ${build_install_directory}/bin/
	$(STRIP) ${build_install_directory}/bin/hostapd
