.PHONY: hostapd hostapd-clean hostapd-install

CFLAGS = -Os -Wall -Wstrict-prototypes
HOSTAPD_MAKE_ENV= CFLAGS_OVERRIDE="$(CFLAGS)" \
	CROSS=$(build_toolchain_prefix) PLATFORM=madwifi

hostapd: hostapd-clean
	$(MAKE) -C hostap/hostapd $(HOSTAPD_MAKE_ENV) mkconfig
	$(MAKE) -C hostap/hostapd $(HOSTAPD_MAKE_ENV) hostapd

hostapd-clean:
	$(MAKE) -C hostap/hostapd $(HOSTAPD_MAKE_ENV) clean \
		|| echo "Ignoring errors!"
	$(MAKE) -C hostap/wpasupplicant $(HOSTAPD_MAKE_ENV) clean \
		|| echo "Ignoring errors!"

hostapd-install: hostapd
	cp -f hostap/hostapd/hostapd ${build_install_directory}/bin/
	$(STRIP) ${build_install_directory}/bin/hostapd
