.PHONY: igmpproxy igmpproxy-install igmpproxy-clean

igmpproxy_cflags = ${build_cflags} -Os
igmpproxy_target_dir = ${build_install_directory}/sbin
igmpproxy_ldflags = ${build_ldflags}

igmpproxy/.configured:
	( cd igmpproxy && touch configure && rm -f config.cache && \
	  LDFLAGS="${igmpproxy_ldflags}" \
	  CFLAGS="${igmpproxy_cflags}" \
	  CC="${build_toolchain_prefix}gcc" \
	  AR="${build_toolchain_prefix}ar" \
	  LD="${build_toolchain_prefix}ld" \
	  CXX="${build_toolchain_prefix}g++" \
	  RANLIB="${build_toolchain_prefix}ranlib" \
	  PREFIX=${build_install_directory} \
	  EPREFIX=${build_install_directory} \
	  ./configure --target=mips-linux \
	  --host=mips-linux \
	  --build=i686-linux \
	  --program-prefix="" \
	  --program-suffix="" \
	  --prefix=/usr \
	  --exec-prefix=/usr \
	  --bindir=/bin \
	  --sbindir=/sbin \
	  --libexecdir=/usr/lib \
	  --sysconfdir=/etc \
	  --datadir=/usr/share \
	  --localstatedir=/var \
	  --mandir=/usr/man \
	  --infodir=/usr/info \
         && touch .configured)

igmpproxy: igmpproxy/.configured
	$(MAKE) -C igmpproxy

igmpproxy-clean:
	rm -f igmpproxy/.configured	
	$(MAKE) -C igmpproxy distclean || echo "Ignoring errors"

igmpproxy-install: igmpproxy
	cp -f igmpproxy/src/igmpproxy $(igmpproxy_target_dir)/igmpproxy
	$(STRIP) $(igmpproxy_target_dir)/igmpproxy
