.PHONY: iperf iperf-install iperf-clean

iperf_cflags = ${build_cflags} -Os -g
iperf_target_dir = ${build_install_directory}/sbin
iperf_ldflags = ${build_ldflags} "${build_toolchain_dir}/lib/libstdc++.a" --static

iperf/.configured:
	( cd iperf && touch configure && rm -f config.cache && \
	  ac_cv_func_malloc_0_nonnull=yes \
	  LDFLAGS="${iperf_ldflags} -lm" \
	  CFLAGS="${iperf_cflags}" \
	  CC="${build_toolchain_prefix}gcc" \
	  AR="${build_toolchain_prefix}ar" \
	  CXX="${build_toolchain_prefix}g++" \
	  RANLIB="${build_toolchain_prefix}ranlib" \
	  ./configure --prefix=/usr \
	  --sysconfdir=/etc \
	  --datadir=/usr/share \
	  --host=mips-linux \
	  --build=i686-linux \
	  --disable-ipv6 \
	  --disable-multicast \
	  --disable-threads \
	  --disable-web100 \
         && touch .configured)


iperf: iperf/.configured
	$(MAKE) -C iperf

iperf-clean:
	rm -f iperf/.configured
	$(MAKE) -C iperf clean || echo "Ignoring errors"

iperf-install: iperf
	cp -f iperf/src/iperf $(iperf_target_dir)/iperf
	$(STRIP) $(iperf_target_dir)/iperf
