## parameters begin

if [ $# -ne 20 ]; then
	echo Not enough parameters
	exit
fi

if [ -z "$UPLINK" ] || [ -z "$DOWNLINK" ]; then
        echo UPLINK or DOWNLINK not defined
        exit
fi

CLID=${1}
ADDRESS=${2}  

# total throughput
UPLINK_RATE=${3}kbit
UPLINK_BURST=${4}kbit
UPLINK_CBURST=${5}kbit
UPLINK_HIGH=${6}kbit
UPLINK_HIGH_CEIL=${7}kbit
UPLINK_NORM=${8}kbit
UPLINK_NORM_CEIL=${9}kbit
UPLINK_LOW=${10}kbit
UPLINK_LOW_CEIL=${11}kbit
DOWNLINK_RATE=${12}kbit
DOWNLINK_BURST=${13}kbit
DOWNLINK_CBURST=${14}kbit
DOWNLINK_HIGH=${15}kbit
DOWNLINK_HIGH_CEIL=${16}kbit
DOWNLINK_NORM=${17}kbit
DOWNLINK_NORM_CEIL=${18}kbit
DOWNLINK_LOW=${19}kbit
DOWNLINK_LOW_CEIL=${20}kbit

## parameters end

HEXADDR=0x`IFS="." && for i in $ADDRESS; do printf '%02X' $i; done`
CLASS_BASE=$(($CLID * 10 + 100))
CLASS_HIGH=$(($CLASS_BASE + 1))
CLASS_NORM=$(($CLASS_BASE + 2))
CLASS_LOW=$(($CLASS_BASE + 3))

echo BASE=$CLASS_BASE HIGH=$CLASS_HIGH NORM=$CLASS_NORM LOW=$CLASS_LOW MARK=$HEXADDR


for DEV in $DOWNLINK
do
	echo "add mark $HEXADDR for $ADDRESS on $DEV"
	iptables -t mangle -A PREROUTING -i $DEV -s $ADDRESS -j MARK --set-mark $HEXADDR
done



for DEV in $UPLINK
do
	# base class
	tc class add dev $DEV parent 1:1 classid 1:$CLASS_BASE htb rate $UPLINK_RATE ceil $UPLINK_RATE burst $UPLINK_BURST cburst $UPLINK_CBURST prio 1
	tc qdisc add dev $DEV parent 1:$CLASS_BASE handle $CLASS_BASE: sfq perturb 10
	# class high
	tc class add dev $DEV parent 1:$CLASS_BASE classid 1:$CLASS_HIGH htb rate $UPLINK_HIGH ceil $UPLINK_HIGH_CEIL burst $UPLINK_BURST cburst $UPLINK_CBURST prio 1
	tc qdisc add dev $DEV parent 1:$CLASS_HIGH handle $CLASS_HIGH: sfq perturb 10
	# class normal
	tc class add dev $DEV parent 1:$CLASS_BASE classid 1:$CLASS_NORM htb rate $UPLINK_NORM ceil $UPLINK_NORM_CEIL burst $UPLINK_BURST cburst $UPLINK_CBURST prio 2
	tc qdisc add dev $DEV parent 1:$CLASS_NORM handle $CLASS_NORM: sfq perturb 10
	# class low
	tc class add dev $DEV parent 1:$CLASS_BASE classid 1:$CLASS_LOW htb rate $UPLINK_LOW ceil $UPLINK_LOW_CEIL burst $UPLINK_BURST cburst $UPLINK_CBURST prio 3
	tc qdisc add dev $DEV parent 1:$CLASS_LOW handle $CLASS_LOW: sfq perturb 10

	# filters high
	tc filter add dev $DEV parent 1:0 protocol ip prio 10 u32 match mark $HEXADDR 0xffffffff match ip tos 0x68 0xff flowid 1:$CLASS_HIGH
	tc filter add dev $DEV parent 1:0 protocol ip prio 10 u32 match mark $HEXADDR 0xffffffff match ip tos 0xb8 0xff flowid 1:$CLASS_HIGH
	tc filter add dev $DEV parent 1:0 protocol ip prio 10 u32 match mark $HEXADDR 0xffffffff match ip sport 23 0xff flowid 1:$CLASS_HIGH
	tc filter add dev $DEV parent 1:0 protocol ip prio 10 u32 match mark $HEXADDR 0xffffffff match ip dport 23 0xff flowid 1:$CLASS_HIGH
	tc filter add dev $DEV parent 1:0 protocol ip prio 10 u32 match mark $HEXADDR 0xffffffff match ip sport 53 0xff flowid 1:$CLASS_HIGH
	tc filter add dev $DEV parent 1:0 protocol ip prio 10 u32 match mark $HEXADDR 0xffffffff match ip dport 53 0xff flowid 1:$CLASS_HIGH
	tc filter add dev $DEV parent 1:0 protocol ip prio 10 u32 match mark $HEXADDR 0xffffffff match ip protocol 1 0xff flowid 1:$CLASS_HIGH
	# filters normal
	tc filter add dev $DEV parent 1:0 protocol ip prio 11 u32 match mark $HEXADDR 0xffffffff match ip tos 0x10 0xff flowid 1:$CLASS_NORM
	tc filter add dev $DEV parent 1:0 protocol ip prio 11 u32 match mark $HEXADDR 0xffffffff match ip sport 80 0xff flowid 1:$CLASS_NORM
	tc filter add dev $DEV parent 1:0 protocol ip prio 11 u32 match mark $HEXADDR 0xffffffff match ip dport 80 0xff flowid 1:$CLASS_NORM
	tc filter add dev $DEV parent 1:0 protocol ip prio 11 u32 match mark $HEXADDR 0xffffffff match ip dport 25 0xff flowid 1:$CLASS_NORM
	tc filter add dev $DEV parent 1:0 protocol ip prio 11 u32 match mark $HEXADDR 0xffffffff match ip dport 110 0xff flowid 1:$CLASS_NORM
	tc filter add dev $DEV parent 1:0 protocol ip prio 11 u32 match mark $HEXADDR 0xffffffff match ip dport 119 0xff flowid 1:$CLASS_NORM
	tc filter add dev $DEV parent 1:0 protocol ip prio 11 u32 match mark $HEXADDR 0xffffffff match ip dport 443 0xff flowid 1:$CLASS_NORM
	tc filter add dev $DEV parent 1:0 protocol ip prio 11 u32 match mark $HEXADDR 0xffffffff match ip dport 8000 0xfff8 flowid 1:$CLASS_NORM
	tc filter add dev $DEV parent 1:0 protocol ip prio 11 u32 match mark $HEXADDR 0xffffffff match ip protocol 6 0xff match u8 0x05 0x0f at 0 match u16 0x0000 0xffc0 at 2 \
		match u8 0x10 0xff at 33 flowid 1:$CLASS_NORM
	# filters low
	tc filter add dev $DEV parent 1:0 protocol ip prio 12 u32 match mark $HEXADDR 0xffffffff flowid 1:$CLASS_LOW
done



for DEV in $DOWNLINK
do
	# base class
	tc class add dev $DEV parent 2:1 classid 2:$CLASS_BASE htb rate $DOWNLINK_RATE ceil $DOWNLINK_RATE burst $DOWNLINK_BURST cburst $DOWNLINK_CBURST prio 1
	tc qdisc add dev $DEV parent 2:$CLASS_BASE handle $CLASS_BASE: sfq perturb 10
	# class high
	tc class add dev $DEV parent 2:$CLASS_BASE classid 2:$CLASS_HIGH htb rate $DOWNLINK_HIGH ceil $DOWNLINK_HIGH_CEIL burst $DOWNLINK_BURST cburst $DOWNLINK_CBURST prio 1
	tc qdisc add dev $DEV parent 2:$CLASS_HIGH handle $CLASS_HIGH: sfq perturb 10
	# class normal
	tc class add dev $DEV parent 2:$CLASS_BASE classid 2:$CLASS_NORM htb rate $DOWNLINK_NORM ceil $DOWNLINK_NORM_CEIL burst $DOWNLINK_BURST cburst $DOWNLINK_CBURST prio 2
	tc qdisc add dev $DEV parent 2:$CLASS_NORM handle $CLASS_NORM: sfq perturb 10
	# class low
	tc class add dev $DEV parent 2:$CLASS_BASE classid 2:$CLASS_LOW htb rate $DOWNLINK_LOW ceil $DOWNLINK_LOW_CEIL burst $DOWNLINK_BURST cburst $DOWNLINK_CBURST prio 3
	tc qdisc add dev $DEV parent 2:$CLASS_LOW handle $CLASS_LOW: sfq perturb 10

	# filters high
	tc filter add dev $DEV parent 2:0 protocol ip prio 10 u32 match ip tos 0x68 0xff match ip dst $ADDRESS flowid 2:$CLASS_HIGH
	tc filter add dev $DEV parent 2:0 protocol ip prio 10 u32 match ip tos 0xb8 0xff match ip dst $ADDRESS flowid 2:$CLASS_HIGH
	tc filter add dev $DEV parent 2:0 protocol ip prio 10 u32 match ip sport 23 0xff match ip dst $ADDRESS flowid 2:$CLASS_HIGH
	tc filter add dev $DEV parent 2:0 protocol ip prio 10 u32 match ip dport 23 0xff match ip dst $ADDRESS flowid 2:$CLASS_HIGH
	tc filter add dev $DEV parent 2:0 protocol ip prio 10 u32 match ip protocol 1 0xff match ip dst $ADDRESS flowid 2:$CLASS_HIGH
	# filters normal
	tc filter add dev $DEV parent 2:0 protocol ip prio 11 u32 match ip tos 0x10 0xff match ip dst $ADDRESS flowid 2:$CLASS_NORM
	tc filter add dev $DEV parent 2:0 protocol ip prio 11 u32 match ip sport 80 0xff match ip dst $ADDRESS flowid 2:$CLASS_NORM
	tc filter add dev $DEV parent 2:0 protocol ip prio 11 u32 match ip dport 80 0xff match ip dst $ADDRESS flowid 2:$CLASS_NORM
	tc filter add dev $DEV parent 2:0 protocol ip prio 11 u32 match ip sport 25 0xff match ip dst $ADDRESS flowid 2:$CLASS_NORM
	tc filter add dev $DEV parent 2:0 protocol ip prio 11 u32 match ip sport 110 0xff match ip dst $ADDRESS flowid 2:$CLASS_NORM
	tc filter add dev $DEV parent 2:0 protocol ip prio 11 u32 match ip sport 119 0xff match ip dst $ADDRESS flowid 2:$CLASS_NORM
	tc filter add dev $DEV parent 2:0 protocol ip prio 11 u32 match ip sport 443 0xff match ip dst $ADDRESS flowid 2:$CLASS_NORM
	tc filter add dev $DEV parent 2:0 protocol ip prio 11 u32 match ip sport 8000 0xfff8 match ip dst $ADDRESS flowid 2:$CLASS_NORM
	# filters low
	tc filter add dev $DEV parent 2:0 protocol ip prio 12 u32 match ip dst $ADDRESS flowid 2:$CLASS_LOW
done
