## parameters begin

if [ $# -ne 10 ]; then
	echo Not enough parameters
	exit
fi

DEVICE=${1}
DOWNLINK_RATE=${2}kbit
BURST=${3}kbit
CBURST=${4}kbit
DOWNLINK_HIGH=${5}kbit
DOWNLINK_HIGH_CEIL=${6}kbit
DOWNLINK_NORM=${7}kbit
DOWNLINK_NORM_CEIL=${8}kbit
DOWNLINK_LOW=${9}kbit
DOWNLINK_LOW_CEIL=${10}kbit

## parameters end


## DOWNLINK (lan)
tc qdisc add dev $DEVICE root handle 2:0 htb default 30
tc class add dev $DEVICE parent 2:0 classid 2:1 htb rate $DOWNLINK_RATE ceil $DOWNLINK_RATE
# class 2:10 high
tc class add dev $DEVICE parent 2:1 classid 2:10 htb rate $DOWNLINK_HIGH ceil $DOWNLINK_HIGH_CEIL burst $BURST cburst $CBURST prio 10
tc qdisc add dev $DEVICE parent 2:10 handle 10: sfq perturb 10
# class 2:20 normal
tc class add dev $DEVICE parent 2:1 classid 2:20 htb rate $DOWNLINK_NORM ceil $DOWNLINK_NORM_CEIL burst $BURST cburst $CBURST prio 20
tc qdisc add dev $DEVICE parent 2:20 handle 20: sfq perturb 10
# class 2:30 low
tc class add dev $DEVICE parent 2:1 classid 2:30 htb rate $DOWNLINK_LOW ceil $DOWNLINK_LOW_CEIL burst $BURST cburst $CBURST prio 30
tc qdisc add dev $DEVICE parent 2:30 handle 30: sfq perturb 10


#
# DOWNLINK
#

# HIGH
tc filter add dev $DEVICE parent 2:0 protocol ip prio 100 u32 match ip tos 0x68 0xff flowid 2:10
tc filter add dev $DEVICE parent 2:0 protocol ip prio 100 u32 match ip tos 0xb8 0xff flowid 2:10
tc filter add dev $DEVICE parent 2:0 protocol ip prio 100 u32 match ip sport 23 0xff flowid 2:10
tc filter add dev $DEVICE parent 2:0 protocol ip prio 100 u32 match ip dport 23 0xff flowid 2:10
tc filter add dev $DEVICE parent 2:0 protocol ip prio 100 u32 match ip sport 53 0xff flowid 2:10
tc filter add dev $DEVICE parent 2:0 protocol ip prio 100 u32 match ip dport 53 0xff flowid 2:10
tc filter add dev $DEVICE parent 2:0 protocol ip prio 100 u32 match ip protocol 1 0xff flowid 2:10
# NORMAL
tc filter add dev $DEVICE parent 2:0 protocol ip prio 101 u32 match ip tos 0x10 0xff flowid 2:20
tc filter add dev $DEVICE parent 2:0 protocol ip prio 101 u32 match ip sport 80 0xff flowid 2:20
tc filter add dev $DEVICE parent 2:0 protocol ip prio 101 u32 match ip dport 80 0xff flowid 2:20
tc filter add dev $DEVICE parent 2:0 protocol ip prio 101 u32 match ip sport 25 0xff flowid 2:20
tc filter add dev $DEVICE parent 2:0 protocol ip prio 101 u32 match ip sport 110 0xff flowid 2:20
tc filter add dev $DEVICE parent 2:0 protocol ip prio 101 u32 match ip sport 119 0xff flowid 2:20
tc filter add dev $DEVICE parent 2:0 protocol ip prio 101 u32 match ip sport 443 0xff flowid 2:20
tc filter add dev $DEVICE parent 2:0 protocol ip prio 101 u32 match ip sport 8000 0xfff8 flowid 2:20
tc filter add dev $DEVICE parent 2:0 protocol ip prio 101 u32 match ip protocol 6 0xff match u8 0x05 0x0f at 0 match u16 0x0000 0xffc0 at 2 match u8 0x10 0xff at 33 flowid 2:20

