## parameters begin

if [ $# -ne 10 ]; then
	echo Not enough parameters
	exit
fi

DEVICE=${1}
UPLINK_RATE=${2}kbit
BURST=${3}kbit
CBURST=${4}kbit
UPLINK_HIGH=${5}kbit
UPLINK_HIGH_CEIL=${6}kbit
UPLINK_NORM=${7}kbit
UPLINK_NORM_CEIL=${8}kbit
UPLINK_LOW=${9}kbit
UPLINK_LOW_CEIL=${10}kbit

## parameters end


## UPLINK (wan)
tc qdisc add dev $DEVICE root handle 1:0 htb default 30
tc class add dev $DEVICE parent 1:0 classid 1:1 htb rate $UPLINK_RATE ceil $UPLINK_RATE
# class 1:10 high
tc class add dev $DEVICE parent 1:1 classid 1:10 htb rate $UPLINK_HIGH ceil $UPLINK_HIGH_CEIL burst $BURST cburst $CBURST prio 10
tc qdisc add dev $DEVICE parent 1:10 handle 10: sfq perturb 10
# class 1:20 normal
tc class add dev $DEVICE parent 1:1 classid 1:20 htb rate $UPLINK_NORM ceil $UPLINK_NORM_CEIL burst $BURST cburst $CBURST prio 20
tc qdisc add dev $DEVICE parent 1:20 handle 20: sfq perturb 10
# class 1:30 low
tc class add dev $DEVICE parent 1:1 classid 1:30 htb rate $UPLINK_LOW ceil $UPLINK_LOW_CEIL burst $BURST cburst $CBURST prio 30
tc qdisc add dev $DEVICE parent 1:30 handle 30: sfq perturb 10


#
# UPLINK
#

# HIGH
tc filter add dev $DEVICE parent 1:0 protocol ip prio 100 u32 match ip tos 0x68 0xff flowid 1:10
tc filter add dev $DEVICE parent 1:0 protocol ip prio 100 u32 match ip tos 0xb8 0xff flowid 1:10
tc filter add dev $DEVICE parent 1:0 protocol ip prio 100 u32 match ip sport 23 0xff flowid 1:10
tc filter add dev $DEVICE parent 1:0 protocol ip prio 100 u32 match ip dport 23 0xff flowid 1:10
tc filter add dev $DEVICE parent 1:0 protocol ip prio 100 u32 match ip sport 53 0xff flowid 1:10
tc filter add dev $DEVICE parent 1:0 protocol ip prio 100 u32 match ip dport 53 0xff flowid 1:10
tc filter add dev $DEVICE parent 1:0 protocol ip prio 100 u32 match ip protocol 1 0xff flowid 1:10
# NORMAL
tc filter add dev $DEVICE parent 1:0 protocol ip prio 101 u32 match ip tos 0x10 0xff flowid 1:20
tc filter add dev $DEVICE parent 1:0 protocol ip prio 101 u32 match ip sport 80 0xff flowid 1:20
tc filter add dev $DEVICE parent 1:0 protocol ip prio 101 u32 match ip dport 80 0xff flowid 1:20
tc filter add dev $DEVICE parent 1:0 protocol ip prio 101 u32 match ip dport 25 0xff flowid 1:20
tc filter add dev $DEVICE parent 1:0 protocol ip prio 101 u32 match ip dport 110 0xff flowid 1:20
tc filter add dev $DEVICE parent 1:0 protocol ip prio 101 u32 match ip dport 119 0xff flowid 1:20
tc filter add dev $DEVICE parent 1:0 protocol ip prio 101 u32 match ip dport 443 0xff flowid 1:20
tc filter add dev $DEVICE parent 1:0 protocol ip prio 101 u32 match ip dport 8000 0xfff8 flowid 1:20
tc filter add dev $DEVICE parent 1:0 protocol ip prio 101 u32 match ip protocol 6 0xff \
   match u8 0x05 0x0f at 0 match u16 0x0000 0xffc0 at 2 match u8 0x10 0xff at 33 flowid 1:20


