.PHONY: libpcap libpcap-install libpcap-clean

libpcap_cflags = ${build_cflags} -Os -g
libpcap_target_dir = ${build_install_directory}/lib

libpcap/.configured:
	( cd libpcap && touch configure && rm -f config.cache && \
	  CFLAGS="${libpcap_cflags}" \
	  CC="${build_toolchain_prefix}gcc" \
	  AR="${build_toolchain_prefix}ar" \
	  CXX="${build_toolchain_prefix}g++" \
	  RANLIB="${build_toolchain_prefix}ranlib" \
	  PREFIX=${build_install_directory} \
	  EPREFIX=${build_install_directory} \
	  ./configure --prefix=/usr \
	  --host=mips-linux \
	  --build=i686-linux \
	  --with-pcap=linux \
         && touch .configured)


libpcap: libpcap/.configured
	$(MAKE) -C libpcap

libpcap-clean:
	rm -f libpcap/.configured
	$(MAKE) -C libpcap clean || echo "Ignoring errors"

libpcap-install: libpcap
	cp -a libpcap/libpcap.so* $(libpcap_target_dir)/.
	$(STRIP) $(libpcap_target_dir)/libpcap.so* || echo "Ignore erros!"
