/*
 * MatrixSSL helper functions
 *
 * Copyright (C) 2007 Darius Ivanauskas <dasilt@gmail.com>
 *
 * Full remake of older version from Nicloas Thill. Now it is
 * more OpenSSL compatible, including support for
 * SSL_ERROR_WANT_READ/SSL_ERROR_WANT_WRITE functionality.
 * Also implemented SSL_connect() and SSL_get_error() functions.
 * It was tested with the patched boa web server version and also
 * client utility for triggering https url.
 * 
 * Copyright (C) 2005 Nicolas Thill <nthill@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __MATRIXSSL_HELPER_H__
#define __MATRIXSSL_HELPER_H__

#include "matrixSsl.h"

#define SSL_ERROR_NONE                  0
#define SSL_ERROR_SSL                   1
#define SSL_ERROR_WANT_READ             2
#define SSL_ERROR_WANT_WRITE            3
#define SSL_ERROR_WANT_X509_LOOKUP      4
#define SSL_ERROR_SYSCALL               5 /* look at error stack/return value/errno */
#define SSL_ERROR_ZERO_RETURN           6

typedef struct __SSL {
  int fd;
  ssl_t *ssl;
  sslKeys_t *keys;
  sslBuf_t inbuf, outbuf;
  int status;
  int operation;
  int error;
  int decode_error;
} SSL;

SSL * SSL_new(sslKeys_t *keys);
int SSL_get_error(const SSL *ssl, int ret);
void SSL_set_fd(SSL *ssl, int fd);
#ifdef USE_CLIENT_SIDE_SSL
int SSL_connect(SSL *ssl);
#endif
int SSL_accept(SSL *ssl);
int SSL_read(SSL *ssl, void *buf, int len);
int SSL_write(SSL *ssl, const void *buf, int len);
void SSL_free(SSL *ssl);

#endif /* __MATRIXSSL_HELPER_H__ */
