.PHONY: ntpclient ntpclient-clean ntpclient-install

EXT_CFLAGS = -Os -std=c99 -W -Wall -Wpointer-arith -Wcast-align -Wcast-qual -Wshadow \
 -Waggregate-return -Wnested-externs -Winline -Wwrite-strings -Wstrict-prototypes
# CFLAGS += -DPRECISION_SIOCGSTAMP
EXT_CFLAGS += -DENABLE_DEBUG
EXT_CFLAGS += -DENABLE_REPLAY
EXT_CFLAGS += -DUSE_OBSOLETE_GETTIMEOFDAY

##EXT_LDFLAGS += -lrt

NTPCLIENT_MAKE_ENV= \
	LDFLAGS="${build_ldflags} ${EXT_LDFLAGS}" \
	CFLAGS="${build_cflags} ${EXT_CFLAGS}" \
	CC="${build_toolchain_prefix}gcc" \
	AR="${build_toolchain_prefix}ar"

ntpclient:
	$(MAKE) -C ntpclient $(NTPCLIENT_MAKE_ENV)

ntpclient-clean:
	$(MAKE) -C ntpclient $(NTPCLIENT_MAKE_ENV) clean \
		|| echo "Ignoring errors!"

ntpclient-install: ntpclient
	cp -f ntpclient/ntpclient ${build_install_directory}/bin/
	${build_toolchain_prefix}strip ${build_install_directory}/bin/ntpclient
