.TH pcimodules 8 "@TODAY@" "@VERSION@" "Linux PCI Utilities"
.IX pcimodules
.SH NAME
pcimodules \- List kernel driver modules available for all currently plugged
in PCI devices
.SH SYNOPSIS
.B pcimodules
.RB [ --class class_id ]
.RB [ --classmask mask ]
.RB [ --help ]
.SH DESCRIPTION
.B pcimodules
lists all driver modules for all currently plugged in PCI devices.
.B pcimodules
should be run at boot time, and whenever a PCI device is "hot plugged"
into the system.  This can be done by the following Bourne shell syntax:
.IP
	for module in $(pcimodules) ; do
.IP
		modprobe -s -k "$module"
.IP
	done
.PP
When a PCI device is removed from the system, the Linux kernel will
decrement a usage count on PCI driver module.  If this count drops
to zero (i.e., there are no PCI drivers), then the
.B modprobe -r
process that is normally configured to run from cron every few minutes
will eventually remove the unneeded module.
.PP
The --class and --classmask arguments can be used to limit the search
to certain classes of PCI devices.  This is useful, for example, to
generate a list of ethernet card drivers to be loaded when the kernel
has indicated that it is trying to resolve an unknown network interface.
.PP
Modules are listed in the order in which the PCI devices are physically
arranged so that the computer owner can arrange things like having scsi
device 0 be on a controller that is not alphabetically the first scsi
controller.
.SH OPTIONS
.TP
.B --class class --classmask mask
.PP
--class and --classmask limit the search to PCI
cards in particular classes.  These arguments are always used together.
The arguments to --class and --classmask
can be given as hexadecimal numbers by prefixing a leading "0x".
Note that the classes used by pcimodules are in "Linux" format,
meaning the class value that you see with lspci would be shifted
left eight bits, with the new low eight bits programming interface ID.
An examples of how to use class and classmask is provided below.
.B --help, -h
Print a help message and exit.
.SH EXAMPLES
.TP
pcimodules
lists all modules corresponding to currently plugged in PCI devices.
.TP
pcimodules --class 0x20000 --classmask 0xffff00
lists all modules corresponding to currently plugged in ethernet PCI devices.
.SH FILES
.TP
.B /lib/modules/<kernel-version>/modules.pcimap
This file is automatically generated by
.B depmod,
and used by
.B pcimodules
to determine which modules correspond to which PCI ID's.
.TP
.B /proc/bus/pci
An interface to PCI bus configuration space provided by the post-2.1.82 Linux
kernels. Contains per-bus subdirectories with per-card config space files and a
.I devices
file containing a list of all PCI devices.

.SH SEE ALSO
.BR lspci (8)

.SH MAINTAINER
The Linux PCI Utilities are maintained by Martin Mares <mj@suse.cz>.

.SH AUTHOR
.B pcimodules
was written by Adam J. Richter <adam@yggdrasil.com>, based on public
domain example code by Martin Mares <mj@suse.cz>.

.SH COPYRIGHT
.B pcimodules
is copyright 2000, Yggdrasil Computing, Incorporated, and may
be copied under the terms and conditions of version 2 of the GNU
General Public License as published by the Free Software Foundation
(Cambridge, Massachusetts, United States of America).
