#ifndef __BUFFER_H__
#define __BUFFER_H__

#include <sys/types.h>
#include "list.h"

/* If you need to get some real output - redefine like this: */
/* #define DBG_ERROR(...) fprintf (stderr, __VA_ARGS__) */
#define DBG_ERROR(...)
#define DBG_WARN(...)

#define BUFFER_CHUNK_SIZE 		512
#define BUFFER_INITIAL_CHUNK_SIZE 	(BUFFER_CHUNK_SIZE*4)

struct http_request;
struct buffer_data {
	struct list_head list;
	char  *data;
	size_t size;		/* actual data */
	size_t nread;		/* already read bytes in this bd */
	size_t capacity;	/* buffer capacity */
};

struct buffer
{
	size_t  capacity;		/* total buffer capacity. */
	size_t  size;			/* actual amount of data */
	struct  list_head bd;		/* list of struct buffer_data */

	struct  buffer_data* rbd;	/* current 'read' buffer data chunk */
	struct  buffer_data* wbd;	/* current 'write' buffer data chunk */
};

int buffer_init(struct buffer* buffer);

int buffer_create(struct buffer** buffer);
/**
 * frees buffer_data chunks in buffer and buffer it self.
 * use only with a dynamically created buffers via buffer_create().
 */
int buffer_delete(struct buffer* buffer);

int buffer_write(struct buffer* buffer, const void* data, size_t size);
int buffer_writestr(struct buffer* buffer, const char* str);
int buffer_printf(struct buffer* b, const char* fmt, ...)
    __attribute__((format(printf, 2, 3)));
int buffer_read(struct buffer* buffer, void* data, size_t size);
int buffer_empty(struct buffer* buffer);
int buffer_free(struct buffer* buffer);
int buffer_send(struct buffer* buffer, struct http_request* rq);
int buffer_copy(struct buffer* dst, struct buffer* src);

/*
 * @todo: do we really need this ?
 * int buffer_recv(struct buffer* buffer, struct http_request* rq);
 * int buffer_printf(struct buffer* buffer, const char* format, ...);
 * int buffer_scanf(struct buffer* buffer, const char* format, ...);
 * int buffer_readline(struct buffer* buffer, char* line, size_t size);
 * int buffer_seek(struct buffer* buffer, size_t offset, int seek);
 * int buffer_peek(struct buffer* buffer, void* data, size_t size, size_t offset);
 */

#endif //__BUFFER_H__
