
#include <stdlib.h>
#include <unistd.h>
#include "php.h"
#include "parse.h"

#include "cfg_parser.h"

typedef struct CfgStack {
        cfg_t* cfg;
        char *filename;
        int id;
        struct CfgStack *next;
} CfgStack;

static unsigned int cfg_id = 0;
static CfgStack* cfg_top = NULL;

static char EMPTY_STR[] = "";
static char MINUS_ONE[] = "-1";
static char STR_TRUE[] = "1";
static char STR_FALSE[] = "0";

int CfgStackPush(cfg_t* cfg, char* filename) {
	CfgStack* new = emalloc(0, sizeof(CfgStack));

	new->cfg = cfg;
	new->filename = (char*)estrdup(0, filename);
	new->id = ++cfg_id;
	new->next = cfg_top;
	cfg_top = new;
	return new->id;
}

cfg_t* CfgStackFind(int id) {
	CfgStack* c;

	c = cfg_top;
	while (c) {
		if (c->id == id) return c->cfg;
		c = c->next;
	}

	return NULL;
}

void CfgStackDel(int id) {
	CfgStack *e,*c;

        c = cfg_top;
        e = c;
        while(c) {
                if(c->id == id) {
                        if(c==cfg_top) {
                                cfg_top=c->next;
                                return;
                        } else {
                                e->next = c->next;
                                return;
                        }
                }
                e = c;
                c = c->next;
        }
}

void CfgIsModified(void) {
	Stack *s;
	struct stat st;

	s = Pop();
	if (!s) {
		Error("Stack Error in CfgLoad");
		return;
	}
	if (!*(s->strval)) {
                Push(MINUS_ONE, LNUMBER);
                return;
        }

	memset(&st, 0, sizeof(st));
	if (stat(s->strval, &st) != 0) {
		Push(MINUS_ONE, LNUMBER);
		return;
	}

	if (st.st_mode == 33279) {
		Push(STR_TRUE, LNUMBER);
	} else {
		Push(STR_FALSE, LNUMBER);
	}
}

void CfgSetModified(void) {
	Stack *s;
	int rc;
	char temp[8];

	s = Pop();
	if (!s) {
		Error("Stack Error in CfgLoad");
		return;
	}
	if (!*(s->strval)) {
                Push(MINUS_ONE, LNUMBER);
                return;
        }

	rc = chmod(s->strval, 0777);
	sprintf(temp, "%d", rc);
	Push(temp, LNUMBER);
}

void CfgLoad(void) {
	Stack *s;
	char temp[8];
	cfg_t* cfg = NULL;
	int id;
#define CFG_RETRY_MAX 5
	s = Pop();
	if (!s) {
		Error("Stack Error in CfgLoad");
		return;
	}
	if (!*(s->strval)) {
                Push(MINUS_ONE,LNUMBER);
                return;
        }

	cfg = cfg_parse(s->strval);
	for (id = 0; id < CFG_RETRY_MAX && !cfg; ++id){
			sleep(2);
	    	cfg = cfg_parse(s->strval);
	}
#undef CFG_RETRY_MAX
	if (!cfg) {
		Error("cfg_load(\"%s\") failed", s->strval);
                Push(MINUS_ONE,LNUMBER);
                return;
	}

	id = CfgStackPush(cfg, s->strval);
	sprintf(temp,"%d",id);  
	Push(temp,LNUMBER);
}

void _CfgGet(int mode) {
	Stack* s;
	int id;
	cfg_t* cfg;
	char* def_value = EMPTY_STR;
	char* key;
	char* value;

	if (mode) {
		s = Pop();
		if (!s) {
			Error("Stack Error in CfgGet");
			return;
		}
		if (!*(s->strval)) {
			def_value = EMPTY_STR;
		} else {
			def_value = (char*) estrdup(1, s->strval);
		}
	}

	s = Pop();
	if (!s) {
		Error("Stack Error in CfgGet");
		return;
	}
	if (!*(s->strval)) {
                Push(EMPTY_STR, STRING);
                return;
        }

	key = (char*) estrdup(1, s->strval);

	s = Pop();
	if (!s) {
		Error("Stack error in cfg_get");
		return;
	}
	id = s->intval;

	cfg = CfgStackFind(id);
	if (!cfg) {
		Error("Unable to find configuration by id %d", id);
		Push(EMPTY_STR, STRING);
		return;
	}

	value = (char*)cfg_get_value(cfg, def_value, key);
	Push(AddSlashes(value,1), STRING);
}

void CfgGet(void) {
	_CfgGet(0);
}

void CfgGetDef(void) {
	_CfgGet(1);
}

void CfgSet(void) {
	Stack* s;
	char temp[8];
	int found;
	int id;
	cfg_t* cfg;
	cfg_t* last_cfg;
	char* key;
	char* value;

	s = Pop();
	if (!s) {
		Error("Stack Error in CfgGet");
		return;
	}
	if (!s->strval) {
		Push(EMPTY_STR, STRING);
		return;
	}
	value = (char*) estrdup(1, s->strval);
	StripSlashes(value);

	s = Pop();
	if (!s) {
		Error("Stack Error in CfgGet");
		return;
	}
	if (!*(s->strval)) {
                Push(EMPTY_STR, STRING);
                return;
        }

	key = (char*)estrdup(1, s->strval);

	s = Pop();
	if (!s) {
		Error("Stack error in cfg_get");
		return;
	}
	id = s->intval;

	cfg = CfgStackFind(id);
	if (!cfg) {
		Error("Unable to find configuration by id %d", id);
		Push(EMPTY_STR, STRING);
		return;
	}

	found = 0;
	last_cfg = NULL;
	while (cfg) {
		if (strcmp(cfg->key, key) == 0) {
			free(cfg->value);
			cfg->value = strdup(value);
			found = 1;
			break;
		}
		last_cfg = cfg;
		cfg = cfg->next;
	}
	if (!found) {
		cfg_add(last_cfg, key, value);
	}

	sprintf(temp,"%d",id);  
	Push(temp,LNUMBER);
}

void CfgSave(void) {
	Stack* s;
	char* filename;
	int id;
	cfg_t* cfg;
	FILE* f;

	s = Pop();
	if (!s) {
		Error("Stack Error in CfgSave");
		return;
	}
	if (!*(s->strval)) {
                Push(MINUS_ONE,LNUMBER);
                return;
        }

	filename = (char*) estrdup(1, s->strval);

	s = Pop();
	if (!s) {
		Error("Stack error in cfgsave");
		return;
	}
	id = s->intval;

	cfg = CfgStackFind(id);
	if (!cfg) {
		Error("Unable to find configuration by id %d", id);
		Push(MINUS_ONE, LNUMBER);
		return;
	}

	f = fopen(filename, "w");
	if (!f) {
                Push(MINUS_ONE,LNUMBER);
                return;
	}

	while (cfg) {
		if (strlen(cfg->key))
			fprintf(f, "%s=%s\n", cfg->key, cfg->value);
		cfg = cfg->next;
	}

	fclose(f);
	Push("0", LNUMBER);
}
