#ifndef __CFG_PARSER_H__
#define __CFG_PARSER_H__

typedef struct cfg_
{
	char* key;
	char* value;
	struct cfg_* next;
} cfg_t;

cfg_t* cfg_parse(const char* file_name);
cfg_t* cfg_add(cfg_t* node, const char* key, const char* value);
const char* cfg_get_value(const cfg_t* cfg, const char* default_val, const char* key_frm, ...);
void free_cfg(cfg_t* cfg);

#endif

