#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <linux/if.h>

#include <unistd.h>
#include <stdlib.h>
#include "php.h"
#include "parse.h"

#define __MAC2STR(a) (a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5]
#define __MACSTR "%02X:%02X:%02X:%02X:%02X:%02X"
#define IN_ADDR2STR(a) inet_ntoa(a)

#define REQ_IPADDR	1
#define REQ_HWADDR	2
#define REQ_NETMASK	3

static char EMPTY_STR[] = "";

static int do_ioctl(int fd, const char* ifname, int req, struct ifreq* ifr) {
	int cleanup = 0;
	int rc;
	if (fd == -1) {
		fd = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP);
		if (fd < 0) {
			return -1;
		}

		cleanup = 1;
	}

        strncpy(ifr->ifr_name, ifname, IFNAMSIZ);
        rc = ioctl(fd, req, ifr);

	if (cleanup) {
		close(fd);
	}

	return rc;
}

static int get_ipaddr(int fd, const char* ifname, struct in_addr* addr) {
	struct ifreq ifr;
	int rc;

	memset(&ifr, 0, sizeof(ifr));
	rc = do_ioctl(fd, ifname, SIOCGIFADDR, &ifr);
	if (addr)
		memcpy(addr, &((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr, sizeof(struct in_addr));
	return 0;
}

static int get_netmask(int fd, const char* ifname, struct in_addr* addr) {
	struct ifreq ifr;
	int rc;

	memset(&ifr, 0, sizeof(ifr));
	rc = do_ioctl(fd, ifname, SIOCGIFNETMASK, &ifr);
	if (addr)
		memcpy(addr, &((struct sockaddr_in*)&ifr.ifr_netmask)->sin_addr, sizeof(struct in_addr));
	return 0;
}

static int get_hwaddr(int fd, const char* ifname, unsigned char* hwaddr) {
	struct ifreq ifr;
	int rc;

	memset(&ifr, 0, sizeof(ifr));
	rc = do_ioctl(fd, ifname, SIOCGIFHWADDR, &ifr);
	if (rc < 0)
		return -1;

	if (hwaddr)
		memcpy(hwaddr, &ifr.ifr_hwaddr.sa_data, 6);
	return 0;
}

static int get_flags(int fd, const char* ifname, unsigned int* flags) {
	struct ifreq ifr;
	int rc;

	memset(&ifr, 0, sizeof(ifr));
	rc = do_ioctl(fd, ifname, SIOCGIFFLAGS, &ifr);
	if (rc < 0)
		return -1;

	if (flags)
		*flags = ifr.ifr_flags;

	return 0;
}

void IfaceGet(int req) {
	Stack *s;
	char tmp2[20];
	memset(tmp2, 0, sizeof(tmp2));

	s = Pop();
        if (!s) {
                Error("Stack Error");
                return;
        }
        if (!*(s->strval)) {
                Push(EMPTY_STR, STRING);
                return;
        }
	switch (req) {
	case REQ_IPADDR:
		{
			struct in_addr ip;
			memset(&ip, 0, sizeof(ip));
			if (get_ipaddr(-1, s->strval, &ip)) {
				Push(EMPTY_STR, STRING);
				return;
			}
			snprintf(tmp2, sizeof(tmp2), "%s", IN_ADDR2STR(ip));
			Push(tmp2, STRING);
		}
		break;
	case REQ_HWADDR:
		{
			unsigned char mac[6];
			if (get_hwaddr(-1, s->strval, mac)) {
				Push(EMPTY_STR, STRING);
				return;
			}
			snprintf(tmp2, sizeof(tmp2), __MACSTR, __MAC2STR(mac));
			Push(tmp2, STRING);
		}
		break;
	case REQ_NETMASK:
		{
			struct in_addr ip;
			memset(&ip, 0, sizeof(ip));
			if (get_netmask(-1, s->strval, &ip)) {
				Push(EMPTY_STR, STRING);
				return;
			}
			snprintf(tmp2, sizeof(tmp2), "%s", IN_ADDR2STR(ip));
			Push(tmp2, STRING);
		}
		break;
	}

}

void IfaceGetIpAddr(void) {
	IfaceGet(REQ_IPADDR);
}

void IfaceGetHwAddr(void) {
	IfaceGet(REQ_HWADDR);
}

void IfaceGetNetmask(void) {
	IfaceGet(REQ_NETMASK);
}

void IfaceGetFlags(void) {
	Stack *s;
	char temp[16];
	int mask;
	unsigned int flags;

	s = Pop();
        if (!s) {
                Error("Stack Error");
                return;
        }

	mask = s->intval;
	s = Pop();
        if (!s) {
                Error("Stack Error");
                return;
        }
        if (!*(s->strval)) {
                Push(EMPTY_STR, STRING);
                return;
        }

	if (get_flags(-1, s->strval, &flags)) {
		Push(EMPTY_STR, STRING);
		return;
	}
	snprintf(temp, sizeof(temp), "%u", flags & mask);
	Push(temp, LNUMBER);
}
