#ifndef __UPLOADBUFFER_H__
#define __UPLOADBUFFER_H__

#include "list.h"

struct header
{
	struct list_head list;

	char* name;
	char* value;
	
	int is_file;
	size_t filesize;
};

struct upload_buffer
{
	struct list_head parameters;

	char* upload_path;	/* upload directory */
#define MAX_UPLOADBUFFER	1024*128
	char *buffer;
	size_t size;		/* allocated ub->buffer size */
	size_t data;		/* contains data in ub->buffer */
	size_t total;		/* currently received bytes counter */
	size_t expected;	/* expected content lenght */


#define	GOT_BOUNDARY 		0x0001
#define GOT_HEADER		0x0002
#define GOT_DISPOSITION		0x0004
#define GOT_ENDBOUNDARY		0x8000
	int  got;

	char  *boundary;	/* --'boundary' */
	size_t length;
	int   ignore;		/* if 1, ignore errors on write(2) to file. */

	enum {
		ST_UNKNOWN,	/* content uknown, possibly processing headers. */
		ST_HEADER,	/* HTTP/1.x request header, ended by '\r\n\r\n' */
		ST_PARAMETER,	/* POST'ed parameter content */
		ST_FILE		/* POST'ed file content */
	} state;		/* shows what we are parsing */

	char* parameter;
	struct buffer* content;
	char*  filename;
	size_t filesize;
	int fd;
};

int ub_create(struct upload_buffer** ub);
int ub_init(struct upload_buffer* b, size_t expected, const char* boundary, const char* upload);
void ub_free(struct upload_buffer* b);
int ub_write(struct upload_buffer* b, const void* data, size_t size);

#endif //__UPLOADBUFFER_H__
