#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <net/if.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <sys/select.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include "utils.h"

int convert(const char* str, unsigned int* number)
{
	unsigned int value;
	char *endptr = 0;

	value = strtoul(str, &endptr, 10);
	if (endptr != 0 && *endptr != 0)
		return -1;
	else
		*number	= value;

	return 0;
}

int directory_check_path(const char* path)
{
	struct stat ds;
	size_t size;

	char buffer[1024];
	const char* ptr;
	const char* end;

	if (!path || !strlen(path))
	{
		errno = EINVAL;
		return -1;
	}

	if (stat(path, &ds) == 0 && S_ISDIR(ds.st_mode))
		return 0;

	ptr = path;
	end = path + strlen(path);
	while (ptr < end)
	{

		ptr = strchr(ptr+1, '/');
		if (ptr != 0)
		{
			size = ptr - path;
			memcpy(buffer, path, size);
			buffer[size] = 0;
		}
		else
		{
			size = end - path;
			memcpy(buffer, path, size);
			buffer[size] = 0;
			ptr = end;	/* terminates loop */
		}

		if (stat(buffer, &ds) == 0 && S_ISDIR(ds.st_mode))
		{
			continue;	/* directory exists already */
		}
		else
		{
			if (mkdir(buffer, 0700))
			{
				return -1;
			}
		}
	}

	return 0;
}

static int unhex(char c)
{
	if (c >= '0' && c <= '9')
		return c - '0';
	if (c >= 'a' && c <= 'f')
		return c - 'a' + 10;
	if (c >= 'A' && c <= 'F')
		return c - 'A' + 10;

	return 0;
}

int decode_urlencoded(const char *token, char** decoded)
{
	size_t size = strlen(token);
	char *dptr;
	const char *ptr = token;
	const char *end = token + size;

	*decoded = strdup(token);
	if (!*decoded) return -1;

	dptr = *decoded;

	while (ptr < end)
	{
		if (*ptr == '+')
			*dptr = ' ';
		else if (*ptr == '%')
		{
			if (ptr + 2 <= end   &&
			    isxdigit(ptr[1]) &&
			    isxdigit(ptr[2]))
			{
				*dptr = unhex(ptr[1])*16 + unhex(ptr[2]);
				ptr += 2;
			}
		}
		else
		{
			*dptr = *ptr;
		}

		++ ptr;
		++ dptr;
	}

	*dptr = 0;

	return 0;
}
