#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <linux/types.h>
#include <linux/if.h>

#include <stdlib.h>
#include <unistd.h>
//USE local copy of wireless.h
#include "wireless.h"
#include "php.h"
#include "parse.h"

static char EMPTY_STR[] = "";

static int do_ioctl(int fd, const char* ifname, int req, struct iwreq* wrq) {
	int cleanup = 0;
	int rc;
	if (fd == -1) {
		fd = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP);
		if (fd < 0) {
			return -1;
		}

		cleanup = 1;
	}

        strncpy(wrq->ifr_name, ifname, IFNAMSIZ);
        rc = ioctl(fd, req, wrq);

	if (cleanup) {
		close(fd);
	}

	return rc;
}

static int get_essid(int fd, const char* ifname, char** essid, int essid_len) {
	struct iwreq wrq;
	int rc;

	memset(&wrq, 0, sizeof(wrq));
	wrq.u.essid.pointer = (caddr_t)essid;
        wrq.u.essid.length = essid_len;
        wrq.u.essid.flags = 0;
        rc = do_ioctl(fd, ifname, SIOCGIWESSID, &wrq);
        if (rc < 0) {
                essid[0] = '\0';
        }

	return 0;
}

static int get_txpower(int fd, const char* ifname, int* txpower) {
	struct iwreq          wrq;
	int rc;
	memset(&wrq, 0, sizeof(wrq));

        rc = do_ioctl(fd, ifname, SIOCGIWTXPOW, &wrq);
	if (rc < 0) {
		return -1;
	}
	if (txpower)
		*txpower = wrq.u.txpower.value;
	return 0;
}

static int get_bitrate(int fd, const char* ifname, int* val) {
	struct iwreq          wrq;
	int rc;
	memset(&wrq, 0, sizeof(wrq));

        rc = do_ioctl(fd, ifname, SIOCGIWRATE, &wrq);
	if (rc < 0) {
		return -1;
	}
	if (val)
		*val = wrq.u.bitrate.value;
	return 0;
}

static int get_apmac(int fd, const char* ifname, unsigned char* val) {
	struct iwreq          wrq;
	int rc;
	memset(&wrq, 0, sizeof(wrq));

        rc = do_ioctl(fd, ifname, SIOCGIWAP, &wrq);
	if (rc < 0) {
		return -1;
	}
	if (val)
		memcpy(val, wrq.u.ap_addr.sa_data, 6);
	return 0;

}

static int get_mode(int fd, const char* ifname, int* val) {
	struct iwreq          wrq;
	int rc;
	memset(&wrq, 0, sizeof(wrq));

        rc = do_ioctl(fd, ifname, SIOCGIWMODE, &wrq);
	if (rc < 0) {
		return -1;
	}
	if (val)
	    	*val = wrq.u.mode;
	return 0;
}

#define ESSID 		1
#define TXPOWER 	2
#define RATE		3
#define APMAC		4
#define MODE            5

#define __MAC2STR(a) (a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5]
#define __MACSTR "%02X:%02X:%02X:%02X:%02X:%02X"

static void WirelessGet(int req) {
	Stack *s;
	char temp[8];
	int value = 0;

	s = Pop();
        if (!s) {
                Error("Stack Error");
                return;
        }
        if (!*(s->strval)) {
                Push(EMPTY_STR, STRING);
                return;
        }

	switch (req) {
	case ESSID:
		{
			char essid[40];
			memset(essid, 0, sizeof(essid));
			get_essid(-1, s->strval, (char**)(&essid), sizeof(essid));
			Push(essid, STRING);
		}
		break;
	case TXPOWER:
		{
			if (get_txpower(-1, s->strval, &value)) {
				Push(EMPTY_STR, STRING);
				return;
			}
			snprintf(temp, sizeof(temp), "%d", value);
			Push(temp, LNUMBER);
		}
		break;
	case RATE:
		{
			if (get_bitrate(-1, s->strval, &value)) {
				Push(EMPTY_STR, STRING);
				return;
			}
			snprintf(temp, sizeof(temp), "%d", value);
			Push(temp, LNUMBER);
		}
		break;
	case APMAC:
		{
			unsigned char mac[6];
			char apmac[20];
			if (get_apmac(-1, s->strval, mac)) {
				Push(EMPTY_STR, STRING);
				return;
			}
			snprintf(apmac, sizeof(apmac), __MACSTR, __MAC2STR(mac));
			Push(apmac, STRING);
		}
		break;
	case MODE:
		{
			if (get_mode(-1, s->strval, &value)) {
				Push(EMPTY_STR, STRING);
				return;
			}
			snprintf(temp, sizeof(temp), "%d", value);
			Push(temp, LNUMBER);
		}
		break;
	}
}

void WirelessGetESSID(void) {
	WirelessGet(ESSID);
}

void WirelessGetTxPower(void) {
	WirelessGet(TXPOWER);
}
void WirelessGetRate(void) {
	WirelessGet(RATE);
}

void WirelessGetApMac(void) {
	WirelessGet(APMAC);
}

void WirelessGetMode(void) {
	WirelessGet(MODE);
}
