.PHONY: tcpdump tcpdump-install tcpdump-clean

tcpdump_cflags = ${build_cflags} -Os -g
tcpdump_target_dir = ${build_install_directory}/sbin
tcpdump_ldflags = ${build_ldflags}

tcpdump/.configured:
	( cd tcpdump && touch configure && rm -f config.cache && \
	  LDFLAGS="${tcpdump_ldflags} -lm" \
	  CFLAGS="${tcpdump_cflags}" \
	  CC="${build_toolchain_prefix}gcc" \
	  AR="${build_toolchain_prefix}ar" \
	  CXX="${build_toolchain_prefix}g++" \
	  RANLIB="${build_toolchain_prefix}ranlib" \
	  PREFIX=${build_install_directory} \
	  EPREFIX=${build_install_directory} \
	  ./configure --prefix=/usr \
	  --host=mips-linux \
	  --build=i686-linux \
	  --disable-smb \
	  --disable-ipv6 \
	  --without-crypto \
         && touch .configured)


tcpdump: tcpdump/.configured
	$(MAKE) -C tcpdump

tcpdump-clean:
	rm -f tcpdump/.configured
	$(MAKE) -C tcpdump clean || echo "Ignoring errors"

tcpdump-install: tcpdump
	cp -f tcpdump/tcpdump $(tcpdump_target_dir)/tcpdump
	$(STRIP) $(tcpdump_target_dir)/tcpdump
