#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <net/if.h>
#include <sys/queue.h>

#include <abz/error.h>

#include <tinysnmp/agent/ifcache.h>

#define IFCOUNT	32

LIST_HEAD(ifcache_head, ifcache_entry);

struct ifcache_head head;

struct ifcache_entry
{
	char ifname[IFNAMSIZ];
	unsigned int index;
	LIST_ENTRY(ifcache_entry) entries;
};

void ifcache_init()
{
	char buf[512];
	int ifindex = 0;
	struct ifcache_entry *last = 0;

	FILE *fp = fopen("/proc/net/dev", "r");

	if (fp == NULL)
		return;

	fgets(buf, sizeof(buf), fp);
	fgets(buf, sizeof(buf), fp);

	while (fgets(buf, sizeof(buf), fp))
	{
		struct ifcache_entry *elem;

		char *p = strrchr(buf, ':');
		if (!p)
			continue;

		*p = '\0';
		for (p = buf; isspace(*p); ++p);

		elem = (struct ifcache_entry*) malloc(sizeof(struct ifcache_entry));
		if (elem == 0)
		{
			abz_set_error("out of memory");
			break;
		}

		strncpy(elem->ifname, p, sizeof(elem->ifname));
		elem->index = ++ifindex;

		if (last)
			LIST_INSERT_AFTER(last, elem, entries);
		else
			LIST_INSERT_HEAD(&head, elem, entries);

		last = elem;
	}

	fclose(fp);
}

void ifcache_cleanup()
{
	while (head.lh_first != 0)
	{
		struct ifcache_entry* elem = head.lh_first;
		LIST_REMOVE(head.lh_first, entries);
		free(elem);
	}
}

int ifcache_get_ifindex(const char* const ifname)
{
	struct ifcache_entry *elem;

	if (LIST_EMPTY(&head))
	{
		elem = (struct ifcache_entry*) malloc(sizeof(struct ifcache_entry));
		if (elem == 0)
		{
			abz_set_error("out of memory");
			return 0;
		}

		strncpy(elem->ifname, ifname, sizeof(elem->ifname));
		elem->index = 1;

		LIST_INSERT_HEAD(&head, elem, entries);
	}
	else
	{
		struct ifcache_entry *np, *last;
		for (np = LIST_FIRST(&head); np != NULL; np = LIST_NEXT(np, entries))
		{
			if (strncmp(np->ifname, ifname, sizeof(np->ifname)) == 0)
			{
				return np->index;
			}

			last = np;
		}

		elem = (struct ifcache_entry*) malloc(sizeof(struct ifcache_entry));
		if (elem == 0)
		{
			abz_set_error("out of memory");
			return 0;
		}

		strncpy(elem->ifname, ifname, sizeof(elem->ifname));
		elem->index = last->index + 1;

		LIST_INSERT_AFTER(last, elem, entries);
	}

	return elem->index;
}

